/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class UNTokenCacheUtil {
    private static final TraceComponent tc = Tr.register(UNTokenCacheUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLS_NAME = UNTokenCacheUtil.class.getName();
    private static final String comp = "security.wssecurity";

    public static void invalidatetUNTokenFromCache(MessageContext inmCtx) {
        Subject tSubject;
        MessageContext mCtx;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invalidatetUNTokenFromCache(MessageContext mCtx)");
            }
            mCtx = inmCtx;
            tSubject = null;
            try {
                WSSContext context = WSSContextManagerFactory.getInstance().getSerializableContext();
                if (context != null) {
                    tSubject = context.getRunAsSubject(mCtx);
                }
            }
            catch (SoapSecurityException e1) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.error(tc, "SOAP Security Exception caught while trying to get the context " + e1.getMessage());
            }
        }
        final Subject subject = tSubject;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block12: {
                    try {
                        Set<SecurityTokenWrapper> set = null;
                        if (subject != null) {
                            set = subject.getPrivateCredentials(SecurityTokenWrapper.class);
                        }
                        if (set != null && !set.isEmpty()) {
                            SecurityTokenWrapper stw = null;
                            SecurityToken obj = null;
                            Iterator<SecurityTokenWrapper> it = set.iterator();
                            while (it.hasNext()) {
                                SecurityToken t;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "checking token");
                                }
                                if ((t = (stw = it.next()).getSecurityToken()) == null || !(t instanceof UsernameToken) || stw.getEndPoint() == null || stw.getEndPoint().length() <= 0 || mCtx.getTo().getAddress() == null || !mCtx.getTo().getAddress().equals(stw.getEndPoint())) continue;
                                obj = t;
                                break;
                            }
                            if (obj != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Token found in subject, removing from token cache");
                                }
                                subject.getPrivateCredentials().remove(stw);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Token NOT found in subject!");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "invalid token wrapper set from subject");
                        }
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.error(tc, "Exception caught while remove UsernameToken(s) from the cache " + ex.getMessage());
                    }
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidatetUNTokenFromCache(MessageContext mCtx)");
        }
    }
}

