/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.wssecurity.wssapi.token.KRBToken;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KRB5TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.TGSAuthToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class TokenHolder {
    private static final TraceComponent tc = Tr.register(TokenHolder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenHolder.class.getName();
    public static final String INBOUND_KRBTOKEN = "INBOUND_KRBTOKEN".intern();
    private static final String TGSAUTHTOKEN = "TGSAUTHTOKEN".intern();

    public static String getTokenFromContext(String id, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenFromContext(Token id[" + id + "],  MessageContext messageContext");
        }
        String found_uuid = null;
        if (id.equals("com.ibm.ws.wssecurity.sc.InboundSCT")) {
            found_uuid = (String)Axis2Util.getProperty(messageContext, "com.ibm.ws.wssecurity.sc.InboundSCT");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT uuid in the inbound message context = " + found_uuid);
            }
        } else if (id.equals(INBOUND_KRBTOKEN)) {
            found_uuid = (String)Axis2Util.getProperty(messageContext, INBOUND_KRBTOKEN);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KRBTOKEN uuid in the inbound message context = " + found_uuid);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unexpected property id (" + id + ") received. No action taken.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "This is the uuid from message context = " + found_uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenFromContext(Token id [ " + id + " ], MessageContext messageContext)");
        }
        return found_uuid;
    }

    public static HashMap getPropertyMapFromInboundMessageContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext");
        }
        HashMap pMap = (HashMap)Axis2Util.getProperty(messageContext, "com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", false, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext) returns = " + pMap);
        }
        return pMap;
    }

    public static HashMap getWssPropertyMapFromInboundMessageContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext");
        }
        HashMap pMap = (HashMap)Axis2Util.getProperty(messageContext, "com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyMapFromInboundMessageContext(MessageContext messageContext) returns = " + pMap);
        }
        return pMap;
    }

    public static Set getTokensFromContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokensFromContext(MessageContext messageContext)");
        }
        Object obj1 = null;
        if (messageContext != null) {
            obj1 = messageContext.getProperty("SCT_DIST_CACHE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokensFromContext(MessageContext messageContext)");
        }
        if (obj1 != null && obj1 instanceof HashMap) {
            return ((HashMap)obj1).entrySet();
        }
        return null;
    }

    public static void setTokenToContext(SCT token, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToContext(Token token, Map context)");
        }
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        TokenHolder.setTokenToContext(token, messageContext);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToContext(Token token, Map context)");
        }
    }

    private static void setTokenToContext(SCT token, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenToContext(Token token, MessageContext messageContext)");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token type :" + (token instanceof SCT ? "sct" : "non sct"));
        }
        HashMap<String, SCT> map = null;
        map = (HashMap<String, SCT>)messageContext.getProperty("SCT_DIST_CACHE");
        if (map == null) {
            map = new HashMap<String, SCT>();
        }
        if (token instanceof SCT) {
            map.put(token.getUUID(), token);
        } else {
            map.put(token.getId(), token);
        }
        messageContext.setProperty("SCT_DIST_CACHE", map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenToContext(Token token, MessageContext messageContext)");
        }
    }

    public static void setInboundTokenToContext(KRB5TokenImpl newtoken, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundTokenToContext(SecurityToken token, MessageContext messageContext)");
        }
        messageContext.setProperty(INBOUND_KRBTOKEN, newtoken.getIdentifier());
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            if (newtoken instanceof KRBToken) {
                opCtx.setProperty(INBOUND_KRBTOKEN, newtoken.getIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added token uuid = " + newtoken.getIdentifier() + " to the operation context");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added token uuid = " + newtoken.getIdentifier() + " to the message context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundTokenToContext(SecurityToken token, MessageContext messageContext)");
        }
    }

    public static void setInboundTokenToContext(SCT newsctoken, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundTokenToContext(SecurityContextToken token, MessageContext messageContext)");
        }
        messageContext.setProperty("com.ibm.ws.wssecurity.sc.InboundSCT", newsctoken.getUUID());
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            opCtx.setProperty("com.ibm.ws.wssecurity.sc.InboundSCT", newsctoken.getUUID());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added token uuid = " + newsctoken.getUUID() + " to the operation context using INBOUND_SCTOKEN as key");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added token uuid = " + newsctoken.getUUID() + " to the message context using INBOUND_SCTOKEN as key");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundTokenToContext(SecurityContextToken token, MessageContext messageContext)");
        }
    }

    public static String getInboundTokenFromContext(String str, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundTokenFromContext(String = " + str + ", MessageContext messageContext)");
        }
        String uuid = null;
        if ("com.ibm.ws.wssecurity.sc.InboundSCT".equals(str)) {
            if (messageContext != null) {
                OperationContext opCtx = messageContext.getOperationContext();
                if (opCtx == null) {
                    opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
                }
                if (opCtx != null) {
                    HashMap allMsgCtxs = opCtx.getMessageContexts();
                    Set msgContexts = allMsgCtxs.entrySet();
                    for (Map.Entry singleMsgCtx : msgContexts) {
                        MessageContext tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                        uuid = (String)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.InboundSCT");
                        if (uuid == null) continue;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found SCToken UUID " + uuid + " in the msg ctx with key: " + singleMsgCtx.getKey());
                        break;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found token uuid in the inbound message context = " + str);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundTokenFromContext(String str, MessageContext messageContext) returns " + uuid);
        }
        return uuid;
    }

    public static void setInboundKerberosTokenToContext(TGSAuthToken newtoken, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundTokenToContext(TGSAuthToken newtoken, MessageContext messageContext)");
        }
        messageContext.setProperty(TGSAUTHTOKEN, newtoken);
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            opCtx.setProperty(TGSAUTHTOKEN, newtoken);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added token uuid = " + newtoken.getIdentifier() + " to the message context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundTokenToContext(TGSAuthToken newtoken, MessageContext messageContext)");
        }
    }

    public static TGSAuthToken getKerberosTokenFromContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenFromContext(MessageContext messageContext");
        }
        TGSAuthToken token = (TGSAuthToken)Axis2Util.getProperty(messageContext, TGSAUTHTOKEN);
        String id = null;
        if (token != null) {
            id = token.getSHA1ofAPREQ();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenFromContext( MessageContext messageContext) with " + id);
        }
        return token;
    }
}

