/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.saml.common.SAML11Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class SamlConfigUtils {
    public static String getNormalizedConfirmationMethod(String inMethod, String version) throws SoapSecurityException {
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equalsIgnoreCase(version)) {
            return SamlConfigUtils.normalizeSAML20ConfirmationMethod(inMethod);
        }
        return SamlConfigUtils.normalizeSAML11ConfirmationMethod(inMethod);
    }

    public static String normalizeSAML11ConfirmationMethod(String inMethod) throws SoapSecurityException {
        if (inMethod == null) {
            return inMethod;
        }
        String outMethod = inMethod;
        if (inMethod.equalsIgnoreCase("sender-vouches") || inMethod.equalsIgnoreCase("sendervouches") || inMethod.equalsIgnoreCase("sender vouches") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches")) {
            outMethod = SAML11Constants._SENDER_VOUCHES;
        } else if (inMethod.equalsIgnoreCase("holder-of-key") || inMethod.equalsIgnoreCase("holderofkey") || inMethod.equalsIgnoreCase("holder of keys") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) {
            outMethod = SAML11Constants._HOLDER_OF_KEY;
        } else if (inMethod.equalsIgnoreCase("bearer") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:bearer")) {
            outMethod = SAML11Constants._BEARER;
        } else {
            throw new SoapSecurityException("NOT_SUPPORTED_EXCEPTION");
        }
        return outMethod;
    }

    public static String normalizeSAML20ConfirmationMethod(String inMethod) throws SoapSecurityException {
        if (inMethod == null) {
            return inMethod;
        }
        String outMethod = inMethod;
        if (inMethod.equalsIgnoreCase("sender-vouches") || inMethod.equalsIgnoreCase("sendervouches") || inMethod.equalsIgnoreCase("sender vouches") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches")) {
            outMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        } else if (inMethod.equalsIgnoreCase("holder-of-key") || inMethod.equalsIgnoreCase("holderofkey") || inMethod.equalsIgnoreCase("holder of keys") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key")) {
            outMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        } else if (inMethod.equalsIgnoreCase("bearer") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:cm:bearer")) {
            outMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        } else {
            throw new SoapSecurityException("NOT_SUPPORTED_EXCEPTION");
        }
        return outMethod;
    }
}

