/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML11TokenFactoryImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenFactoryImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class SAMLTokenHelper {
    private static final TraceComponent tc = Tr.register(SAMLTokenHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenHolder.class.getName();
    public static final String SAMLTOKEN = "SAMLTokenHelper.samlToken".intern();
    public static final String SAMLTOKEN_ID = "SAMLTokenHelper.samlToken.Id".intern();

    public static void setSAMLTokenToContext(SAMLToken newtoken, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundTokenToContext(TGSAuthToken newtoken, MessageContext messageContext)");
        }
        messageContext.setProperty(SAMLTOKEN, newtoken);
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            opCtx.setProperty(SAMLTOKEN, newtoken);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added token uuid = " + newtoken.getId() + " to the message context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundTokenToContext(X509Token newtoken, MessageContext messageContext)");
        }
    }

    public static SAMLToken getSAMLTokenFromContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSAMLTokenFromContext(MessageContext messageContext");
        }
        SAMLToken token = (SAMLToken)Axis2Util.getProperty(messageContext, SAMLTOKEN);
        String id = null;
        if (token != null) {
            id = token.getId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSAMLTokenFromContext( MessageContext messageContext) with " + id);
        }
        return token;
    }

    public static void setInboundSAMLTokenAssertionIDToContext(SAMLToken newtoken, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundSAMLTokenAssertionIDToContext(SAMLToken newtoken, MessageContext messageContext)");
        }
        String id = newtoken.getSamlID();
        messageContext.setProperty(SAMLTOKEN_ID, id);
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            opCtx.setProperty(SAMLTOKEN_ID, id);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added token uuid = " + id + " to the message context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundSAMLTokenAssertionIDToContext(SAMLToken newtoken, MessageContext messageContext)");
        }
    }

    public static String getSAMLTokenAssertionIDFromContext(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSAMLTokenAssertionIDFromContext(MessageContext messageContext");
        }
        String uuid = (String)Axis2Util.getProperty(messageContext, SAMLTOKEN_ID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSAMLTokenAssertionIDFromContext( MessageContext messageContext) with " + uuid);
        }
        return uuid;
    }

    public static SAMLToken getSAMLTokenFromSubject(final Subject subject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSAMLTokenFromSubject() entry... " + subject);
        }
        if (subject == null) {
            return null;
        }
        SAMLToken samlToken = null;
        try {
            samlToken = (SAMLToken)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Iterator<SAMLToken> authIterator = subject.getPrivateCredentials(SAMLToken.class).iterator();
                    if (authIterator.hasNext()) {
                        SAMLToken token = authIterator.next();
                        if (token != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SAMLToken: " + token.getSamlID());
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "NO SAMLToken is found to be processed...");
                        }
                        return token;
                    }
                    return null;
                }
            });
            if (samlToken == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find SAMLToken.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found SAMLToken from runAsSubject: " + samlToken);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSAMLTokenFromSubject() exits... ");
            }
            return samlToken;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SAMLToken from Subject.", new Object[]{e});
            }
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
    }

    public static Subject getRunAsSubject(MessageContext messageContext) {
        Subject runAsSubject = null;
        WSSContext secContext = WSSContextFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found a WSSContext: " + secContext.toString());
        }
        if (secContext != null) {
            try {
                runAsSubject = secContext.getRunAsSubject(messageContext);
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get RunAsSubject.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No WSSContext is found. Return.");
        }
        if (tc.isEntryEnabled()) {
            if (runAsSubject != null) {
                Tr.exit(tc, "RunAsSubject NOT null");
            } else {
                Tr.exit(tc, "Not RunAsSubject exists");
            }
        }
        return runAsSubject;
    }

    public static SAMLTokenImpl cloneSAMLToken(SAMLToken token) throws SoapSecurityException {
        SAMLTokenImpl deepCloneSamlToken = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cloneSAMLToken(SAMLToken token)" + token.getValueType().getLocalPart());
        }
        if (token != null && token instanceof SAMLTokenImpl) {
            QName valueType = token.getValueType();
            try {
                String sValueType;
                if (SAMLTokenImpl.saml20ValueType.equals(valueType)) {
                    sValueType = valueType.getLocalPart();
                    SAML20TokenFactoryImpl samlTokenfactory = new SAML20TokenFactoryImpl();
                    deepCloneSamlToken = samlTokenfactory.newSecurityToken(sValueType);
                } else {
                    sValueType = valueType.getLocalPart();
                    SAML11TokenFactoryImpl samlTokenfactory = new SAML11TokenFactoryImpl();
                    deepCloneSamlToken = samlTokenfactory.newSecurityToken(sValueType);
                }
                byte[] bytes = ((SAMLTokenImpl)token).getTokenBytes();
                deepCloneSamlToken.initialize(bytes);
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "cloned Token" + deepCloneSamlToken.getValueType().getLocalPart());
                }
            }
            catch (Exception e) {
                throw new SoapSecurityException(e.getMessage(), e.getCause());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cloneSAMLToken(SAMLToken token)");
        }
        return deepCloneSamlToken;
    }

    public static char[] decodePassword(char[] password) {
        if (password != null && password.length == 0) {
            password = PasswordUtilFactory.getInstance().passwordDecode(new String(password)).toCharArray();
        }
        return password;
    }
}

