/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelperFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.SAMLTokenHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenImpl;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.saml.config.SamlConstants;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.jaxws.BindingProvider;

public class SAMLTokenCacheHelper {
    private static final TraceComponent tc = Tr.register(SAMLTokenCacheHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLTokenCacheHelper.class.getName();
    private static final String CACHE_KEY = "com.ibm.ws.wssecurity.internal.saml.token.collection";
    private static final int default_Cache_Entries = 50;
    public static final String TOKEN_GENERATOR_CONFIG = "com.ibm.ws.wssecurity.saml.internal.tokenGeneratorCfg";
    public static final String WSSUBJECT_EPR = "com.ibm.ws.wssecurity.saml.internal.wssubject.epr";
    public static final String CUSHION = "com.ibm.ws.wssecurity.saml.internal.cushion";
    private static final long default_cacheCushion = 300000L;

    private static Map getTokenMapForGetter(MessageContext msgContext, TokenGeneratorConfig config2) {
        BindingProvider bp = (BindingProvider)msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingProvider is " + bp + ", HashCode=" + bp.hashCode());
        }
        Map<String, Object> requestContext = bp.getRequestContext();
        Map tokensmap = (Map)requestContext.get(CACHE_KEY);
        Map tokenMap = null;
        if (tokensmap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No cache for the BindingProvider:" + bp.hashCode());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is Cache for the BindingProvider:" + bp.hashCode());
            }
            if ((tokenMap = (Map)tokensmap.get(config2)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No cache for the TokenGeneratorConfig:" + config2.hashCode());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found cache for the TokenGeneratorConfig:" + config2.hashCode());
            }
        }
        return tokenMap;
    }

    private static Map getTokenMapForSetter(MessageContext msgContext, TokenGeneratorConfig config2) {
        Map<String, Object> requestContext;
        Map tokensmap;
        BindingProvider bp = (BindingProvider)msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider");
        if (bp == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Not BindingProvider");
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingProvider is " + bp + ", HashCode=" + bp.hashCode());
        }
        if ((tokensmap = (Map)(requestContext = bp.getRequestContext()).get(CACHE_KEY)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No cache for the BindingProvider:" + bp.hashCode());
            }
            tokensmap = Collections.synchronizedMap(new WeakHashMap());
            requestContext.put(CACHE_KEY, tokensmap);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is Cache for the BindingProvider:" + bp.hashCode());
        }
        int limit = SAMLTokenCacheHelper.getSizeLimit(msgContext);
        while (tokensmap.size() > limit) {
            tokensmap.remove(tokensmap.keySet().iterator().next());
        }
        Map tokenMap = (Map)tokensmap.get(config2);
        if (tokenMap == null) {
            tokenMap = Collections.synchronizedMap(new LinkedHashMap());
            tokensmap.put(config2, tokenMap);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenCache exist for TokenGeneratorConfig");
        }
        return tokenMap;
    }

    public static SAMLToken getSAMLToken(MessageContext msgContext, TokenGeneratorConfig config2, long cushion) {
        SAMLTokenImpl token2;
        block15: {
            Map tokensmap = SAMLTokenCacheHelper.getTokenMapForGetter(msgContext, config2);
            if (tokensmap == null || tokensmap.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found no Token cache for the TokenGeneratorConfig" + config2.hashCode());
                }
                return null;
            }
            SAMLToken token = null;
            token2 = null;
            String key = SAMLTokenCacheHelper.getKey(msgContext);
            if (key == null || key.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No ccahe key. No Cache returned.");
                }
                return null;
            }
            token = (SAMLToken)tokensmap.get(key);
            if (token != null) {
                Date exp;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Token from cache " + token.getSamlID());
                    Tr.debug(tc, "Found Token from cache " + token.getSamlExpires());
                }
                if ((exp = token.getSamlExpires()) != null) {
                    Date now = new Date();
                    if (exp.getTime() - now.getTime() > cushion) {
                        try {
                            token2 = SAMLTokenHelper.cloneSAMLToken(token);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found valid token from cache");
                            }
                            break block15;
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "fail to clone Token:" + e.getMessage());
                            }
                            break block15;
                        }
                    }
                    tokensmap.remove(key);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove token:" + token.getSamlID());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No cached token for EndpointAddress" + msgContext.getTo().getAddress());
            }
        }
        return token2;
    }

    public static SAMLToken setSAMLToken(SAMLToken token, MessageContext msgContext, TokenGeneratorConfig config2, long cushion) {
        Map tokensmap = SAMLTokenCacheHelper.getTokenMapForSetter(msgContext, config2);
        String key = SAMLTokenCacheHelper.getKey(msgContext);
        if (key != null && !key.trim().isEmpty()) {
            Date exp = token.getSamlExpires();
            long time = 0L;
            if (exp != null) {
                Date now = new Date();
                time = exp.getTime() - now.getTime();
            }
            if (time > cushion) {
                int limit = SAMLTokenCacheHelper.getSizeLimit(msgContext);
                while (tokensmap.size() > limit) {
                    tokensmap.remove(tokensmap.keySet().iterator().next());
                }
                tokensmap.put(key, token);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cache Token:" + token.getSamlID());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not Cache Token:" + token.getSamlID());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No cache key");
        }
        return token;
    }

    public static void cacheSAMLToken(MessageContext msgContext) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "cacheSAMLToken(MessageContext msgContext)");
        }
        boolean server = true;
        try {
            server = Axis2Util.isServiceProvider(msgContext);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (server) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "cacheSAMLToken(MessageContext msgContext): No cache on receiver side.");
            }
            return;
        }
        SAMLToken token = (SAMLToken)Axis2Util.getProperty(msgContext, SAMLTokenHelper.SAMLTOKEN);
        if (token != null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "cacheSAMLToken: " + token.getSamlID());
            }
            msgContext.setProperty(SamlConstants.SAMLTOKEN_OUT_MESSAGECONTEXT, token);
            TokenGeneratorConfig config2 = (TokenGeneratorConfig)Axis2Util.getProperty(msgContext, TOKEN_GENERATOR_CONFIG);
            if (config2 != null) {
                String key = (String)Axis2Util.getProperty(msgContext, WSSUBJECT_EPR);
                if (key != null && !key.isEmpty()) {
                    Map cachemap = SAMLTokenCacheHelper.getCacheMap(msgContext, config2);
                    SAMLToken token2 = (SAMLToken)cachemap.get(key);
                    if (token2 == null || !token2.getSamlID().equals(token.getSamlID())) {
                        if (tc.isDebugEnabled()) {
                            Tr.entry(tc, "Cache Token:" + token.getSamlID());
                            if (token2 != null) {
                                Tr.debug(tc, "Replace token:" + token2.getSamlID());
                            }
                        }
                        String sCushion = (String)Axis2Util.getProperty(msgContext, CUSHION);
                        long cushion = 300000L;
                        if (sCushion != null) {
                            cushion = Long.parseLong(sCushion);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.entry(tc, "Cache cushion: " + cushion);
                        }
                        SAMLTokenCacheHelper.setSAMLTokenToCache(msgContext, token, cachemap, cushion, key);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cache entry exists.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no cache key.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.entry(tc, "No TokenGeneratorConfig");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.entry(tc, "No SAML Token for cache");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "cacheSAMLToken(MessageContext msgContext)");
        }
    }

    private static Map getCacheMap(MessageContext msgContext, TokenGeneratorConfig config2) {
        Map<String, Object> requestContext;
        Map tokensmap;
        BindingProvider bp = (BindingProvider)Axis2Util.getProperty(msgContext, "org.apache.axis2.jaxws.BindingProvider");
        if (bp == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Not BindingProvider");
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingProvider is " + bp + ", HashCode=" + bp.hashCode());
        }
        if ((tokensmap = (Map)(requestContext = bp.getRequestContext()).get(CACHE_KEY)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No cache for the BindingProvider:" + bp.hashCode());
            }
            tokensmap = Collections.synchronizedMap(new WeakHashMap());
            requestContext.put(CACHE_KEY, tokensmap);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is Cache for the BindingProvider:" + bp.hashCode());
        }
        tokensmap = (Map)requestContext.get(CACHE_KEY);
        int limit = SAMLTokenCacheHelper.getSizeLimit(msgContext);
        while (tokensmap.size() > limit) {
            tokensmap.remove(tokensmap.keySet().iterator().next());
        }
        Map tokenMap = (Map)tokensmap.get(config2);
        if (tokenMap == null) {
            tokenMap = Collections.synchronizedMap(new LinkedHashMap());
            tokensmap.put(config2, tokenMap);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenCache exist for TokenGeneratorConfig");
        }
        return tokenMap;
    }

    private static SAMLToken setSAMLTokenToCache(MessageContext msgContext, SAMLToken token, Map tokensmap, long cushion, String key) {
        if (key != null && tokensmap != null) {
            Date exp = token.getSamlExpires();
            long time = 0L;
            if (exp != null) {
                Date now = new Date();
                time = exp.getTime() - now.getTime();
            }
            if (time > cushion) {
                int limit = SAMLTokenCacheHelper.getSizeLimit(msgContext);
                while (tokensmap.size() > limit) {
                    tokensmap.remove(tokensmap.keySet().iterator().next());
                }
                tokensmap.put(key, token);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cache Token:" + token.getSamlID());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not Cache Token:" + token.getSamlID());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No cache key or No Cache Map.");
        }
        return token;
    }

    public static void setSAMLTokenCacheKeys(SAMLToken token, MessageContext msgContext, TokenGeneratorConfig config2, long cushion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSAMLTokenCacheKeys(SAMLToken token, MessageContext msgContext, TokenGeneratorConfig config, long cushion)");
        }
        String key = SAMLTokenCacheHelper.getKey(msgContext);
        String sCushion = Long.toString(cushion);
        msgContext.setProperty(TOKEN_GENERATOR_CONFIG, config2);
        msgContext.setProperty(CUSHION, sCushion);
        msgContext.setProperty(WSSUBJECT_EPR, key);
        OperationContext opCtx = msgContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)msgContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            opCtx.setProperty(TOKEN_GENERATOR_CONFIG, config2);
            opCtx.setProperty(CUSHION, sCushion);
            opCtx.setProperty(WSSUBJECT_EPR, key);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The operation context is NULL!!!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSAMLTokenCacheKeys( SAMLToken=" + token.getSamlID() + " , MessageContext msgContext, TokenGeneratorConfig config, long cushion=" + sCushion);
        }
    }

    public static void removeCache(MessageContext msgContext) {
        BindingProvider bp = (BindingProvider)msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider");
        if (bp == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not find BindingProvider");
        }
        Map<String, Object> requestContext = bp.getRequestContext();
        requestContext.remove(CACHE_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remove cache for  " + bp + ", HashCode=" + bp.hashCode());
        }
    }

    public static String getKey(MessageContext mCtx) {
        String identifier = null;
        EndpointReference epr = mCtx.getTo();
        String endpointAddress = epr.getAddress();
        Subject subject = SAMLTokenHelper.getRunAsSubject(mCtx);
        int hash = 0;
        if (endpointAddress != null) {
            hash = endpointAddress.hashCode();
        }
        if (subject != null) {
            String id = CacheableSubjectHelperFactory.getInstance().getIdentifier(subject);
            hash = id != null && !id.isEmpty() ? hash * 31 + id.hashCode() : hash * 31 + subject.hashCode();
        }
        if (hash < 0) {
            identifier = "A0" + hash * -1;
        } else if (hash > 0) {
            identifier = "B" + hash;
        }
        return identifier;
    }

    private static int getNumberOfTokenGeneratorConfig(MessageContext msgContext) {
        BindingProvider bp = (BindingProvider)msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider");
        Map<String, Object> requestContext = bp.getRequestContext();
        Map tokensmap = (Map)requestContext.get(CACHE_KEY);
        int size = 1;
        if (tokensmap != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is Cache for the BindingProvider:" + bp.hashCode());
            }
            size = tokensmap.size();
        }
        if (size < 1) {
            size = 1;
        }
        return size;
    }

    private static int getSizeLimit(MessageContext msgContext) {
        BindingProvider bp = (BindingProvider)Axis2Util.getProperty(msgContext, "org.apache.axis2.jaxws.BindingProvider");
        Map<String, Object> requestContext = bp.getRequestContext();
        Object obj = requestContext.get("cacheEntries");
        int limit = 0;
        if (obj != null) {
            limit = Integer.parseInt((String)obj);
        }
        if (limit == 0) {
            limit = 50;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Size limit=" + limit);
        }
        return limit;
    }
}

