/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.platform.trust.server.sts.STSExtensionMapLoader;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import java.util.Iterator;
import java.util.List;

public class QuerySTSPluginProperty {
    private static final String FACTORY_KEY = "com.ibm.ws.wssecurity.platform.stsExtensionMapLoader";
    private static STSExtensionMapLoader _extensionMapLoader = null;
    private static STSExtensionMap extensionMap = null;
    private static TraceComponent tc = Tr.register(QuerySTSPluginProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    private static void init() {
        if (_extensionMapLoader == null) {
            _extensionMapLoader = (STSExtensionMapLoader)WSSecurityFactoryBuilder.getInstance(FACTORY_KEY);
        }
    }

    public static Object query(String propNameToSearch) {
        Tr.entry(tc, "query (propertyName = [ " + propNameToSearch + " ])");
        if (_extensionMapLoader == null) {
            QuerySTSPluginProperty.init();
        }
        try {
            extensionMap = _extensionMapLoader.loadSTSExtensionMap();
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot load trust plugins config to look at property : " + propNameToSearch);
            }
            return null;
        }
        List<Extension> extensionList = extensionMap.getExtension();
        Iterator<Extension> extensionIter = extensionList.iterator();
        Extension extension = null;
        while (extensionIter.hasNext()) {
            Extension currentExtension = extensionIter.next();
            if (!"Security Context Token".equals(currentExtension.getLocalName())) continue;
            extension = currentExtension;
        }
        if (extension == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot load trust plugins config to look at property : " + propNameToSearch);
            }
            return null;
        }
        Configuration config2 = extension.getConfiguration();
        List<Property> properties = config2.getProperty();
        for (Property currentProperty : properties) {
            String propName = currentProperty.getName();
            if (!propName.equals(propNameToSearch)) continue;
            Tr.exit(tc, "query (propertyName) returns : " + currentProperty.getValue());
            return currentProperty.getValue();
        }
        Tr.exit(tc, "query (propertyName) returns NULL");
        return null;
    }
}

