/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.enc.XMLPartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;

public class QNameHeaderSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(QNameHeaderSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    @Override
    public void init(Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String dialect = (String)context.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + dialect + "]");
        }
        if (dialect == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_HEADER.equals(dialect)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        boolean decryption = "decryption_mode".equals((String)obj);
        boolean signature = "signature_mode".equals((String)obj);
        boolean verification = "verification_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + obj + "]");
        }
        String processType = (String)context.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + processType + "]");
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + elements + "]");
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        String actorOrRole = (String)context.get("com.ibm.ws.wssecurity.util.selector.actorOrRole");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Actor/role [" + actorOrRole + "]");
        }
        String headerName = (String)context.get("com.ibm.ws.wssecurity.util.selector.headername");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Header name [" + headerName + "]");
        }
        String headerNamespace = (String)context.get("com.ibm.ws.wssecurity.util.selector.headernamespace");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Header namespace [" + headerNamespace + "]");
        }
        if (headerNamespace == null) {
            throw SoapSecurityException.format("security.wssecurity.QNameHeaderSelector.s01");
        }
        boolean isWsaHeader = false;
        for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
            if (!headerNamespace.equals(Constants.NS_WSADDRS[i])) continue;
            isWsaHeader = true;
            break;
        }
        boolean namespaceFound = false;
        String wsa_ns = null;
        MessageContext messageContext = null;
        if (isWsaHeader) {
            messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (messageContext == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
            }
            wsa_ns = (String)messageContext.getProperty("WSAddressingVersion");
            if (wsa_ns == null || wsa_ns.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Namespace for WS-Addressing [" + wsa_ns + "].");
                }
                namespaceFound = true;
            }
        }
        OMDocument doc = com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil.getOwnerDocument(node);
        OMElement el = doc.getOMDocumentElement();
        ArrayList<OMNode> list = null;
        OMElement header = null;
        header = el instanceof SOAPEnvelope ? ((SOAPEnvelope)el).getHeader() : DOMUtil.getOneChildElement(el, nsSoap, "Header");
        if (encryption || decryption) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing header for encryption with namespace [" + headerNamespace + "] and name [" + headerName + "]");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing header for signature with namespace [" + headerNamespace + "] and name [" + headerName + "]");
        }
        list = new ArrayList<OMNode>();
        if (header != null) {
            list = DOMUtil.getHeadersForNamespace(header, headerNamespace, headerName, actorOrRole, version);
        }
        if (isWsaHeader && list != null && list.size() != 0) {
            if (namespaceFound) {
                if (!headerNamespace.equals(wsa_ns)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WS-Addressing namespace was set to [" + wsa_ns + "] and found namespace [" + headerNamespace + "].");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getElements(OMNode node, Map context)");
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                }
            } else if (!QNameHeaderSelector.isGenerator(context)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No inbound WS-Addressing namespace is set, setting it to [" + headerNamespace + "].");
                }
                messageContext.setProperty("WSAddressingVersion", headerNamespace);
            }
        }
        if (encryption || decryption) {
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
        }
        if (processType != null) {
            if (encryption || signature) {
                list = IntegralDialectElementSelector.postprocess(doc, processType, list, elements, nsWsse, nsWsu, nonceManager, signature, encryption, dialect, null);
            }
            if (encryption && list != null && list.size() > 0) {
                throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", headerNamespace + ":" + headerName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode node, Map context) returns ArrayList[" + list + "]");
        }
        return list;
    }

    private static final boolean isGenerator(Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenerator(Map context)");
        }
        boolean bGenerator = false;
        boolean bConsumer = false;
        Object obj = context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (obj != null) {
            bGenerator = true;
        }
        if ((obj = context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) != null) {
            bConsumer = true;
        }
        if (bGenerator && bConsumer || !bGenerator && !bConsumer) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine generator or consumer");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGenerator(Map context)");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC6734E");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenerator(Map context) returns " + bGenerator);
        }
        return bGenerator;
    }

    private static final boolean isWsaHeader(String headerNamespace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWsaHeader(String headerNamespace)");
        }
        boolean isWsaNamespace = false;
        if (headerNamespace.equals(Constants.NS_WSADDRS[0]) || headerNamespace.equals(Constants.NS_WSADDRS[1])) {
            isWsaNamespace = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWsaHeader(String headerNamespace) returns " + isWsaNamespace);
        }
        return isWsaNamespace;
    }

    @Override
    public ArrayList<XMLElement> getXMLElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<OMNode> orig_list = this.getElements(node, context);
        XMLPartList new_list = new ArrayList();
        if (orig_list != null && orig_list.size() > 0) {
            for (int i = 0; i < orig_list.size(); ++i) {
                OMNode obj = orig_list.get(i);
                XMLElement el = new XMLElement(obj);
                ((ArrayList)new_list).add((XMLElement)el);
            }
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        boolean decryption = "decryption_mode".equals((String)obj);
        if (encryption || decryption) {
            new_list = new XMLPartList("http://www.w3.org/2001/04/xmlenc#Element", new_list);
        }
        return new_list;
    }
}

