/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.platform.util.PlatformContext;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PlatformContextUtil {
    private static final TraceComponent tc = Tr.register(PlatformContextUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static boolean isWebSphereServerProcess = false;
    private static boolean isWebSphereThinClient = false;
    private static boolean initialized = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean initialize() {
        String platform = "com/ibm/ws/wssecurity/platform/websphere/properties/thinclient.properties";
        ClassLoader loader = PlatformContextUtil.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(platform);
        if (in == null) {
            loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            in = loader == null ? ClassLoader.getSystemResourceAsStream(platform) : loader.getResourceAsStream(platform);
        }
        PlatformContext pc = null;
        if (in != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebSphere platform.");
            }
            String classname = "com.ibm.ws.wssecurity.platform.websphere.util.PlatformContextImpl";
            try {
                pc = loader != null ? (PlatformContext)loader.loadClass(classname).newInstance() : (PlatformContext)Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                try {
                    pc = (PlatformContext)Class.forName(classname).newInstance();
                }
                catch (Exception ex) {
                    e.printStackTrace();
                }
            }
            if (pc == null) {
                Tr.error(tc, "Runtime is unable to identify process environment.");
                throw new RuntimeException("Runtime is unable to identify process environment.");
            }
            isWebSphereThinClient = pc.isClientProcess();
            isWebSphereServerProcess = pc.isServerProcess();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not WebSphere platform.");
        }
        initialized = true;
        return true;
    }

    public static boolean isWebSphereServerProcess() {
        if (!initialized) {
            PlatformContextUtil.initialize();
        }
        return isWebSphereServerProcess;
    }

    public static boolean isWebSphereThinClient() {
        if (!initialized) {
            PlatformContextUtil.initialize();
        }
        return isWebSphereThinClient;
    }
}

