/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.ref.SoftReference;

public class ObjectPool<E> {
    private static final TraceComponent tc = Tr.register(ObjectPool.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final int DEFAULT_MINIMUM_CAPACITY = 64;
    public static final int DEFAULT_MAXIMUM_CAPACITY = 256;
    public static final int SOFT_REF_POOL_INITIAL_CAPACITY = 64;
    protected E[] directPool;
    protected int directPoolSize;
    protected SoftReference<E>[] softRefPool;
    protected int softRefPoolSize;
    protected int softRefPoolLimit;

    public ObjectPool() {
        this(64, 256);
    }

    public ObjectPool(int minimumCapacity) {
        this(minimumCapacity, 256);
    }

    public ObjectPool(int minimumCapacity, int maximumCapacity) {
        if (minimumCapacity <= 0) {
            minimumCapacity = 64;
        }
        if (maximumCapacity < minimumCapacity + 64) {
            maximumCapacity = minimumCapacity + 64;
        }
        this.directPool = new Object[minimumCapacity];
        this.directPoolSize = 0;
        this.softRefPoolLimit = maximumCapacity - minimumCapacity;
        this.softRefPool = new SoftReference[64];
        this.softRefPoolSize = 0;
    }

    public synchronized E get() {
        if (this.directPoolSize > 0) {
            --this.directPoolSize;
            E obj = this.directPool[this.directPoolSize];
            this.directPool[this.directPoolSize] = null;
            return obj;
        }
        if (this.softRefPoolSize <= 0) {
            return null;
        }
        --this.softRefPoolSize;
        E obj = this.softRefPool[this.softRefPoolSize].get();
        this.softRefPool[this.softRefPoolSize] = null;
        if (obj != null) {
            return obj;
        }
        if (this.softRefPoolSize <= 0) {
            return null;
        }
        while (this.softRefPoolSize > 0) {
            --this.softRefPoolSize;
            obj = this.softRefPool[this.softRefPoolSize].get();
            this.softRefPool[this.softRefPoolSize] = null;
            if (obj == null) continue;
            this.compact();
            return obj;
        }
        return null;
    }

    public synchronized void put(E obj) {
        if (this.directPoolSize < this.directPool.length) {
            this.directPool[this.directPoolSize] = obj;
            ++this.directPoolSize;
            return;
        }
        if (this.softRefPoolSize >= this.softRefPool.length) {
            if (this.softRefPoolLimit > this.softRefPool.length) {
                this.ensureCapacity();
            } else {
                return;
            }
        }
        this.softRefPool[this.softRefPoolSize++] = new SoftReference<E>(obj);
    }

    public synchronized void clear() {
        int i;
        for (i = 0; i < this.directPoolSize; ++i) {
            this.directPool[i] = null;
        }
        this.directPoolSize = 0;
        for (i = 0; i < this.softRefPoolSize; ++i) {
            this.softRefPool[i] = null;
        }
        this.softRefPoolSize = 0;
    }

    private final boolean ensureCapacity() {
        int newSize = this.softRefPool.length * 2;
        this.softRefPool = this.copyArray(newSize);
        return true;
    }

    private final boolean shurinkCapacity() {
        int newSize = this.softRefPoolSize / 2;
        if (newSize < 64) {
            return false;
        }
        this.softRefPool = this.copyArray(newSize);
        return true;
    }

    private final SoftReference<E>[] copyArray(int newSize) {
        SoftReference[] tPool = new SoftReference[newSize];
        System.arraycopy(this.softRefPool, 0, tPool, 0, this.softRefPoolSize);
        return tPool;
    }

    protected final void compact() {
        int newSize = this.softRefPoolSize;
        block0: for (int i = 0; i < newSize; ++i) {
            if (this.softRefPool[i].get() != null) continue;
            for (int j = newSize - 1; j > i; --j) {
                if (this.softRefPool[j].get() != null) {
                    this.softRefPool[i] = this.softRefPool[j];
                    this.softRefPool[j] = null;
                    newSize = j;
                    continue block0;
                }
                this.softRefPool[j] = null;
            }
            newSize = i;
            break;
        }
        this.softRefPoolSize = newSize;
        if (this.softRefPool.length > this.softRefPoolSize * 2) {
            this.shurinkCapacity();
        }
    }
}

