/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;

public class NamespaceUtil {
    private static final String comp = "security.wssecurity";
    private static final String clsName = NamespaceUtil.class.getName();
    private static final HashMap<QName, QName> expectedTargetNamespaceForTokenType = new HashMap();

    public static int checkSoapVersion(OMNode node, int soapVersion, String localName) {
        if (node.getType() != 1) {
            return -1;
        }
        OMElement el = (OMElement)node;
        return NamespaceUtil.checkVersion(el.getNamespace() == null ? null : el.getNamespace().getName(), el.getLocalName(), 2, soapVersion, localName);
    }

    public static int checkWsseVersion(OMNode node, int wssVersion, String localName) {
        if (node.getType() != 1) {
            return -1;
        }
        OMElement el = (OMElement)node;
        return NamespaceUtil.checkVersion(el.getNamespace() == null ? null : el.getNamespace().getName(), el.getLocalName(), 0, wssVersion, localName);
    }

    public static int checkWsuVersion(OMNode node, int wssVersion, String localName) {
        if (node.getType() != 1) {
            return -1;
        }
        OMElement el = (OMElement)node;
        return NamespaceUtil.checkVersion(el.getNamespace() == null ? null : el.getNamespace().getName(), el.getLocalName(), 1, wssVersion, localName);
    }

    public static int checkWsseVersion(QName qname, int wssVersion, String localName) {
        return NamespaceUtil.checkVersion(qname.getNamespaceURI(), qname.getLocalPart(), 0, wssVersion, localName);
    }

    public static int checkWsuVersion(QName qname, int wssVersion, String localName) {
        return NamespaceUtil.checkVersion(qname.getNamespaceURI(), qname.getLocalPart(), 1, wssVersion, localName);
    }

    private static int checkVersion(String namespaceURI, String localName, int index, int version, String ln) {
        if (localName == null || ln == null) {
            return -1;
        }
        if (!localName.equals(ln)) {
            return -1;
        }
        int getVersion = NamespaceUtil.compareNS(namespaceURI, index);
        if (version >= 0) {
            if (getVersion == version) {
                return version;
            }
        } else if (getVersion >= 0) {
            return getVersion;
        }
        return -1;
    }

    public static int isSoap(String namespace) {
        if (namespace == null) {
            return -1;
        }
        if (namespace.equals(Constants.NS_SOAP)) {
            return 0;
        }
        return namespace.equals(Constants.NS_SOAP12) ? 1 : -1;
    }

    public static int isWsse(String namespace) {
        if (namespace == null) {
            return -1;
        }
        return namespace.equals(Constants.NS_WSSE) ? 0 : -1;
    }

    public static int isWsu(String namespace) {
        if (namespace == null) {
            return -1;
        }
        return namespace.equals(Constants.NS_WSU) ? 0 : -1;
    }

    private static final int compareNS(String namespace, int idx) {
        for (int i = 0; i < Constants.NAMESPACES[idx].length; ++i) {
            if (namespace != Constants.NAMESPACES[idx][i]) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList getWsseElementsByTagName(OMElement elem, String local) {
        return NamespaceUtil.getXElementsByTagName(elem, local, 0);
    }

    private static ArrayList getXElementsByTagName(OMElement elem, String local, int index) {
        ArrayList list = null;
        for (int i = 0; i < Constants.NAMESPACES[index].length; ++i) {
            list = DOMUtil.getElementsByTagNameNS(elem, Constants.NAMESPACES[index][i], local);
            if (list == null || list.size() <= 0) continue;
            return list;
        }
        return list;
    }

    public static ArrayList getWsuElementsByTagName(OMElement elem, String local) {
        return NamespaceUtil.getXElementsByTagName(elem, local, 1);
    }

    public static OMElement getFirstWsseElement(OMElement elem, String local) {
        OMElement child = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            child = DOMUtils.getFirstElement(elem, Constants.NAMESPACES[0][i], local);
            if (child == null) continue;
            return child;
        }
        return child;
    }

    public static OMElement getFirstWsuElement(OMElement elem, String local) {
        OMElement child = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            child = DOMUtils.getFirstElement(elem, Constants.NAMESPACES[1][i], local);
            if (child == null) continue;
            return child;
        }
        return child;
    }

    public static SOAPHeaderBlock getWsseHeaderByName(SOAPEnvelope env, String actor, String local) {
        return NamespaceUtil.getHeaderByName(env, actor, local, 0);
    }

    public static SOAPHeaderBlock getWsuHeaderByName(SOAPEnvelope env, String actor, String local) {
        return NamespaceUtil.getHeaderByName(env, actor, local, 1);
    }

    private static SOAPHeaderBlock getHeaderByName(SOAPEnvelope env, String actor, String local, int idx) {
        SOAPHeaderBlock shb = null;
        for (int i = 0; i < Constants.NAMESPACES[idx].length && (shb = NamespaceUtil.getHeaderByName(env, actor, Constants.NAMESPACES[idx][i], local)) == null; ++i) {
        }
        return shb;
    }

    private static SOAPHeaderBlock getHeaderByName(SOAPEnvelope env, String actor, String namespace, String localPart) {
        SOAPHeader header = env.getHeader();
        Iterator headers = header.examineHeaderBlocks(actor);
        SOAPHeaderBlock shb = null;
        while (headers.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)headers.next();
            if (!hb.getLocalName().equals(localPart) || !hb.getNamespace().getName().equals(namespace)) continue;
            shb = hb;
            break;
        }
        return shb;
    }

    public static String getWsuAttribute(OMElement elem, String name) {
        String value = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            value = elem.getAttributeValue(new QName(Constants.NAMESPACES[1][i], name));
            if (value.length() == 0) continue;
            return value;
        }
        return value;
    }

    public static int checkVersion(QName received, QName inConstants) {
        String inConstLocal;
        if (received == null || inConstants == null) {
            return -1;
        }
        String receivedLocal = received.getLocalPart();
        if (receivedLocal != (inConstLocal = inConstants.getLocalPart())) {
            return -1;
        }
        String receivedNS = received.getNamespaceURI();
        String inConstNS = inConstants.getNamespaceURI();
        if (inConstNS == Constants.NAMESPACES[0][0]) {
            return NamespaceUtil.compareNS(receivedNS, 0);
        }
        if (inConstNS == Constants.NAMESPACES[1][0]) {
            return NamespaceUtil.compareNS(receivedNS, 1);
        }
        return -1;
    }

    public static boolean equals(QName received, QName inConstants) {
        if (received == null || inConstants == null) {
            return false;
        }
        if (received.equals(inConstants)) {
            return true;
        }
        return NamespaceUtil.checkVersion(received, inConstants) > 0;
    }

    public static QName getExpectedTargetNamespaceForTokenType(QName tokenType) {
        QName expectedNS = expectedTargetNamespaceForTokenType.get(tokenType);
        if (expectedNS == null) {
            expectedNS = tokenType;
        }
        return expectedNS;
    }

    static {
        expectedTargetNamespaceForTokenType.put(SAMLCommonConstants._SAML11_TOKENTYPE_QNAME, SAMLCommonConstants._SAML11_QNAME);
        expectedTargetNamespaceForTokenType.put(SAMLCommonConstants._SAML20_TOKENTYPE_QNAME, SAMLCommonConstants._SAML20_QNAME);
    }
}

