/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.LoggerTraceComponentImpl;
import com.ibm.ws.wssecurity.util.Trace;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerTraceImpl
implements Trace {
    private static final String HELPER_CLASS = "com.ibm.ws.logging.LoggerHelper";

    @Override
    public TraceComponent register(Class aClass, String group, String resourceBundleName) {
        Logger logger = Logger.getLogger(aClass.getName(), resourceBundleName);
        if (group != null && group.length() > 0) {
            this.addLoggerToGroup(logger, group);
        }
        return new LoggerTraceComponentImpl(logger);
    }

    private void log(TraceComponent tc, String msg, Level level, Object objs) {
        if (tc != null && tc instanceof LoggerTraceComponentImpl) {
            Logger logger = ((LoggerTraceComponentImpl)tc).getLogger();
            if (objs == null) {
                logger.log(level, msg);
            } else if (objs instanceof Object[]) {
                logger.log(level, msg, (Object[])objs);
            } else {
                logger.log(level, msg, objs);
            }
        }
    }

    private void log(TraceComponent tc, Level level, String msgKey, Object objs) {
        String msg = this.getMessage(tc, msgKey);
        this.log(tc, msg, level, objs);
    }

    @Override
    public void audit(TraceComponent tc, String msgKey) {
        this.log(tc, Level.INFO, msgKey, null);
    }

    @Override
    public void audit(TraceComponent tc, String msgKey, Object objs) {
        this.log(tc, Level.INFO, msgKey, objs);
    }

    @Override
    public void error(TraceComponent tc, String msgKey) {
        this.log(tc, Level.SEVERE, msgKey, null);
    }

    @Override
    public void error(TraceComponent tc, String msgKey, Object objs) {
        this.log(tc, Level.SEVERE, msgKey, objs);
    }

    @Override
    public void info(TraceComponent tc, String msgKey) {
        this.log(tc, Level.INFO, msgKey, null);
    }

    @Override
    public void info(TraceComponent tc, String msgKey, Object objs) {
        this.log(tc, Level.INFO, msgKey, objs);
    }

    @Override
    public void warning(TraceComponent tc, String msgKey) {
        this.log(tc, Level.WARNING, msgKey, null);
    }

    @Override
    public void warning(TraceComponent tc, String msgKey, Object objs) {
        this.log(tc, Level.WARNING, msgKey, objs);
    }

    @Override
    public void debug(TraceComponent tc, String msg) {
        this.log(tc, msg, Level.FINER, null);
    }

    @Override
    public void debug(TraceComponent tc, String msg, Object objs) {
        this.log(tc, msg, Level.FINER, objs);
    }

    @Override
    public void entry(TraceComponent tc, String msg) {
        this.log(tc, msg, Level.FINE, null);
    }

    @Override
    public void entry(TraceComponent tc, String msg, Object objs) {
        this.log(tc, msg, Level.FINE, objs);
    }

    @Override
    public void exit(TraceComponent tc, String msg) {
        this.log(tc, msg, Level.FINE, null);
    }

    @Override
    public void exit(TraceComponent tc, String msg, Object objs) {
        this.log(tc, msg, Level.FINE, objs);
    }

    private String getMessage(TraceComponent tc, String msgKey) {
        Logger logger;
        String msg = null;
        ResourceBundle bundle = null;
        if (tc != null && tc instanceof LoggerTraceComponentImpl && (logger = ((LoggerTraceComponentImpl)tc).getLogger()) != null) {
            bundle = logger.getResourceBundle();
        }
        if (bundle != null) {
            try {
                msg = bundle.getString(msgKey);
            }
            catch (Exception e) {
                msg = msgKey;
            }
        } else {
            msg = ConfigUtil.getMessage(msgKey);
        }
        return msg;
    }

    private void addLoggerToGroup(Logger logger, String group) {
        Method m = _loggerHelper._addLoggerToGroup;
        if (m != null) {
            try {
                m.invoke(null, logger, group);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static Class getLoggerHelperClass() {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = cl != null ? cl.loadClass(HELPER_CLASS) : Class.forName(HELPER_CLASS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private static class _loggerHelper {
        static Method _addLoggerToGroup = null;

        private _loggerHelper() {
        }

        static {
            Class clazz = LoggerTraceImpl.getLoggerHelperClass();
            if (clazz != null) {
                try {
                    _addLoggerToGroup = clazz.getMethod("addLoggerToGroup", Logger.class, String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

