/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.krb5.internal.ktab.KeyTabEntry;
import com.ibm.ws.wssecurity.config.KRBConfig;
import com.ibm.ws.wssecurity.token.KRBCredentialsFactory;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.KRBSPN;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class KRBSPNList {
    private static final TraceComponent tc = Tr.register(KRBSPNList.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private List spnList = new ArrayList();
    private boolean bFirstLoginModPropSearch = true;
    private static KRBSPN defaultSPN = null;

    public KRBSPNList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBSPNList()");
        }
        this.loadProvSPN();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBSPNList()");
        }
    }

    private void loadProvSPN() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadProvSPN()");
        }
        this.getKeyTabEntries();
        KRBCredentialsFactory.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadProvSPN()");
        }
    }

    public KRBSPN getSPN(Map configProperties, int configLocation) {
        String servicePrincipalName = null;
        String kerberosRealm = null;
        KRBSPN spnObj = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSPN()");
        }
        if (configProperties != null) {
            servicePrincipalName = (String)configProperties.get("com.ibm.wsspi.wssecurity.auth.ServiceName");
            kerberosRealm = this.getKerberosRealm(configProperties, configLocation);
        }
        spnObj = this.getSPN(servicePrincipalName, kerberosRealm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSPN()");
        }
        return spnObj;
    }

    private String getKerberosRealm(Map configProperties, int configLocation) {
        String kerberosRealm = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosRealm()");
        }
        if (configProperties != null) {
            kerberosRealm = (String)configProperties.get("com.ibm.wsspi.wssecurity.auth.KerberosRealm");
        }
        if (kerberosRealm == null) {
            if (defaultSPN != null) {
                kerberosRealm = defaultSPN.getKerberosRealm();
            }
            if (kerberosRealm == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client has no service kerberosRealm configured");
                }
                Tr.error(tc, "kerberos.property.notset", new Object[]{"com.ibm.wsspi.wssecurity.auth.KerberosRealm", KRBSPNList.getConfigLocationString(configLocation)});
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client using kerberosRealm [" + kerberosRealm + "]");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client has kerberosRealm configured [" + kerberosRealm + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosRealm()");
        }
        return kerberosRealm;
    }

    public KRBSPN getSPN(String servicePrincipalName, String kerberosRealm) {
        KRBSPN spnObj = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSPN(serviceName, kerberosRealm)");
        }
        if (servicePrincipalName == null) {
            if (defaultSPN != null) {
                spnObj = defaultSPN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client has provided service Principal Name [" + servicePrincipalName + "]");
            }
            spnObj = this.findOrAddSPN(servicePrincipalName, kerberosRealm);
        }
        if (spnObj == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client has no service principal or invalid pricipal configured");
            }
            Tr.error(tc, "service.name.not.configured", servicePrincipalName);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client using SPN name [" + spnObj.getServicePrincipalName() + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSPN(serviceName, kerberosRealm)");
        }
        return spnObj;
    }

    private static String getConfigLocationString(int configLocation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigLocationString()");
        }
        String configLocationLabel = "";
        switch (configLocation) {
            case 0: {
                configLocationLabel = "JAAS Login Module";
                break;
            }
            case 1: {
                configLocationLabel = "Token Consumer";
                break;
            }
            default: {
                configLocationLabel = "Token Generator";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigLocationString()");
        }
        return configLocationLabel;
    }

    public KRBConfig getSPNConfig(KRBSPN spnObj, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSPNConfig()");
        }
        KRBConfig config2 = null;
        if (spnObj != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SPN Passed In [" + spnObj.getServicePrincipalName() + "]");
            }
            if (this.bFirstLoginModPropSearch) {
                this.checkLoginModProps(options);
            }
            config2 = spnObj.getConfig();
        } else {
            Tr.error(tc, "kerberos.invalid.parm", "KRBSPN Passed In As NULL");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSPNConfig()");
        }
        return config2;
    }

    public Credentials getSPNCreds(KRBSPN spnObj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSPNCreds()");
        }
        Credentials creds = null;
        if (spnObj != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SPN Passed In [" + spnObj.getServicePrincipalName() + "]");
            }
            creds = spnObj.getServerCreds();
        } else {
            Tr.error(tc, "kerberos.invalid.parm", "KRBSPN Passed In As NULL");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSPNCreds()");
        }
        return creds;
    }

    private void getKeyTabEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyTabEntries()");
        }
        try {
            final KeyTab keyTab = KeyTab.getInstance();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (keyTab == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not get KeyTab Instance");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Obtained KeyTab Instance");
                        }
                        Integer kverNo = null;
                        String spn = null;
                        String kerberosRealm = null;
                        String servicePrincipalName = null;
                        KeyTabEntry[] ktabRec = keyTab.getEntries();
                        if (ktabRec != null && ktabRec.length > 0) {
                            for (int i = 0; i < ktabRec.length; ++i) {
                                KRBSPN spnObj;
                                boolean createSuccess;
                                kverNo = new Integer(ktabRec[i].getKey().getKeyVersionNumber());
                                spn = ktabRec[i].getService().toString();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "kverno " + kverNo + " spn [" + spn + "]");
                                }
                                if (createSuccess = (spnObj = new KRBSPN()).setSPN(servicePrincipalName = KRB5Util.stripOutPrincipalName(spn), kerberosRealm = KRB5Util.stripOutRealmName(spn))) {
                                    if (i == 0) {
                                        defaultSPN = new KRBSPN();
                                        defaultSPN.setCurrentDefaultSPN(spnObj);
                                        KRBSPNList.this.spnList.add(defaultSPN);
                                    }
                                    KRBSPNList.this.spnList.add(spnObj);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Custom SPN added to list[" + servicePrincipalName + "]");
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Not able to add custom SPN to list [" + servicePrincipalName + "]");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No SPN Records");
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            Tr.warning(tc, "No Keytab information was processed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyTabEntries()");
        }
    }

    private KRBSPN findSPN(String servicePrincipalName, String kerberosRealm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSPN()");
        }
        KRBSPN spnObj = null;
        KRBSPN spnObjTmp = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Find In SPNList - SPN[" + servicePrincipalName + "]");
        }
        for (int i = 0; i < this.spnList.size(); ++i) {
            spnObjTmp = (KRBSPN)this.spnList.get(i);
            if (spnObjTmp.isDefaultSPN() || !spnObjTmp.getServicePrincipalName().equals(servicePrincipalName) || !spnObjTmp.getKerberosRealm().equals(kerberosRealm)) continue;
            spnObj = spnObjTmp;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Found match to SPN[" + servicePrincipalName + "]");
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SPN Returned in findSPN[" + spnObj + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findSPN()");
        }
        return spnObj;
    }

    private KRBSPN findOrAddSPN(String servicePrincipalName, String kerberosRealm) {
        KRBSPN spnObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrAddSPN()");
        }
        if ((spnObj = this.findSPN(servicePrincipalName, kerberosRealm)) == null) {
            spnObj = new KRBSPN();
            boolean createSuccess = spnObj.setSPN(servicePrincipalName, kerberosRealm);
            if (createSuccess) {
                this.spnList.add(spnObj);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom SPN added to list[" + servicePrincipalName + "]");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not able to add custom SPN to list [" + servicePrincipalName + "]");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SPN Found In SPNList [" + spnObj.getFQServiceName() + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrAddSPN()");
        }
        return spnObj;
    }

    public void checkLoginModProps(Map configProperties) {
        String kerberosRealm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkLoginModProps()");
        }
        this.bFirstLoginModPropSearch = false;
        String servicePrincipalName = (String)configProperties.get("com.ibm.wsspi.wssecurity.auth.ServiceName");
        KRBSPN spnObj = this.findSPN(servicePrincipalName, kerberosRealm = this.getKerberosRealm(configProperties, 0));
        if (spnObj != null) {
            defaultSPN.setCurrentDefaultSPN(spnObj);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServiceName defined as loginModule property has no keytab entry: [" + servicePrincipalName + "]");
            }
            Tr.error(tc, "kerberos.spn.init.failed", servicePrincipalName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkLoginModProps()");
        }
    }
}

