/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.security.krb5.Credentials;
import com.ibm.ws.wssecurity.config.KRBConfig;
import com.ibm.ws.wssecurity.config.KRBConfigException;
import com.ibm.ws.wssecurity.token.KRBCredentialsFactory;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public final class KRBSPN {
    private static TraceComponent tc = Tr.register(KRBSPN.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private KRBConfig config = null;
    private Credentials serverCreds = null;
    private String servicePrincipalName = null;
    private String kerberosRealm = null;
    private boolean bIsProvSPN = false;
    private boolean bIsInitialized = false;
    private boolean bDefaultSPN = false;
    private KRBSPN currentDefaultSPN = null;
    public static final String GSS_NAME_TYPE = ".GSSNameType";
    public static final String GSS_CRED_TYPE = ".GSSCredType";
    public static final String GSS_CRED_DURATION = ".GSSCredDuration";
    public static final String TRIM_USER_NAME = ".TrimUserName";

    public KRBSPN() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBSPN()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBSPN()");
        }
    }

    public boolean setSPN(String servicePrincipalName, String kerberosRealm) {
        boolean succeedStatus = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSPN(name, realm)");
        }
        this.servicePrincipalName = servicePrincipalName;
        this.kerberosRealm = kerberosRealm;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSPN(name, realm)");
        }
        return succeedStatus;
    }

    private synchronized boolean initializeService() {
        boolean succeedStatus = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeService()");
        }
        if (!this.bIsInitialized) {
            try {
                this.buildConfig();
                if (this.config != null) {
                    succeedStatus = KRBCredentialsFactory.initializeServer(this.config);
                    this.serverCreds = Credentials.getServiceCreds((String)this.config.getServiceName(), null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Successfully created server credential for " + this.servicePrincipalName);
                    }
                    this.bIsInitialized = true;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, KRBSPN.class.getName(), "1");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught: " + KRB5Util.stackToString(t));
                }
                succeedStatus = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeService()");
        }
        return succeedStatus;
    }

    public boolean isProvSPN() {
        return this.bIsProvSPN;
    }

    private boolean isInitialized() {
        return this.bIsInitialized;
    }

    private void buildConfig() throws KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildConfig()");
        }
        if (this.config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "property root = com.ibm.wsspi.wssecurity.auth");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servicePrincipalName = " + this.servicePrincipalName);
            }
            KRBConfig tempConfig = new KRBConfig();
            tempConfig.setRealm(this.kerberosRealm);
            tempConfig.setServiceName(this.servicePrincipalName);
            this.config = tempConfig;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Config obtained: " + this.config.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildConfig()");
        }
    }

    public KRBConfig getConfig() {
        KRBConfig currConfig = null;
        if (this.bDefaultSPN) {
            if (!this.currentDefaultSPN.isInitialized()) {
                this.currentDefaultSPN.initializeService();
            }
            currConfig = this.currentDefaultSPN.getConfig();
        } else {
            if (!this.isInitialized()) {
                this.initializeService();
            }
            currConfig = this.config;
        }
        return currConfig;
    }

    public Credentials getServerCreds() {
        if (this.bDefaultSPN) {
            if (!this.currentDefaultSPN.isInitialized()) {
                this.currentDefaultSPN.initializeService();
            }
            return this.currentDefaultSPN.getServerCreds();
        }
        if (!this.isInitialized()) {
            this.initializeService();
        }
        return this.serverCreds;
    }

    public String getServicePrincipalName() {
        if (this.bDefaultSPN) {
            return this.currentDefaultSPN.getServicePrincipalName();
        }
        return this.servicePrincipalName;
    }

    public String getKerberosRealm() {
        if (this.bDefaultSPN) {
            return this.currentDefaultSPN.getKerberosRealm();
        }
        return this.kerberosRealm;
    }

    public String getFQServiceName() {
        return this.getServicePrincipalName() + "@" + this.getKerberosRealm();
    }

    public boolean isDefaultSPN() {
        return this.bDefaultSPN;
    }

    public void setCurrentDefaultSPN(KRBSPN currentDefaultSPN) {
        this.bDefaultSPN = true;
        this.currentDefaultSPN = currentDefaultSPN;
    }
}

