/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.websphere.token.KRBTicket;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;

public class KRB5TokenCacheUtil {
    private static final TraceComponent tc = Tr.register(KRB5TokenCacheUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLS_NAME = KRB5TokenCacheUtil.class.getName();
    private static final String comp = "security.wssecurity";
    private static CacheableTokenCache cacheObject = CacheableTokenCacheFactory.getInstance();
    private static long extraTime = CacheConfigFactory.getInstance().getCacheGraceTimeMilliseconds();
    private static long cushionTime = CacheConfigFactory.getInstance().getCacheCushionMilliseconds();
    private static long clockSkew = CacheConfigFactory.getInstance().getClockSkewToleranceMilliseconds();

    public static CacheableTokenCache getCache() {
        return cacheObject;
    }

    public static TicketActionState getTicketActionState(KerberosTicket ticket) {
        TicketActionState tState = TicketActionState.NONE;
        Date current = new Date();
        if (ticket.getEndTime().getTime() < current.getTime() - clockSkew) {
            tState = TicketActionState.REISSUE;
        } else if (ticket.getEndTime().getTime() < current.getTime() + cushionTime + clockSkew) {
            tState = ticket.isRenewable() && ticket.getRenewTill() != null && ticket.getRenewTill().getTime() > current.getTime() + cushionTime + clockSkew ? TicketActionState.REFRESH : TicketActionState.REISSUE;
        }
        return tState;
    }

    public static boolean isTicketValid(KerberosTicket ticket, boolean cushion) {
        boolean valid = false;
        Date current = new Date();
        if (cushion) {
            if (ticket.getEndTime().getTime() > current.getTime() + cushionTime) {
                valid = true;
            }
        } else if (ticket.getEndTime().after(current)) {
            valid = true;
        }
        return valid;
    }

    public static void setKRB5TokenToCache(CacheableToken token, String identifier, long cacheTimeout) {
        cacheObject.cacheToken(identifier, token, cacheTimeout + extraTime);
    }

    public static void setKRB5TokenToCache(CacheableToken token, String identifier, Date expirationDate) {
        cacheObject.cacheToken(identifier, token, KRB5TokenCacheUtil.getExpirationDuration(expirationDate));
    }

    public static void invalidatetKRB5TokenFromCache(MessageContext mCtx) {
        String key = KRB5TokenCacheUtil.getClientHashFromService(mCtx);
        if (key != null) {
            String toAddr = "";
            EndpointReference endPoint = mCtx.getTo();
            if (endPoint != null) {
                toAddr = endPoint.getAddress();
            }
            cacheObject.removeToken(key + toAddr);
        }
    }

    private static long getExpirationDuration(Date date) {
        long current = System.currentTimeMillis();
        long future = date.getTime();
        long duration = future - current;
        if (duration < 0L) {
            duration = 0L;
        }
        return duration += extraTime;
    }

    public static String getClientCacheKeyFromSubject(KerberosTicket ktkt, String spn) {
        String key = null;
        String clientName = ktkt.getClient().getName();
        String clientRealm = ktkt.getClient().getRealm();
        key = KRB5TokenCacheUtil.getClientIdentifierForServiceTicket(clientName, clientRealm, spn);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CacheKey=" + key);
        }
        return key;
    }

    public static String getSha1FromBytes(byte[] sourceByte) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSha1FromBytes()");
        }
        String sha1Value = null;
        byte[] sha1Result = null;
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            sha1.update(sourceByte);
            sha1Result = sha1.digest();
            sha1.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (sha1Result != null) {
            sha1Value = Base64.encode(sha1Result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSha1FromBytes() return " + sha1Value);
        }
        return sha1Value;
    }

    private static KRBAuthnToken getKRBAuthnTokenFromSubject(final Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKRBAuthnTokenFromSubject() entry... " + subject);
        }
        if (subject == null) {
            return null;
        }
        KRBAuthnToken authToken = null;
        try {
            authToken = (KRBAuthnToken)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Iterator<KRBAuthnToken> authIterator = subject.getPrivateCredentials(KRBAuthnToken.class).iterator();
                    if (authIterator.hasNext()) {
                        KRBAuthnToken authT = authIterator.next();
                        if (authT != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Processing AUTH token with name: " + authT.getTokenName());
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "NO KRBAuthnToken token is found to be processed...");
                        }
                        return authT;
                    }
                    return null;
                }
            });
            if (authToken == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find internally implemented AuthenticationToken.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found KRBAuthnToken from runAsSubject: " + authToken);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKRBAuthnTokenFromSubject() exits... ");
            }
            return authToken;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting AuthenticationToken from Subject.", new Object[]{e});
            }
            throw e;
        }
    }

    public static KerberosTicket getTgtTicketFromRunAsSubject(final Subject runAsSubject) {
        KerberosTicket ktkt;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTgtTicketFromRunAsSubject()...");
            }
            if (runAsSubject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTgtTicketFromRunAsSubject() return NULL");
                }
                return null;
            }
            ktkt = null;
            try {
                KRBAuthnToken krbAuthToken = KRB5TokenCacheUtil.getKRBAuthnTokenFromSubject(runAsSubject);
                if (krbAuthToken != null && krbAuthToken instanceof KRBTicket) {
                    ktkt = ((KRBTicket)((Object)krbAuthToken)).getKerberosTicket();
                }
                if (ktkt == null) {
                    ktkt = (KerberosTicket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Iterator<KerberosTicket> ticketIterator;
                            Set<KerberosTicket> kerberosTicketSet = runAsSubject.getPrivateCredentials(KerberosTicket.class);
                            if (kerberosTicketSet != null && kerberosTicketSet.size() > 0 && (ticketIterator = kerberosTicketSet.iterator()).hasNext()) {
                                return ticketIterator.next();
                            }
                            return null;
                        }
                    });
                    if (ktkt != null) {
                        boolean ticketForwardable;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found KerberosTicket from private creds: " + ktkt);
                        }
                        boolean bl = ticketForwardable = ktkt.isCurrent() && ktkt.isForwardable() && !ktkt.isDestroyed();
                        if (ticketForwardable && tc.isDebugEnabled()) {
                            String realm = null;
                            String clientName = null;
                            clientName = ktkt.getClient().getName();
                            realm = ktkt.getClient().getRealm();
                            Tr.debug(tc, "Use a found Kerberos ticket for " + clientName + " in realm: " + realm);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "KerberosTicket not found.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Kerberos ticket from KRBAuthnToken in RunAsSubject: " + ktkt);
                }
            }
            catch (Exception ex) {
                Tr.processException(ex, CLS_NAME + ".login", "%C");
                Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", ex);
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Unable to locate Kerberos ticket. Login to get Kerberos ticket.");
            }
        }
        if (ktkt != null && ktkt.getClient() != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "CacheKey=" + ktkt.getClient().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTgtTicketFromRunAsSubject()...");
        }
        return ktkt;
    }

    public static Subject getRunAsSubject(MessageContext messageContext) {
        Subject runAsSubject = null;
        WSSContext secContext = WSSContextFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found a WSSContext: " + secContext.toString());
        }
        if (secContext != null) {
            try {
                runAsSubject = secContext.getRunAsSubject(messageContext);
            }
            catch (Exception ex) {
                Tr.processException(ex, CLS_NAME + ".login", "%C");
                Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", ex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get RunAsSubject.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No WSSContext is found. Return.");
        }
        if (tc.isEntryEnabled()) {
            if (runAsSubject != null) {
                Tr.exit(tc, "RunAsSubject NOT null");
            } else {
                Tr.exit(tc, "Not RunAsSubject exists");
            }
        }
        return runAsSubject;
    }

    public static void addClientCacheIdToService(MessageContext mCtx, String s) {
        if (s != null && mCtx != null) {
            String toAddr = "";
            EndpointReference endPoint = mCtx.getTo();
            if (endPoint != null) {
                toAddr = endPoint.getAddress();
            }
            Parameter par = new Parameter(Constants.WSSECURITY_KERBEROS_TICKET_IDENTIFIER + toAddr, s);
            try {
                mCtx.setProperty(Constants.WSSECURITY_KERBEROS_TICKET_IDENTIFIER + toAddr, s);
                if (mCtx.getAxisService() != null) {
                    mCtx.getAxisService().addParameter(par);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cache the Kerberos ticket in AxisService with ID of " + s);
                }
            }
            catch (Exception e) {
                Tr.debug(tc, "Unable to add Kerberos ticket to AxisContext. ", e);
            }
        }
    }

    public static String getClientCacheKeyFromKRBAuthnToken(Subject runAsSubject, String spn) {
        String key;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClientCacheKeyFromKRBAuthnToken( KRBAuthnToken kToken, String spn ) ");
            }
            KRBAuthnToken kToken = null;
            key = null;
            try {
                kToken = KRB5TokenCacheUtil.getKRBAuthnTokenFromSubject(runAsSubject);
                if (kToken == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no KRBAuthnToken to create cache key");
                    }
                } else {
                    key = kToken.getTokenUniqueID();
                    if (spn != null) {
                        key = key + spn.hashCode();
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block8;
                Tr.debug(tc, "Fail to create cache key from rnAsSubject.", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Cache key =" + key);
        }
        return key;
    }

    public static String getClientIdentifierForServiceTicket(String clientName, String clientRealm, String spnName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientIdentifierForServiceTicket(HashMap initMap)");
        }
        StringBuffer sb = new StringBuffer();
        if (clientName != null) {
            sb.append(clientName);
            if (!clientName.endsWith(clientRealm) && clientRealm != null) {
                if (clientRealm != null) {
                    sb.append('@').append(clientRealm);
                }
            } else if (clientName.indexOf(64) > 0) {
                clientName = clientName.substring(0, clientName.indexOf(64));
            }
        }
        if (spnName != null) {
            sb.append(spnName);
        }
        String s = sb.toString();
        sb = new StringBuffer();
        int hash = s.hashCode();
        s = hash > 0 ? sb.append(clientName).append(hash).toString() : sb.append(clientName).append(hash *= -1).append('n').toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientIdentifierForServiceTicket:" + sb.toString() + ":" + s);
        }
        return s;
    }

    public static String getClientIdentifierForServiceTicketByCallback(HashMap initMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientIdentifierForServiceTicket(HashMap initMap)");
        }
        String clientName = (String)initMap.get("clientName");
        String clientRealm = (String)initMap.get("clientRealmName");
        String spn = (String)initMap.get("serviceName");
        String s = null;
        if (clientName != null && clientRealm != null && spn != null) {
            s = KRB5TokenCacheUtil.getClientIdentifierForServiceTicket(clientName, clientRealm, spn);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientIdentifierForServiceTicket:" + s);
        }
        return s;
    }

    public static String getClientHashFromService(MessageContext mCtx) {
        String key = null;
        if (mCtx != null) {
            Parameter par;
            String toAddr = "";
            EndpointReference endPoint = mCtx.getTo();
            if (endPoint != null) {
                toAddr = endPoint.getAddress();
            }
            if ((key = (String)mCtx.getProperty(Constants.WSSECURITY_KERBEROS_TICKET_IDENTIFIER + toAddr)) == null && mCtx.getAxisService() != null && (par = mCtx.getAxisService().getParameter(Constants.WSSECURITY_KERBEROS_TICKET_IDENTIFIER + toAddr)) != null) {
                key = (String)par.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cached cache key = " + key);
                }
            }
        }
        return key;
    }

    public static String getClientIdentifierForTGT(String clientName, String clientRealm, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientIdentifierForTGTString(String clientName,String clientRealm)");
        }
        StringBuffer sb = new StringBuffer();
        if (clientName != null) {
            sb.append(clientName);
            if (!clientName.endsWith(clientRealm) && clientRealm != null && clientRealm != null) {
                sb.append('@').append(clientRealm);
            }
        }
        if (password != null) {
            sb.append(password.hashCode());
        }
        String s = sb.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientIdentifierForTGTString:" + s);
        }
        return s;
    }

    public static String getClientIdentifierForTGTByCallback(HashMap initMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientIdentifierForTGTByCallback(HashMap initMap)");
        }
        String clientName = (String)initMap.get("clientName");
        String clientRealm = (String)initMap.get("clientRealmName");
        String password = (String)initMap.get("clientPassword");
        String s = null;
        if (clientName != null && clientRealm != null) {
            s = KRB5TokenCacheUtil.getClientIdentifierForTGT(clientName, clientRealm, password);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientIdentifierForTGTByCallback:" + s);
        }
        return s;
    }

    public static boolean isTicketValid(KerberosTicket ticket, Date date) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTicketValid()...");
        }
        boolean valid = false;
        Date current = new Date();
        long expirationTime = 0L;
        if (date != null) {
            expirationTime = date.getTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration time from service token: " + expirationTime);
            }
        } else if (ticket != null) {
            expirationTime = ticket.getEndTime().getTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration time from the ticket: " + expirationTime);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Current time past clock skew: " + (current.getTime() - clockSkew));
        }
        if (expirationTime > current.getTime() - clockSkew) {
            valid = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Validated ticket: " + ticket);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTicketValid()...");
        }
        return valid;
    }

    public static enum TicketActionState {
        NONE,
        REISSUE,
        REFRESH;

    }
}

