/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Request;
import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.time.TimestampRequest;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import com.ibm.wsspi.wssecurity.wssapi.WSSObjectStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;

public class IntegralDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(IntegralDialectElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final QName URI_Q = new QName("", "URI");
    public static final String EXIST_STRTRANSFORM = "security.wssecurity.integraldialectelementselector.existstrtransform";
    public static final int BODY = 0;
    public static final int TIMESTAMP = 1;
    public static final int SECURITYTOKEN = 2;
    public static final int DSIGKEY = 3;
    public static final int ENCKEY = 4;
    public static final int MESSAGEID = 5;
    public static final int TO = 6;
    public static final int ACTION = 7;
    public static final int RELATESTO = 8;
    public static final int WSCONTEXT = 9;
    public static final int WSA_FROM = 10;
    public static final int WSA_REPLYTO = 11;
    public static final int WSA_FAULTTO = 12;
    public static final int WSA_ALL = 13;
    public static final int SIGNATURECONFIRMATION = 14;
    public static final String[] WASDIALECTS = new String[]{"body".intern(), "timestamp".intern(), "securitytoken".intern(), "dsigkey".intern(), "enckey".intern(), "messageid".intern(), "to".intern(), "action".intern(), "relatesto".intern(), "wscontext".intern(), "wsafrom".intern(), "wsareplyto".intern(), "wsafaultto".intern(), "wsaall".intern(), "signatureconfirmation".intern()};
    private static final String[] WSAELEMENTS = new String[]{"MessageID".intern(), "To".intern(), "Action".intern(), "RelatesTo".intern(), "From".intern(), "ReplyTo".intern(), "FaultTo".intern()};

    @Override
    public void init(Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(node) + "], Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String dialect = (String)context.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + dialect + "]");
        }
        if (dialect == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_WAS.equals(dialect)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        String keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + keyword + "]");
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean signature = "signature_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + obj + "]");
        }
        String processType = (String)context.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + processType + "]");
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + elements + "]");
        }
        Collection configs = (Collection)context.get("com.ibm.ws.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token generator configs [" + configs + "]");
        }
        boolean existSTRTransform = ConfigUtil.isTrue((String)context.get(EXIST_STRTRANSFORM));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "STR-Transform exists [" + existSTRTransform + "]");
        }
        IDResolver idResolver = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ID resolver [" + idResolver + "]");
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        OMDocument doc = DOMUtil.getOwnerDocument(node);
        OMElement el = doc.getOMDocumentElement();
        ArrayList<Object> list = null;
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[0] + "]");
            }
            list = new ArrayList();
            OMElement body = null;
            try {
                body = DOMUtils.getOneChildElement(el, nsSoap, "Body");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from SOAPEnvelope.getBody()" + e);
                }
                Tr.processException((Throwable)e, this.getClass().getName() + ".getElements", "%C", this);
                throw new SoapSecurityException(e);
            }
            list.add(body);
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
            }
            list = signature ? IntegralDialectElementSelector.getTimestampForSignature(context) : IntegralDialectElementSelector.getTimestampForVerification(doc, nsWsu, context);
        } else if (WASDIALECTS[2].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[2] + "]");
            }
            list = null;
            SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            list = signature ? IntegralDialectElementSelector.getTokensForSignature(configs, securityTokenManager, context) : IntegralDialectElementSelector.getTokensForVerification(configs, securityTokenManager, context);
        } else if (WASDIALECTS[14].equals(keyword)) {
            OMElement security;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[14] + "]");
            }
            list = (security = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null ? DOMUtils.getChildElements(security, Constants.NS_WSSE11, "SignatureConfirmation") : new ArrayList();
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[3] + "]");
            }
            list = IntegralDialectElementSelector.getDsigKeyObjects(doc, context, existSTRTransform, idResolver, nsWsse);
        } else if (WASDIALECTS[4].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[4] + "]");
            }
            list = IntegralDialectElementSelector.getEncKeyObjects(doc, context, existSTRTransform, idResolver, nsWsse);
        } else if (WASDIALECTS[5].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[5] + "]");
            }
            list = this.getWSAElement(context, doc, "MessageID");
        } else if (WASDIALECTS[6].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[6] + "]");
            }
            list = this.getWSAElement(context, doc, "To");
        } else if (WASDIALECTS[7].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[7] + "]");
            }
            list = this.getWSAElement(context, doc, "Action");
        } else if (WASDIALECTS[8].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[8] + "]");
            }
            list = this.getWSAElement(context, doc, "RelatesTo");
        } else if (WASDIALECTS[9].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[9] + "]");
            }
            list = IntegralDialectElementSelector.getWSContextHeaderElement(doc);
        } else if (WASDIALECTS[10].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[10] + "]");
            }
            list = this.getWSAElement(context, doc, "From");
        } else if (WASDIALECTS[11].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[11] + "]");
            }
            list = this.getWSAElement(context, doc, "ReplyTo");
        } else if (WASDIALECTS[12].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[12] + "]");
            }
            list = this.getWSAElement(context, doc, "FaultTo");
        } else if (WASDIALECTS[13].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[13] + "]");
            }
            list = this.getWSAAllElements(context, doc);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", keyword);
        }
        if (processType != null && signature) {
            list = IntegralDialectElementSelector.postprocess(doc, processType, list, elements, nsWsse, nsWsu, nonceManager, signature, false, dialect, keyword);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map)");
        }
        return list;
    }

    public static ArrayList<OMNode> postprocess(OMDocument doc, String type, ArrayList<OMNode> list, Object[] elements, String nsWsse, String nsWsu, NonceManager nmanager, boolean signature, boolean encryption, String dialect, String keyword) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postprocess(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String type[" + type + "]," + "ArrayList list," + "Object[] elements," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "NoceManager nmanager," + "boolean signature[" + signature + "]," + "boolean encryption[" + encryption + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "])");
        }
        PartList rlist = new ArrayList();
        String extType = encryption ? "weenc" : "wedsig";
        for (int i = 0; i < list.size(); ++i) {
            OMElement el1 = null;
            OMElement el2 = (OMElement)list.get(i);
            if ("timestamp".equals(type)) {
                el1 = NonceUtil.getTimestamp(el2, nsWsu);
                if (el1 == null) {
                    OMFactory factory = doc.getOMDocumentElement().getOMFactory();
                    el1 = NonceUtil.createTimestamp(factory, el2, nsWsu, extType);
                    el2.addChild(el1);
                    NonceUtil.addCreated(factory, el1, nsWsu);
                }
            } else if ("nonce".equals(type) && (el1 = NonceUtil.getNonce(el2, nsWsse)) == null) {
                el1 = NonceUtil.addNonce(doc.getOMDocumentElement().getOMFactory(), el2, nsWsse, nmanager, extType);
            }
            if (elements == null) continue;
            boolean found = false;
            for (int j = 0; j < elements.length; ++j) {
                if (!DOMUtils.equals((OMNode)elements[j], el2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the element [" + DOMUtils.getDisplayName(el2) + "]");
            }
            ((ArrayList)rlist).add(el2);
        }
        if (encryption) {
            rlist = new PartList("http://www.w3.org/2001/04/xmlenc#Element", rlist);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postprocess(OMDocument, String, ArrayList, Object[],Duration, String, String, NoceManager,boolean, boolean, String, String) returns NodeList[" + rlist + "]");
        }
        return rlist;
    }

    private static ArrayList<OMNode> getTimestampForSignature(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestmapForSignature(Map context)");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        Request[] requests = RequestPool.get(context, TimestampRequest.class);
        if (requests != null && requests.length > 0) {
            for (int i = 0; i < requests.length; ++i) {
                RequestMessagePool.EncryptedObject eobj;
                TimestampRequest trequest = (TimestampRequest)requests[i];
                if (!trequest.isSigned()) continue;
                OMElement el = trequest.getElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the element [" + DOMUtils.getDisplayName(el) + "].");
                }
                if ((eobj = RequestMessagePool.convertElement(context, el, -1)) == null) {
                    list.add(el);
                    continue;
                }
                if (eobj.getEncryptedData() != null) {
                    list.add(eobj.getEncryptedData());
                }
                if (eobj.getHeaderInfo() == null) continue;
                list.add(eobj.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestmapForSignature(Map)");
        }
        return list;
    }

    private static ArrayList<XMLElement> getXMLElementTimestampForSignature(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLElementTimestmapForSignature(Map context)");
        }
        ArrayList<XMLElement> list = new ArrayList<XMLElement>();
        Request[] requests = RequestPool.get(context, TimestampRequest.class);
        if (requests != null && requests.length > 0) {
            for (int i = 0; i < requests.length; ++i) {
                TimestampRequest trequest = (TimestampRequest)requests[i];
                if (!trequest.isSigned()) continue;
                WSSObjectElement el = trequest.getWSSObject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the element [" + el.getQName() + "].");
                }
                list.add(new XMLElement(el));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLElementTimestmapForSignature(Map)");
        }
        return list;
    }

    private static ArrayList<OMNode> getTimestampForVerification(OMDocument doc, String nsWsu, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestampForVerification(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)");
        }
        ArrayList<OMNode> rlist = new ArrayList<OMNode>();
        ArrayList list = null;
        OMElement header = IntegralDialectElementSelector.getSecurityHeader(context, doc);
        if (header != null) {
            list = DOMUtils.getElementsByTagNameNS(header, nsWsu, "Timestamp");
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                OMElement el = (OMElement)list.get(i);
                String avalue = el.getAttributeValue(Constants.WAS_EXTENTION_Q);
                if (avalue != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the timestamp element without WAS extention [" + el + "]");
                }
                rlist.add(el);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestampForVerification(OMDocument, String nsWsu, Map) returns ArrayList[" + rlist + "]");
        }
        return rlist;
    }

    private static ArrayList<OMNode> getTokensForSignature(Collection<TokenGeneratorConfig> configs, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokensForSignature(Set configs,SecurityTokenManagerImpl securityTokenManager,Map context)");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        Collection<SecurityTokenWrapper> tokenWrappers = securityTokenManager.getTokenWrappers();
        for (TokenGeneratorConfig config2 : configs) {
            if (!config2.isStandAlone()) continue;
            for (SecurityTokenWrapper tokenWrapper : tokenWrappers) {
                if (config2.hashCode() != tokenWrapper.getUsedTokenGeneratorHash() || tokenWrapper.isReferenced()) continue;
                OMStructure om = (OMStructure)tokenWrapper.getXML();
                OMElement telem = null;
                if (om != null) {
                    telem = om.getNode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the token element [" + DOMUtils.getDisplayName(telem) + "]");
                }
                if (telem == null) continue;
                RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, telem, -1);
                if (eobj == null) {
                    list.add(telem);
                    continue;
                }
                if (eobj.getEncryptedData() != null) {
                    list.add(eobj.getEncryptedData());
                }
                if (eobj.getHeaderInfo() == null) continue;
                list.add(eobj.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokensForSignature(Set, SecurityTokenManagerImpl, Map) returns ArrayList[" + list + "]");
        }
        return list;
    }

    private static ArrayList<XMLElement> getXMLElementTokensForSignature(Collection<TokenGeneratorConfig> configs, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLElementTokensForSignature(Set configs,SecurityTokenManagerImpl securityTokenManager,Map context)");
        }
        ArrayList<XMLElement> list = new ArrayList<XMLElement>();
        Collection<SecurityTokenWrapper> tokenWrappers = securityTokenManager.getTokenWrappers();
        for (TokenGeneratorConfig config2 : configs) {
            if (!config2.isStandAlone()) continue;
            for (SecurityTokenWrapper tokenWrapper : tokenWrappers) {
                if (config2.hashCode() != tokenWrapper.getUsedTokenGeneratorHash() || tokenWrapper.isReferenced()) continue;
                XMLStructure obj = tokenWrapper.getXML();
                XMLElement xelem = null;
                if (obj != null) {
                    if (obj instanceof WSSObjectStructure) {
                        WSSObjectStructure wssos = (WSSObjectStructure)obj;
                        xelem = new XMLElement((WSSObjectElement)wssos.getObject());
                    } else if (obj instanceof OMStructure) {
                        OMStructure om = (OMStructure)obj;
                        xelem = new XMLElement(om.getNode());
                    }
                }
                if (tc.isDebugEnabled()) {
                    String elemName = null;
                    if (xelem.getType() == 1) {
                        elemName = DOMUtils.getDisplayName(xelem.getOMNode());
                    } else if (xelem.getType() == 2) {
                        elemName = xelem.getWSSObject().getQName().toString();
                    }
                    Tr.debug(tc, "Added the token element [" + elemName + "]");
                }
                if (xelem == null) continue;
                list.add(xelem);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLElementTokensForSignature(Set, SecurityTokenManagerImpl, Map) returns ArrayList[" + list + "]");
        }
        return list;
    }

    private static ArrayList<OMNode> getTokensForVerification(Collection<TokenGeneratorConfig> configs, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokensForVerification(Set configs,SecurityTokenManagerImpl securityTokenManager,Map context)");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        if (configs != null) {
            Collection<SecurityTokenWrapper> tokenWrappers = securityTokenManager.getTokenWrappers();
            for (TokenConsumerConfig tokenConsumerConfig : configs) {
                if (tokenConsumerConfig.isUsedForVerification() || tokenConsumerConfig.isUsedForDecryption()) continue;
                for (SecurityTokenWrapper tokenWrapper : tokenWrappers) {
                    if (tokenConsumerConfig.hashCode() != tokenWrapper.getUsedTokenConsumerHash() || tokenWrapper.isReferenced()) continue;
                    OMStructure om = (OMStructure)tokenWrapper.getXML();
                    OMElement telem = null;
                    if (om != null) {
                        telem = om.getNode();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added the token element [" + DOMUtils.getDisplayName(telem) + "]");
                    }
                    if (telem == null) continue;
                    list.add(telem);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokensForVerification(Set, SecurityTokenManagerImpl, Map) returns ArrayList[" + list + "]");
        }
        return list;
    }

    public static ArrayList<OMNode> getHeaderElement(OMDocument doc, String ns, String ln) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeaderElement(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String ns[" + ns + "]," + "String ln[" + ln + "])");
        }
        ArrayList list = null;
        OMElement header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            list = DOMUtils.getElementsByTagNameNS(header, ns, ln);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeaderElement(OMDocument, String, String) returns NodeList[" + list + "]");
        }
        return list;
    }

    private static ArrayList<OMNode> getDsigKeyObjects(OMDocument doc, Map<Object, Object> context, boolean existSTRTransform, IDResolver idResolver, String nsWsse) throws SoapSecurityException {
        ArrayList<OMNode> nl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDsigKeyObjects(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Map context," + "boolean existSTRTransform[" + existSTRTransform + "]," + "IDResolver idResolver," + "String nsWsse[" + nsWsse + "])");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        OMElement security = IntegralDialectElementSelector.getSecurityHeader(context, doc);
        if (security != null && (nl = DOMUtils.getChildElements(security, Constants.NS_DSIG, "Signature")) != null && nl.size() > 0) {
            for (int i = 0; i < nl.size(); ++i) {
                ArrayList<OMNode> nl2 = IntegralDialectElementSelector.getKeyObjects(doc, (OMElement)nl.get(i), existSTRTransform, idResolver, nsWsse);
                if (nl2.size() <= 0) continue;
                for (int j = 0; j < nl2.size(); ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added the key objects in the Signature element [" + DOMUtils.getDisplayName(nl2.get(j)) + "]");
                    }
                    list.add((OMElement)nl2.get(j));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDsigKeyObjects(OMDocument, Map, boolean, IDResolver, String) returns ArrayList[" + list + "]");
        }
        return list;
    }

    private static ArrayList<OMNode> getEncKeyObjects(OMDocument doc, Map<Object, Object> context, boolean existSTRTransform, IDResolver idResolver, String nsWsse) throws SoapSecurityException {
        int j;
        ArrayList<OMNode> nl2;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncKeyObjects(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Map context," + "boolean existSTRTransform[" + existSTRTransform + "]," + "IDResolver idResolver," + "String nsWsse[" + nsWsse + "])");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        OMElement security = IntegralDialectElementSelector.getSecurityHeader(context, doc);
        ArrayList nl = null;
        if (security != null && (nl = DOMUtils.getChildElements(security, Constants.NS_ENC, "EncryptedKey")) != null && nl.size() > 0) {
            for (i = 0; i < nl.size(); ++i) {
                nl2 = IntegralDialectElementSelector.getKeyObjects(doc, (OMElement)nl.get(i), existSTRTransform, idResolver, nsWsse);
                if (nl2.size() <= 0) continue;
                for (j = 0; j < nl2.size(); ++j) {
                    list.add((OMElement)nl2.get(j));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the key objects in the EncryptedKey element [" + DOMUtils.getDisplayName(nl2.get(j)) + "]");
                }
            }
        }
        if ((nl = DOMUtils.getElementsByTagNameNS(doc.getOMDocumentElement(), Constants.NS_ENC, "EncryptedData")) != null && nl.size() > 0) {
            for (i = 0; i < nl.size(); ++i) {
                nl2 = IntegralDialectElementSelector.getKeyObjects(doc, (OMElement)nl.get(i), existSTRTransform, idResolver, nsWsse);
                if (nl2.size() <= 0) continue;
                for (j = 0; j < nl2.size(); ++j) {
                    list.add((OMElement)nl2.get(j));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the key objects in the EncryptedData element [" + DOMUtils.getDisplayName(nl2.get(j)) + "]");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncKeyObjects(OMDocument, Map, boolean, IDResolver, String) returns ArrayList[" + list + "]");
        }
        return list;
    }

    private static ArrayList<OMNode> getKeyObjects(OMDocument doc, OMElement parent, boolean existSTRTransform, IDResolver idResolver, String nsWsse) throws SoapSecurityException {
        String uri;
        OMElement el;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyObjects(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "boolean existSTRTransform[" + existSTRTransform + "]," + "IDResolver idResolver," + "String nsWsse[" + nsWsse + "])");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        OMElement keyinfo = DOMUtils.getZeroOrOneElement(parent, Constants.NS_DSIG, "KeyInfo");
        if (keyinfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added the element in the KeyInfo element [" + DOMUtils.getDisplayName(keyinfo) + "]");
            }
            list.add(keyinfo);
        }
        if (!existSTRTransform && (el = DOMUtils.getFirstElement(keyinfo, nsWsse, "SecurityTokenReference")) != null && (el = DOMUtils.getFirstElement(el, nsWsse, "Reference")) != null && (uri = el.getAttributeValue(URI_Q)) != null) {
            if (uri.length() < 2 || uri.charAt(0) != '#') {
                throw new RuntimeException("Unsupported type of URI: " + uri);
            }
            el = idResolver.resolveID(doc, uri.substring(1));
            if (el != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added the referenced element [" + DOMUtils.getDisplayName(el) + "]");
                }
                list.add(el);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyObjects(OMDocument, OMElement, boolean, IDResolver, String) returns ArrayList[" + list + "]");
        }
        return list;
    }

    static ArrayList<OMNode> getWSContextHeaderElement(OMDocument doc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSContextHeaderElement(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "])");
        }
        ArrayList<OMNode> list = null;
        OMElement header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            list = DOMUtils.getChildElements(header, Constants.NS_WSCTX_V1, "Context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSContextHeaderElement(OMDocument) returns NodeList[" + list + "]");
        }
        return list;
    }

    private final ArrayList<OMNode> getWSAElement(Map<Object, Object> context, OMDocument doc, String elementName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSAElement(Map context, OMDocument doc[" + DOMUtils.getDisplayName(doc) + "], String [" + elementName + "])");
        }
        ArrayList<OMNode> list = null;
        boolean bGenerator = IntegralDialectElementSelector.isGenerator(context);
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        OMElement header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            if (bGenerator) {
                String ns;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting the element for [" + elementName + "] for generator");
                }
                if ((ns = (String)messageContext.getProperty("WSAddressingVersion")) == null || ns.length() == 0) {
                    ns = Constants.NS_WSADDRS[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No outbound namespace defined for WS-Address, default [" + ns + "] is used.");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Namespace for WS-Addressing outbound request [" + ns + "].");
                }
                list = DOMUtils.getChildElements(header, ns, elementName);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting the element for [" + elementName + "] for consumer");
                }
                boolean found = false;
                String tmp = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    list = DOMUtils.getChildElements(header, Constants.NS_WSADDRS[i], elementName);
                    if (list == null || list.size() == 0) continue;
                    tmp = Constants.NS_WSADDRS[i];
                    found = true;
                    break;
                }
                if (found) {
                    String ns = (String)messageContext.getProperty("WSAddressingVersion");
                    if (ns == null || ns.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No inbound WS-Addressing namespace is set, setting it to [" + tmp + "].");
                        }
                        messageContext.setProperty("WSAddressingVersion", tmp);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Inbound WS-Addressing namespace was set to [" + ns + "] and namespace found [" + tmp + "].");
                        }
                        if (!ns.equals(tmp)) {
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSAElement(Map, OMDocument, String) returns " + this.toString(list));
        }
        return list;
    }

    private final ArrayList<OMNode> getWSAAllElements(Map<Object, Object> context, OMDocument doc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSAAllElements(Map context, OMDocument doc[" + DOMUtils.getDisplayName(doc) + "])");
        }
        boolean bGenerator = IntegralDialectElementSelector.isGenerator(context);
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        OMElement header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            if (bGenerator) {
                String ns;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting all WSA elements for generator");
                }
                if ((ns = (String)messageContext.getProperty("WSAddressingVersion")) == null || ns.length() == 0) {
                    ns = Constants.NS_WSADDRS[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No outbound namespace defined for WS-Address, default [" + ns + "] is used.");
                    }
                }
                list = this.getWSAAllElements(header, ns, WSAELEMENTS);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting all WSA elements for consumer");
                }
                boolean found = false;
                String tmp = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    list = this.getWSAAllElements(header, Constants.NS_WSADDRS[i], WSAELEMENTS);
                    if (list == null || list.size() == 0) continue;
                    tmp = Constants.NS_WSADDRS[i];
                    found = true;
                    break;
                }
                if (found) {
                    String ns = (String)messageContext.getProperty("WSAddressingVersion");
                    if (ns == null || ns.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No inbound WS-Addressing namespace is set, setting it to [" + tmp + "].");
                        }
                        messageContext.setProperty("WSAddressingVersion", tmp);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Inbound WS-Addressing namespace was set to [" + ns + "] and namespace found [" + tmp + "].");
                        }
                        if (!ns.equals(tmp)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getWSAElement(Map context, Document doc, String elementName)");
                            }
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSAAllElements(Map, OMDocument) returns " + this.toString(list));
        }
        return list;
    }

    private final ArrayList<OMNode> getWSAAllElements(OMContainer parent, String ns, String[] elements) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getWSAAllElements(OMContainer parent, String [" + ns + "], String[] [" + this.toString(elements) + "])");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        for (OMNode node = parent.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            for (int i = 0; i < elements.length; ++i) {
                if (node.getType() != 1 || !DOMUtils.equals(node, ns, elements[i])) continue;
                list.add((OMElement)node);
            }
        }
        return list;
    }

    protected static final OMElement getSecurityHeader(Map<Object, Object> context, OMDocument doc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityHeader(Map context, OMDocument doc[" + DOMUtils.getDisplayName(doc) + "])");
        }
        boolean bGenerator = IntegralDialectElementSelector.isGenerator(context);
        String actor = null;
        if (bGenerator) {
            WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (gconfig != null) {
                actor = gconfig.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got generator actor " + actor);
            }
        } else {
            WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (cconfig != null) {
                actor = cconfig.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got consumer actor " + actor);
            }
        }
        Object obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        OMElement header = WSSGenerator.getHeader(doc, false);
        OMElement security = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader(Map, OMDocument) returns " + security);
        }
        return security;
    }

    private final String toString(Object[] array) {
        if (array == null || array.length == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]).append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private static final boolean isGenerator(Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenerator(Map context)");
        }
        boolean bGenerator = false;
        boolean bConsumer = false;
        Object obj = context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (obj != null) {
            bGenerator = true;
        }
        if ((obj = context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) != null) {
            bConsumer = true;
        }
        if (bGenerator && bConsumer || !bGenerator && !bConsumer) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine generator or consumer");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC6734E");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenerator(Map) returns " + bGenerator);
        }
        return bGenerator;
    }

    private final String toString(ArrayList list) {
        if (list == null || list.size() == 0) {
            return "<empty>";
        }
        StringBuffer buf = new StringBuffer("[ ");
        for (int i = 0; i < list.size(); ++i) {
            buf.append(DOMUtils.toString((OMNode)list.get(i))).append(", ");
        }
        buf.append(" ]");
        return buf.toString();
    }

    @Override
    public ArrayList<XMLElement> getXMLElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<XMLElement> list;
        block10: {
            block8: {
                String keyword;
                block11: {
                    Security security;
                    block9: {
                        boolean targetInSecurityHeader;
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "getXMLElements(OMNode node[" + DOMUtils.getDisplayName(node) + "], Map context)");
                        }
                        list = null;
                        security = WSSObjectUtils.getWSSObjectSecurityHeader(context);
                        String dialect = (String)context.get("com.ibm.ws.wssecurity.util.selector.dialect");
                        keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
                        String mode = (String)context.get("com.ibm.ws.wssecurity.util.selector.operation");
                        boolean signature = "signature_mode".equals(mode);
                        boolean bl = targetInSecurityHeader = Constants.DIALECT_WAS.equals(dialect) && (WASDIALECTS[1].equals(keyword) || WASDIALECTS[2].equals(keyword) || WASDIALECTS[14].equals(keyword));
                        if (!signature || !targetInSecurityHeader || security == null) break block8;
                        if (!WASDIALECTS[1].equals(keyword)) break block9;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
                        }
                        list = IntegralDialectElementSelector.getXMLElementTimestampForSignature(context);
                        break block10;
                    }
                    if (!WASDIALECTS[14].equals(keyword)) break block11;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[14] + "]");
                    }
                    list = WSSObjectUtils.getChildXMLElements(security, Utf8ByteConstantsQNames.WSSE11.QN_SIGNATURE_CONFIRMATION);
                    break block10;
                }
                if (!WASDIALECTS[2].equals(keyword)) break block10;
                Collection configs = (Collection)context.get("com.ibm.ws.wssecurity.util.selector.config");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token generator configs [" + configs + "]");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[2] + "]");
                }
                SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
                list = IntegralDialectElementSelector.getXMLElementTokensForSignature(configs, securityTokenManager, context);
                break block10;
            }
            ArrayList<OMNode> orig_list = this.getElements(node, context);
            list = new ArrayList<XMLElement>();
            if (orig_list != null && orig_list.size() > 0) {
                for (int i = 0; i < orig_list.size(); ++i) {
                    OMNode obj = orig_list.get(i);
                    XMLElement el = new XMLElement(obj);
                    list.add(el);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLElements(OMNode, Map)");
        }
        return list;
    }
}

