/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class IdUtil
implements IDResolver {
    private static final TraceComponent tc = Tr.register(IdUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IdUtil.class.getName();
    private static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    private static final String[][] KNOWN_IDATTRS = new String[][]{{Constants0.NS_WSSE, "*", "Id"}, {Constants0.NS_WSSE200207, "*", "Id"}, {Constants0.NS_WSSE200204, "*", "Id"}, {Constants0.NS_DSIG, "*", "Id"}, {Constants0.NS_ENC, "*", "Id"}, {"http://www.w3.org/1999/xhtml", "*", "id"}};
    private static final String[][] KNOWN_GLOBAL_IDATTRS = new String[][]{{Constants0.NS_WSU, "Id"}, {Constants0.NS_WSU200207, "Id"}};
    private static IdUtil instance = new IdUtil();
    protected String[][] known_idattrs = KNOWN_IDATTRS;
    protected String[][] known_global_idattrs = KNOWN_GLOBAL_IDATTRS;
    protected QName[] known_global_idattrs_qname = new QName[KNOWN_GLOBAL_IDATTRS.length];
    protected HashMap<String, QName> known_idattrs_map;
    private static volatile int id = 0;
    public static final String ID_COUNTER_KEY = "com.ibm.ws.wssecurity.util.id.counter";
    private static final String idPrefix = "w_";
    private static int STARTING_INDEX = 20;
    public static final String[] ID_ARRAY = new String[]{"w_0", "w_1", "w_2", "w_3", "w_4", "w_5", "w_6", "w_7", "w_8", "w_9", "w_10", "w_11", "w_12", "w_13", "w_14", "w_15", "w_16", "w_17", "w_18", "w_19", "w_20", "w_21", "w_22", "w_23", "w_24", "w_25", "w_26", "w_27", "w_28", "w_29", "w_30", "w_31", "w_32", "w_33", "w_34", "w_35", "w_36", "w_37", "w_38", "w_39", "w_40", "w_41", "w_42", "w_43", "w_44", "w_45", "w_46", "w_47", "w_48", "w_49", "w_50", "w_51", "w_52", "w_53", "w_54", "w_55", "w_56", "w_57", "w_58", "w_59", "w_60", "w_61", "w_62", "w_63", "w_64", "w_65", "w_66", "w_67", "w_68", "w_69", "w_70", "w_71", "w_72", "w_73", "w_74", "w_75", "w_76", "w_77", "w_78", "w_79", "w_80", "w_81", "w_82", "w_83", "w_84", "w_85", "w_86", "w_87", "w_88", "w_89", "w_90", "w_91", "w_92", "w_93", "w_94", "w_95", "w_96", "w_97", "w_98", "w_99"};
    private static final IdAttributeValue[] idAttrValueArray = new IdAttributeValue[ID_ARRAY.length];
    private static Map<String, VariablePartAttributeValue> id2VariablePartMap = new HashMap<String, VariablePartAttributeValue>();
    private static Map<String, IdAttributeValue> id2AttributeValueMap = new HashMap<String, IdAttributeValue>();

    protected IdUtil() {
        int i;
        for (i = 0; i < KNOWN_GLOBAL_IDATTRS.length; ++i) {
            this.known_global_idattrs_qname[i] = new QName(KNOWN_GLOBAL_IDATTRS[i][0], KNOWN_GLOBAL_IDATTRS[i][1]);
        }
        this.known_idattrs_map = new HashMap(KNOWN_IDATTRS.length + 4);
        for (i = 0; i < KNOWN_IDATTRS.length; ++i) {
            this.known_idattrs_map.put(this.known_idattrs[i][0], new QName("", this.known_idattrs[i][2]));
        }
    }

    public static IdUtil getInstance() {
        return instance;
    }

    public QName getIdAttributeName(OMElement element) {
        String ns;
        QName tmpQ;
        QName ret = null;
        for (int i = 0; i < this.known_global_idattrs.length; ++i) {
            QName tmp = this.known_global_idattrs_qname[i];
            OMAttribute a = element.getAttribute(tmp);
            if (a == null) continue;
            ret = a.getQName();
        }
        if (ret == null && (tmpQ = this.known_idattrs_map.get(ns = element.getNamespace() == null ? null : element.getNamespace().getName())) != null) {
            if (element.getAttributeValue(tmpQ) != null) {
                ret = tmpQ;
            } else {
                tmpQ = null;
            }
        }
        return ret;
    }

    private boolean matchId(OMElement element, String id, boolean onlyWsu) {
        QName idattr;
        boolean ret = false;
        ret = onlyWsu ? id.equals(NamespaceUtil.getWsuAttribute(element, "Id")) : (idattr = this.getIdAttributeName(element)) != null && id.equals(element.getAttributeValue(idattr));
        return ret;
    }

    public String makeUniqueId(String base) {
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "makeUniqueId(String base[" + base + "])");
        }
        String ret = base + id++;
        if (entryEnabled) {
            Tr.exit(tc, "makeUniqueId(String base) returns String[" + ret + "]");
        }
        return ret;
    }

    public String makeUniqueId(Map context, String base) {
        IntegerCounter counter;
        Object oc = context.get(ID_COUNTER_KEY);
        if (oc == null) {
            counter = new IntegerCounter(STARTING_INDEX);
            context.put(ID_COUNTER_KEY, counter);
        } else {
            counter = (IntegerCounter)oc;
        }
        int val = counter.getNextValue();
        String ret = null;
        ret = val >= 0 && val < ID_ARRAY.length && base.equals(idPrefix) ? ID_ARRAY[val] : base + val;
        return ret;
    }

    public IdAttributeValue makeUniqueId(Map context) {
        IntegerCounter counter;
        Object oc = context.get(ID_COUNTER_KEY);
        if (oc == null) {
            counter = new IntegerCounter(STARTING_INDEX);
            context.put(ID_COUNTER_KEY, counter);
        } else {
            counter = (IntegerCounter)oc;
        }
        int val = counter.getNextValue();
        IdAttributeValue ret = null;
        ret = val >= 0 && val < idAttrValueArray.length ? idAttrValueArray[val] : new IdAttributeValue(val, idPrefix);
        return ret;
    }

    public VariablePartAttributeValue getVariablePart(String idname) {
        VariablePartAttributeValue vPart = null;
        if (idname != null && idname.length() > 0) {
            vPart = id2VariablePartMap.get(idname);
            if (vPart == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getVariablePart(): VariablePart for id \"" + idname + "\" not found in map; creating.");
                }
                vPart = VariablePartFactory.getInstance().createAttrValueWithString(idname);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getVariablePart(): VariablePart for id \"" + idname + "\" found in map; returning.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVariablePart(): id passed in was null or empty; returning null.");
        }
        return vPart;
    }

    public IdAttributeValue getIdAttributeValue(String idname) {
        IdAttributeValue val = null;
        if (idname != null && idname.length() > 0) {
            val = id2AttributeValueMap.get(idname);
            if (val == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getIdAttributeValue(): IdAttributeValue for id \"" + idname + "\" not found in map; creating.");
                }
                val = new IdAttributeValue(idname);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getIdAttributeValue(): IdAttributeValue for id \"" + idname + "\" found in map; returning.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdAttributeValue(): id passed in was null or empty; returning null.");
        }
        return val;
    }

    public void checkIdUniqueness(OMDocument doc) throws SoapSecurityException {
        OMElement e;
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "checkIdUniqueness(Document doc[" + DOMUtil.getDisplayName(doc) + "])");
        }
        if (doc != null && (e = doc.getOMDocumentElement()) != null) {
            HashSet ids = new HashSet();
            IdUtil.checkIdUniqueness(e, ids);
        }
        if (entryEnabled) {
            Tr.exit(tc, "checkIdUniqueness(Document doc)");
        }
    }

    private static void checkIdUniqueness(OMNode node, Set ids) throws SoapSecurityException {
        if (node.getType() == 1) {
            OMElement e = (OMElement)node;
            QName s = IdUtil.getInstance().getIdAttributeName(e);
            if (s != null) {
                String id = e.getAttributeValue(s);
                if (ids.contains(id)) {
                    throw SoapSecurityException.format("security.wssecurity.IdUtil.s01", id);
                }
                ids.add(id);
            }
            for (OMNode n = e.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                if (n.getType() != 1 && n.getType() != 9) continue;
                IdUtil.checkIdUniqueness(n, ids);
            }
        }
    }

    @Override
    public OMElement resolveID(OMDocument doc, String id) {
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "resolveID(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String id[" + id + "])");
        }
        OMElement ret = this.resolveId0(doc, id, false);
        if (entryEnabled) {
            Tr.exit(tc, "resolveID(Document doc,String id) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public boolean findId(OMDocument doc, String id) {
        boolean ret;
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "findId(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String id[" + id + "])");
        }
        boolean bl = ret = this.resolveId0(doc, id, false) != null;
        if (entryEnabled) {
            Tr.exit(tc, "findId(Document doc,String id) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public boolean findWsuId(OMDocument doc, String id) {
        boolean ret;
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "findWsuId(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String id[" + id + "])");
        }
        boolean bl = ret = this.resolveId0(doc, id, true) != null;
        if (entryEnabled) {
            Tr.exit(tc, "findWsuId(Document doc,String id) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private OMElement resolveId0(OMDocument doc, String id, boolean onlyWsu) {
        if (doc == null) {
            return null;
        }
        return this.resolve(doc.getOMDocumentElement(), id, onlyWsu);
    }

    protected OMElement resolveId(OMNode node, String id) {
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "resolveId(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String id[" + id + "])");
        }
        OMElement ret = null;
        if (node != null) {
            ret = this.resolve(node, id, false);
        }
        if (entryEnabled) {
            Tr.exit(tc, "resolveId(Node node,String id) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    private OMElement resolve(OMNode node, String id, boolean onlyWsu) {
        if (node.getType() == 1 && this.matchId((OMElement)node, id, onlyWsu)) {
            return (OMElement)node;
        }
        if (node.getType() == 1) {
            for (OMNode child = ((OMElement)node).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                OMElement element;
                if (child.getType() != 1 && child.getType() != 9 || (element = this.resolve(child, id, onlyWsu)) == null) continue;
                return element;
            }
        }
        return null;
    }

    public String getId(OMElement element) {
        boolean entryEnabled = tc.isEntryEnabled();
        if (entryEnabled) {
            Tr.entry(tc, "getId(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        String value = null;
        QName name = this.getIdAttributeName(element);
        if (name != null) {
            value = element.getAttributeValue(name);
        }
        if (entryEnabled) {
            Tr.exit(tc, "getId(Element element) returns String[" + value + "]");
        }
        return value;
    }

    static {
        for (int i = 0; i < idAttrValueArray.length; ++i) {
            IdUtil.idAttrValueArray[i] = new IdAttributeValue(ID_ARRAY[i], Utf8ByteConstantsVariableParts.VPA_ID[i], Utf8ByteConstantsVariableParts.VPA_ID_REF[i]);
            id2VariablePartMap.put(idAttrValueArray[i].getStringValue(), idAttrValueArray[i].getVariablePartValue());
            id2VariablePartMap.put(idAttrValueArray[i].getStringRefValue(), idAttrValueArray[i].getVariablePartRefValue());
            id2AttributeValueMap.put(idAttrValueArray[i].getStringValue(), idAttrValueArray[i]);
        }
    }

    class IntegerCounter {
        private int _value;

        public IntegerCounter(int value) {
            this._value = value;
        }

        public int getNextValue() {
            int ret = this._value++;
            return ret;
        }
    }
}

