/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class IDResolverImpl
implements IDResolver {
    private static final TraceComponent tc = Tr.register(IDResolverImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private Map<String, OMElement> _idMap = null;
    private OMElement _soapHeader = null;
    private boolean _duplicatesFound = false;
    private Set<String> _duplicateIDs = null;

    public IDResolverImpl(OMElement header) {
        this._soapHeader = header;
    }

    public void clear() {
        this._soapHeader = null;
        if (this._idMap != null) {
            this._idMap.clear();
            this._idMap = null;
        }
        this._duplicatesFound = false;
        if (this._duplicateIDs != null) {
            this._duplicateIDs.clear();
            this._duplicateIDs = null;
        }
    }

    @Override
    public OMElement resolveID(OMDocument doc, String id) {
        if (this._idMap == null) {
            this._idMap = new HashMap<String, OMElement>();
            if (this._soapHeader != null) {
                this.populateIdMap(this._soapHeader);
            }
        }
        if (this._duplicatesFound && this._duplicateIDs != null && this._duplicateIDs.contains(id)) {
            throw new RuntimeException("More than one element with id \"" + id + "\" found in SOAP message.");
        }
        OMElement e = this._idMap.get(id);
        if (e == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resolveID: could not find id \"" + id + "\" in idMap");
            }
            if ((e = IdUtils.getInstance().resolveID(doc, id)) != null) {
                OMElement obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resolveID: adding id \"" + id + "\" to idMap");
                }
                if ((obj = this._idMap.put(id, e)) != null) {
                    this.foundDuplicateId(id);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resolveID: found id \"" + id + "\" in idMap");
        }
        return e;
    }

    public void addIdToMap(String id, OMElement node) {
        OMElement obj = this._idMap.put(id, node);
        if (obj != null) {
            this.foundDuplicateId(id);
        }
    }

    private void populateIdMap(OMElement node) {
        if (node != null) {
            this.internalPopulateIdMap(node, this._idMap);
            OMNode child = node.getNextOMSibling();
            if (child != null) {
                this.getElementId(child);
                if (child.getType() == 1) {
                    OMElement e = (OMElement)child;
                    child = e.getFirstOMChild();
                    this.getElementId(child);
                }
            }
        }
    }

    private void getElementId(OMNode node) {
        if (node != null && node.getType() == 1) {
            OMElement e = (OMElement)node;
            String id = IdUtils.getInstance().getId(e);
            if (id != null) {
                OMElement obj;
                if (id.charAt(0) == '#') {
                    id = id.substring(1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getElementId: adding id \"" + id + "\" to idMap for body or child of body");
                }
                if ((obj = this._idMap.put(id, e)) != null) {
                    this.foundDuplicateId(id);
                }
            }
        }
    }

    private void internalPopulateIdMap(OMElement node, Map<String, OMElement> idMap) {
        for (OMNode child = node.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 1) continue;
            OMElement e = (OMElement)child;
            String id = IdUtils.getInstance().getId(e);
            if (id != null) {
                OMElement obj;
                if (id.charAt(0) == '#') {
                    id = id.substring(1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "internalPopulateIdMap: adding id \"" + id + "\" to idMap");
                }
                if ((obj = idMap.put(id, e)) != null) {
                    this.foundDuplicateId(id);
                }
            }
            this.internalPopulateIdMap(e, idMap);
        }
    }

    private void foundDuplicateId(String id) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IDResolverImpl: Warning: Found duplicate id \"" + id + "\".");
        }
        this._duplicatesFound = true;
        if (this._duplicateIDs == null) {
            this._duplicateIDs = new HashSet<String>();
        }
        this._duplicateIDs.add(id);
    }
}

