/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.DigestUtil;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.axiom.om.OMElement;

public class DigestUtilImpl
implements DigestUtil {
    private static final String _algorithmC14n = "http://www.w3.org/2001/10/xml-c14n#";
    private static final String _digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";

    @Override
    public byte[] getDigest(OMElement document) throws SoapSecurityException {
        byte[] result = null;
        result = this.getDigest(document, _algorithmC14n, _digestAlgorithm);
        return result;
    }

    @Override
    public byte[] getDigest(OMElement document, String algorithmC14n, String digestAlgorithm) throws SoapSecurityException {
        byte[] calcDigest = null;
        ByteArrayHolder aHolder = null;
        try {
            aHolder = this.getDocumentOctets(document, algorithmC14n);
        }
        catch (NoSuchAlgorithmException e) {
            throw SoapSecurityException.format("Caught NoSuchAlgorithmException getting octets. Exception e=", e);
        }
        catch (IOException e) {
            throw SoapSecurityException.format("Caught IOException getting octets. Exception e=", e);
        }
        try {
            calcDigest = this.calculateDigestValue(aHolder, digestAlgorithm);
        }
        catch (SignatureStructureException e) {
            throw SoapSecurityException.format("Caught SignatureStructureException calculating Digest. Exception e=", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw SoapSecurityException.format("Caught NoSuchAlgorithmException calculating Digest. Exception e=", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw SoapSecurityException.format("Caught InvalidAlgorithmParameterException calculating Digest. Exception e=", e);
        }
        return calcDigest;
    }

    private ByteArrayHolder getDocumentOctets(OMElement document, String c14nAlgorithm) throws NoSuchAlgorithmException, IOException {
        ByteArrayHolder result = null;
        AlgorithmFactory aFactory = AlgorithmFactory.getInstance();
        Canonicalizer c11r = aFactory.getCanonicalizer(c14nAlgorithm);
        if (c11r == null) {
            throw new NoSuchAlgorithmException("No canonicalization algorithm: " + c14nAlgorithm);
        }
        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream(0);
        c11r.canonicalize(document, baos);
        baos.close();
        result = baos.getByteArrayHolder();
        return result;
    }

    private byte[] calculateDigestValue(ByteArrayHolder octets, String digestAlgorithm) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        byte[] result = null;
        AlgorithmParameterSpec spec = null;
        AlgorithmFactory aFactory = AlgorithmFactory.getInstance();
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        MessageDigest digester = aFactory.getMessageDigest(digestAlgorithm, spec);
        digester.reset();
        digester.update(octets.getValue(), octets.getOffset(), octets.getLength());
        result = digester.digest();
        aFactory.releaseMessageDigest(digestAlgorithm, digester);
        return result;
    }
}

