/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.ObjectPool;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DerivedKeyUtil {
    private static final String defaultHashAlgorithm = "HmacSHA1";
    private static ObjectPool<Mac> MAC_POOL = new ObjectPool(20);
    private static final String defaultClientLabel = "WS-SecureConversation";
    private static final String defaultServerLabel = "WS-SecureConversation";
    private static final String defaultLabel = "WS-SecureConversationWS-SecureConversation";
    private static byte[] DEFAULT_LABEL_BYTES = null;

    public static SecretKey createDerivedKey(byte[] theSecret, String label, byte[] nonce, int keyLength, int offset, int generation, String hashAlgorithm, String keyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] keyByte = DerivedKeyUtil.createDerivedKeyByte(theSecret, label, nonce, keyLength, offset, generation, hashAlgorithm);
        SecretKeySpec key = new SecretKeySpec(keyByte, keyAlgorithm);
        return key;
    }

    public static byte[] createDerivedKeyByte(byte[] theSecret, String label, byte[] nonce, int keyLength, int offset, int generation, String hashAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = MAC_POOL.get();
        if (mac == null) {
            if (hashAlgorithm == null) {
                hashAlgorithm = defaultHashAlgorithm;
            }
            mac = Mac.getInstance(hashAlgorithm);
        }
        mac = DerivedKeyUtil.initMac(theSecret, hashAlgorithm, mac);
        byte[] keyByte = DerivedKeyUtil.createDerivedKeyByte(mac, label, nonce, keyLength, offset, generation);
        MAC_POOL.put(mac);
        return keyByte;
    }

    public static SecretKey createDerivedKey(byte[] clientSecret, byte[] serverSecret, String clientLabel, String serverLabel, byte[] nonce, int keyLength, int offset, int generation, String hashAlgorithm, String keyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] keyByte = DerivedKeyUtil.createDerivedKeyByte(clientSecret, serverSecret, clientLabel, serverLabel, nonce, keyLength, offset, generation, hashAlgorithm);
        SecretKeySpec key = new SecretKeySpec(keyByte, keyAlgorithm);
        return key;
    }

    public static byte[] createDerivedKeyByte(byte[] clientSecret, byte[] serverSecret, String clientLabel, String serverLabel, byte[] nonce, int keyLength, int offset, int generation, String hashAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] theSecret = DerivedKeyUtil.createDerivedKeyByte(clientSecret, "", serverSecret, clientSecret.length, 0, 0, "HmacSha1");
        if (clientLabel == null) {
            clientLabel = "WS-SecureConversation";
        }
        if (serverLabel == null) {
            serverLabel = "WS-SecureConversation";
        }
        String label = clientLabel + serverLabel;
        byte[] derivedKeyByte = DerivedKeyUtil.createDerivedKeyByte(theSecret, label, nonce, keyLength, 0, 0, "HmacSha1");
        return derivedKeyByte;
    }

    private static byte[] createDerivedKeyByte(Mac mac, String label, byte[] nonce, int keyLength, int offset, int generation) throws InvalidKeyException, NoSuchAlgorithmException {
        if (mac == null) {
            throw new NoSuchAlgorithmException("This is not a Mac intance.");
        }
        if (label == null) {
            label = defaultLabel;
        }
        byte[] labelByte = null;
        if (defaultLabel.equals(label)) {
            labelByte = DEFAULT_LABEL_BYTES;
        } else {
            try {
                labelByte = label.getBytes("UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid Label." + e.getMessage());
            }
        }
        byte[] seed = DerivedKeyUtil.Concatenation(labelByte, nonce);
        byte[] keyByte = DerivedKeyUtil.P_SHA1(mac, seed, keyLength);
        return keyByte;
    }

    private static byte[] P_SHA1(Mac mac, byte[] seed, int length) {
        int macLength = mac.getMacLength();
        byte[] A = new byte[seed.length];
        byte[] B = null;
        System.arraycopy(seed, 0, A, 0, seed.length);
        int iterations = (length + macLength - 1) / macLength;
        byte[] Holder2 = new byte[iterations * macLength];
        for (int i = 0; i < iterations; ++i) {
            A = mac.doFinal(A);
            B = mac.doFinal(DerivedKeyUtil.Concatenation(A, seed));
            System.arraycopy(B, 0, Holder2, i * macLength, macLength);
        }
        byte[] C = new byte[length];
        System.arraycopy(Holder2, 0, C, 0, length);
        return C;
    }

    private static Mac initMac(byte[] theSecret, String hashAlgorithm, Mac mac) throws InvalidKeyException, NoSuchAlgorithmException {
        if (hashAlgorithm == null) {
            hashAlgorithm = defaultHashAlgorithm;
        }
        SecretKeySpec secretKey = new SecretKeySpec(theSecret, hashAlgorithm);
        mac.init(secretKey);
        return mac;
    }

    private static byte[] Concatenation(byte[] b1, byte[] b2) {
        byte[] b = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    static {
        try {
            DEFAULT_LABEL_BYTES = defaultLabel.getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

