/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AlgorithmParameters;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public final class ConfigValidation {
    private static String isFipsEnabled = null;
    private static boolean rsaoaepInitialized = false;
    private static boolean rsaoaepSupported = false;
    private static byte[] lock = new byte[0];
    protected final Set allowedEncAlgos = new HashSet();
    protected final Set allowedKeyEncAlgos = new HashSet();
    protected final Set allowedC14nAlgos = new HashSet();
    protected final Set allowedSignAlgos = new HashSet();
    protected final Set allowedDigestAlgos = new HashSet();
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfigValidation.class.getName();
    private static final TraceComponent tc = Tr.register(ConfigValidation.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation()");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        this.processAllowedAlgorithms(DOMUtil.getConfigValidation());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    private void addToSet(OMDocument algoDoc, String algo, Set set) {
        ArrayList list;
        int length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSet(" + algoDoc + ", " + algo + ", " + set + ")");
        }
        if ((length = (list = DOMUtil.getElementsByTagNameNS(algoDoc.getOMDocumentElement(), "http://www.ibm.com/xml/soapsec/config", algo)).size()) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No allowed " + algo + " elements found.");
            }
        } else {
            for (int i = 0; i < length; ++i) {
                OMElement elem = (OMElement)list.get(i);
                try {
                    set.add(DOMUtil.getAttribute(elem, "algorithm"));
                    continue;
                }
                catch (SoapSecurityException sse) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "\"algorithm\" attribute not found in \"" + algo + "\" element.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed " + algo + " set: ", new Object[]{set});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSet()");
        }
    }

    protected void processAllowedAlgorithms(OMDocument algoDoc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAllowedAlgorithms(" + algoDoc + ")");
        }
        if (algoDoc == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed Algorithms Document is null, exiting.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processAllowedAlgorithms()");
            }
            return;
        }
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            this.addToSet(algoDoc, "fipsEncryptionMethod", this.allowedEncAlgos);
            this.addToSet(algoDoc, "fipsKeyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(algoDoc, "fipsSignatureMethod", this.allowedSignAlgos);
            this.addToSet(algoDoc, "fipsDigestMethod", this.allowedDigestAlgos);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            this.addToSet(algoDoc, "encryptionMethod", this.allowedEncAlgos);
            this.addToSet(algoDoc, "keyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(algoDoc, "signatureMethod", this.allowedSignAlgos);
            this.addToSet(algoDoc, "digestMethod", this.allowedDigestAlgos);
        }
        this.addToSet(algoDoc, "canonicalizationMethod", this.allowedC14nAlgos);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAllowedAlgorithms()");
        }
    }

    protected boolean encryptionMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedEncAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean keyEncryptionMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyEncryptionMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedKeyEncAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyEncryptionMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean canonicalizationMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalizationMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedC14nAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalizationMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean signatureMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signatureMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedSignAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signatureMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean digestMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "digestMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedDigestAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "digestMethodValid() returns " + valid);
        }
        return valid;
    }

    public static boolean isFipsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFipsEnabled");
        }
        if (isFipsEnabled == null) {
            isFipsEnabled = Security.getProperty("com.ibm.websphere.security.fips.enabled");
            if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read java.security.Security property; FIPS mode is enabled");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read java.security.Security property; FIPS mode is not enabled");
            }
        }
        if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFipsEnabled -> true");
            }
            return true;
        }
        isFipsEnabled = "false";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFipsEnabled -> false");
        }
        return false;
    }

    public static boolean isAlgoSupportedByRuntime(String algo) {
        boolean supported = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlgoSupportedByRuntime(String algo[" + algo + "])");
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(algo)) {
            supported = ConfigValidation.isRsaoaepSupported(algo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlgoSupportedByRuntime returns " + supported);
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRsaoaepSupported(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRsaoaepSupported");
        }
        if (rsaoaepInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
        byte[] byArray = lock;
        synchronized (lock) {
            block16: {
                String algo = "OAEP";
                StringTokenizer tokenizer = null;
                if ("true".equalsIgnoreCase(Security.getProperty("com.ibm.websphere.security.fips.enabled"))) {
                    tokenizer = new StringTokenizer(Security.getProperty("com.ibm.websphere.security.fips.jceProviders"), "|");
                }
                if (tokenizer == null || !tokenizer.hasMoreTokens()) {
                    try {
                        AlgorithmParameters param = AlgorithmParameters.getInstance(algo);
                        AlgorithmParameterSpec spec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                        rsaoaepSupported = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully got instance of " + algo + " cipher algorithm with default provider");
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Received exception " + e.getMessage() + " while getting instance of " + algo + " cipher algorithm with default provider");
                    }
                } else {
                    while (tokenizer.hasMoreTokens()) {
                        String provider = tokenizer.nextToken();
                        try {
                            AlgorithmParameters param = AlgorithmParameters.getInstance(algo, provider);
                            AlgorithmParameterSpec spec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                            rsaoaepSupported = true;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Successfully got instance of " + algo + " cipher algorithm with provider " + provider);
                            break;
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Received exception " + e.getMessage() + " while getting instance of " + algo + " cipher algorithm with provider " + provider);
                        }
                    }
                }
            }
            if (!rsaoaepSupported) {
                Tr.warning(tc, "security.wssecurity.WSEC0157W", uri);
            }
            rsaoaepInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
    }
}

