/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.core.Initializable;
import com.ibm.ws.wssecurity.platform.util.KeyStoreUtilFactory;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class ConfigUtil {
    private static final TraceComponent tc = Tr.register(ConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfigUtil.class.getName();
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};
    private static final String[] FALSE_VALUES = new String[]{"no", "off", "false", "0"};
    private static final PrivilegedAction<Object> thisClassLoaderGetter = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return this.getClass().getClassLoader();
        }
    };
    private static final String[] USAGE_VALUES = new String[]{"required", "optional", "rejected", "observed", "ignored"};
    private static final String[] KEYINFO_TYPES = new String[]{"STRREF", "EMB", "KEYID", "KEYNAME", "X509ISSUER", "THUMBPRINT"};
    private static final Set<String> C14N_TRANSFORMS = new HashSet<String>();
    private static final Set<String> DOMREQUIRED_TRANSFORMS;
    private static final Set<String> SECRETKEY_ALGORITHMS;

    public static boolean isTrue(String flag) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrue(String flag[" + flag + "])");
        }
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(flag)) continue;
                ret = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrue(String) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isFalse(String flag) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFalse(String flag[" + flag + "])");
        }
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < FALSE_VALUES.length; ++i) {
                if (!FALSE_VALUES[i].equalsIgnoreCase(flag)) continue;
                ret = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFalse returns [" + ret + "]");
        }
        return ret;
    }

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static String getNonBlankString(String str) {
        String retVal = null;
        if (str != null) {
            retVal = str.trim();
            if (str.length() == 0) {
                retVal = null;
            }
        }
        return retVal;
    }

    public static boolean getIsTrueProperty(Map _map, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty(_map, " + propName + ")");
        }
        String propValue = (String)_map.get(propName);
        boolean retVal = false;
        if (ConfigUtil.hasValue(propValue) && ConfigUtil.isTrue(propValue)) {
            retVal = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty returns [" + retVal + "]");
        }
        return retVal;
    }

    public static boolean getIsFalseProperty(Map _map, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsFalseProperty(_map, " + propName + ")");
        }
        String propValue = (String)_map.get(propName);
        boolean retVal = true;
        if (ConfigUtil.hasValue(propValue) && ConfigUtil.isFalse(propValue)) {
            retVal = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsFalseProperty returns [" + retVal + "]");
        }
        return retVal;
    }

    public static boolean isValidWSKeyStore(String keyStoreName) {
        return KeyStoreUtilFactory.getInstance().isValidWSKeyStore(keyStoreName);
    }

    public static boolean isHWKeyStore(String keyStoreName) {
        return KeyStoreUtilFactory.getInstance().isHWKeyStore(keyStoreName);
    }

    public static Provider getHWCryptoProviderInstance(String keyStoreName) {
        return KeyStoreUtilFactory.getInstance().getHWCryptoProviderInstance(keyStoreName);
    }

    public static void returnHWCryptoProviderInstance(String keyStoreName, Provider hwProviderInstance) {
        KeyStoreUtilFactory.getInstance().returnHWCryptoProviderInstance(keyStoreName, hwProviderInstance);
    }

    public static File fixPath(String path, String base) {
        File file;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("fixPath(");
            buf.append("String path[").append(path).append("], ");
            buf.append("String base[").append(base).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (!(file = new File(path)).isAbsolute()) {
            file = base != null ? new File(base, path) : new File(file.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("fixPath(String, String)");
            buf.append(" returns File[").append(file).append("]");
            Tr.exit(tc, buf.toString());
        }
        return file;
    }

    public static KeyStore getKeyStore(String keyStoreRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore(String keyStoreRef[" + keyStoreRef + "])");
        }
        if (keyStoreRef == null || keyStoreRef.length() == 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s08");
        }
        KeyStore keystore = ConfigUtil.createKeyStore(null, null, null, keyStoreRef);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyStore(String)");
            buf.append(" returns KeyStore[");
            buf.append(keystore == null ? "null" : "not null");
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return keystore;
    }

    public static KeyStore getKeyStore(String type, String path, char[] storepass) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyStore(");
            buf.append("String type[").append(type).append("], ");
            buf.append("String path[").append(path).append("], ");
            buf.append("char[] storepass[");
            buf.append(storepass == null ? "null" : "not null");
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        if (storepass == null || storepass.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s03", path);
        }
        KeyStore keystore = ConfigUtil.createKeyStore(type, path, storepass, null);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyStore(String, String, char[])");
            buf.append(" returns KeyStore[");
            buf.append(keystore == null ? "null" : "not null");
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return keystore;
    }

    private static KeyStore createKeyStore(final String type, final String path, final char[] storepass, String keyStoreRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createKeyStore(");
            buf.append("String type[").append(type).append("], ");
            buf.append("String Path[").append(path).append("], ");
            buf.append("char[] storepass[");
            buf.append(storepass == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyStoreRef[").append(keyStoreRef).append("])");
            Tr.entry(tc, buf.toString());
        }
        KeyStore keystore = null;
        if (keyStoreRef != null && keyStoreRef.length() != 0) {
            keystore = KeyStoreUtilFactory.getInstance().getKeyStore(keyStoreRef);
            if (keystore == null) {
                Tr.error(tc, "security.wssecurity.ConfigUtil.s29", new Object[]{keyStoreRef});
                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s29", keyStoreRef);
            }
        } else {
            try {
                keystore = (KeyStore)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        KeyStore kstore = null;
                        InputStream in = null;
                        try {
                            kstore = KeyStore.getInstance(type);
                            URL urlFile = null;
                            File kfile = new File(path);
                            if (kfile.exists() && kfile.length() == 0L) {
                                throw new IOException("Keystore file exists, but is empty: " + path);
                            }
                            urlFile = !kfile.exists() ? new URL(path) : new URL("file:" + kfile.getCanonicalPath());
                            in = urlFile.openStream();
                            kstore.load(in, storepass);
                        }
                        catch (FileNotFoundException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "277");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s04", new Object[]{path});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s04", path);
                        }
                        catch (IOException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "286");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s05", new Object[]{path, e});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s05", path, (Throwable)e);
                        }
                        catch (CertificateException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "295");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage(), e});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", path, e.getClass().getName(), e.getMessage(), e);
                        }
                        catch (NoSuchAlgorithmException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "309");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage(), e});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", path, e.getClass().getName(), e.getMessage(), e);
                        }
                        catch (KeyStoreException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "323");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage(), e});
                            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s06", path, e.getClass().getName(), e.getMessage(), e);
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                        return kstore;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e.getCause();
                Tr.processException(th, clsName + ".createKeyStore", "487");
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw new SoapSecurityException(th);
            }
            catch (Exception e) {
                Tr.processException(e, clsName + ".createKeyStore", "494");
                if (e instanceof SoapSecurityException) {
                    throw (SoapSecurityException)e;
                }
                throw new SoapSecurityException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createKeyStore(");
            buf.append("String, String, char[], String)");
            buf.append(" returns KeyStore[");
            buf.append(keystore == null ? "null" : "not null");
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return keystore;
    }

    public static X509Certificate getX509Certificate(File path, CertificateFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getX509Certificate(");
            buf.append("File path[").append(path).append("], ");
            buf.append("CertificateFactory certificateFactory[").append(factory).append("])");
            Tr.entry(tc, buf.toString());
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)factory.generateCertificate(new FileInputStream(path));
        }
        catch (IOException e) {
            Tr.processException(e, clsName + ".getX509Certificate", "528");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s23", new String[]{path.getAbsolutePath(), e.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s23", new String[]{path.getAbsolutePath(), e.getMessage()}, (Throwable)e);
        }
        catch (CertificateException e) {
            Tr.processException(e, clsName + ".getX509Certificate", "537");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s24", new String[]{path.getAbsolutePath(), e.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s24", new String[]{path.getAbsolutePath(), e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getCertificate(");
            buf.append("File, CertificateFactory)");
            buf.append(" returns X509Certificate[");
            buf.append(cert == null ? "null" : cert.getSubjectX500Principal().getName());
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return cert;
    }

    public static X509CRL getX509CRL(File path, CertificateFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getX509CRL(");
            buf.append("File path[").append(path).append("], ");
            buf.append("CertificateFactory certificateFactory[").append(factory).append("])");
            Tr.entry(tc, buf.toString());
        }
        X509CRL crl = null;
        try {
            crl = (X509CRL)factory.generateCRL(new FileInputStream(path));
        }
        catch (IOException e) {
            Tr.processException(e, clsName + ".getX509CRL", "572");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s25", new Object[]{path.getAbsolutePath(), e});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s25", path.getAbsolutePath(), (Throwable)e);
        }
        catch (CRLException e) {
            Tr.processException(e, clsName + ".getX509CRL", "581");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s26", new Object[]{path.getAbsolutePath(), e});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s26", path.getAbsolutePath(), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getX509CRL(");
            buf.append("File, CertificateFactory)");
            buf.append(" returns X509CRL[");
            buf.append(crl == null ? "null" : crl.getIssuerX500Principal().getName());
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return crl;
    }

    public static CertificateFactory createCertificateFactory(String provider) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createCertificateFactory(");
            buf.append("String provider[").append(provider).append("])");
            Tr.entry(tc, buf.toString());
        }
        CertificateFactory factory = null;
        try {
            factory = provider == null || "".equals(provider) ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
        }
        catch (CertificateException e) {
            Tr.processException(e, clsName + ".createCertificateFactory", "619");
            Tr.error(tc, "security.wssecurity.CertificateFactory.getInstance", new String[]{"X.509", e.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.CertificateFactory.getInstance", new String[]{"X.509", e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            Tr.processException(e, clsName + ".createCertificateFactory", "623");
            Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s22", new Object[]{provider, e.getMessage()});
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s22", new String[]{provider, e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createCertificateFactory(");
            buf.append("String)");
            buf.append(" returns CertificateFactory[").append(factory).append("]");
            Tr.exit(tc, buf.toString());
        }
        return factory;
    }

    public static OMDocument mergeDocuments(OMDocument[] docs) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("mergeDocuments(");
            buf.append("OMDocument[] docs { ");
            if (docs == null) {
                buf.append("null ");
            } else {
                int il = docs.length;
                for (int i = 0; i < il; ++i) {
                    buf.append(DOMUtils.getDisplayName(docs[i])).append(", ");
                }
            }
            buf.append("}");
            Tr.entry(tc, buf.toString());
        }
        OMDocument doc = DOMUtil.createDocument();
        OMElement root = doc.getOMFactory().createOMElement("root", "", "");
        doc.addChild(root);
        if (docs != null) {
            for (int i = 0; i < docs.length; ++i) {
                OMElement elem;
                if (docs[i] == null || (elem = docs[i].getOMDocumentElement()) == null) continue;
                root.addChild(elem);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("mergeDocuments(Document[])");
            buf.append(" returns Document[").append(DOMUtils.getDisplayName(doc)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return doc;
    }

    public static Object instantiate(String cls, Class type, ClassLoader acl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("instantiate(");
            buf.append("String cls[").append(cls).append("], ");
            buf.append("Class type[").append(type).append("], ");
            buf.append("ClassLoader acl[");
            buf.append(acl == null ? "null" : "not null");
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        Object obj = null;
        ClassLoader loader = acl;
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(thisClassLoaderGetter);
        }
        if (tc.isDebugEnabled()) {
            if (loader != null) {
                Tr.debug(tc, "Classloader: " + loader.getClass().getName());
                Tr.debug(tc, "Classloader dump: " + loader.toString());
            } else {
                Tr.debug(tc, "Classloader: <null>");
            }
        }
        try {
            Class<?> c;
            if (loader != null) {
                try {
                    c = loader.loadClass(cls);
                }
                catch (ClassNotFoundException e) {
                    c = Class.forName(cls);
                }
            } else {
                c = Class.forName(cls);
            }
            if (type != null && !type.isAssignableFrom(c)) {
                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cls, type.getName());
            }
            obj = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            Tr.processException(e, clsName + ".instantiate", "738");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s09", new Object[]{cls});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s09", cls);
        }
        catch (InstantiationException e) {
            Tr.processException(e, clsName + ".instantiate", "742");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{cls});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s10", cls);
        }
        catch (IllegalAccessException e) {
            Tr.processException(e, clsName + ".instantiate", "746");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s11", new Object[]{cls});
            throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s11", cls);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("instantiate(");
            buf.append("String, Class, ClassLoader)");
            buf.append(" returns Object[").append((Object)obj).append("]");
            Tr.exit(tc, buf.toString());
        }
        return obj;
    }

    public static Initializable instantiate(String cls, Class type, Map<Object, Object> map, ClassLoader acl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("instantiate(");
            buf.append("String cls[").append(cls).append("], ");
            buf.append("Class type[").append(type).append("], ");
            buf.append("Map map, ");
            buf.append("ClassLoader acl[");
            buf.append(acl == null ? "null" : "not null");
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        Initializable instance = (Initializable)ConfigUtil.instantiate(cls, type, acl);
        instance.init(map);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("instantiate(");
            buf.append("String, Class, Map, ClassLoader)");
            buf.append(" returns Initializable[").append(instance).append("]");
            Tr.exit(tc, buf.toString());
        }
        return instance;
    }

    public static void getProperties(Map<Object, Object> properties, OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getProperties(");
            buf.append("Map properties, ");
            buf.append("OMElement parent[");
            buf.append(DOMUtils.getDisplayName(parent));
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        ArrayList<OMNode> list = DOMUtil.getChildElements(parent, Constants0.NS_CONFIG, "Property");
        OMElement property = null;
        for (int i = 0; i < list.size(); ++i) {
            property = (OMElement)list.get(i);
            String name = DOMUtil.getAttribute(property, "name");
            String value = DOMUtil.getAttribute(property, "value");
            properties.put(name, value);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + name + "], Value [" + value + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties(Map, Element)");
        }
    }

    public static Map<Object, Object> getProperties(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getProperties(");
            buf.append("OMElement parent[");
            buf.append(DOMUtils.getDisplayName(parent));
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        ArrayList<OMNode> properties = DOMUtil.getChildElements(parent, Constants0.NS_CONFIG, "Property");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        OMElement property = null;
        for (int i = 0; i < properties.size(); ++i) {
            property = (OMElement)properties.get(i);
            String name = DOMUtil.getAttribute(property, "name");
            String value = DOMUtil.getAttribute(property, "value");
            map.put(name, value);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + name + "], Value [" + value + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Element) returns Map[not null]");
        }
        return map;
    }

    public static String getMessage(String key) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMessage(");
            buf.append("String key[").append(key).append("])");
            Tr.entry(tc, buf.toString());
        }
        String ret = key;
        if (_MessageCatalog.instance != null) {
            try {
                ret = _MessageCatalog.instance.getString(key);
            }
            catch (MissingResourceException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception", new Object[]{e});
                }
                Tr.processException(e, ConfigUtil.class.getName() + ".getMessage", "868");
                ret = key;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMessage(String)");
            buf.append("returns String [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static String getMessage(String key, String[] args) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMessage(");
            buf.append("String key[").append(key).append("], ");
            buf.append("String[] args { ");
            if (args == null) {
                buf.append("null ");
            } else {
                int il = args.length;
                for (int i = 0; i < il; ++i) {
                    buf.append(args[i]).append(", ");
                }
            }
            buf.append(" })");
            Tr.entry(tc, buf.toString());
        }
        String ret = ConfigUtil.getMessage(key);
        if (args != null && args.length > 0) {
            ret = MessageFormat.format(ret, args);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMessage(String, String[])");
            buf.append("returns String [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static int isIntegralWASDialect(String keyword) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isIntegralWASDialect(");
            buf.append("String keyword[").append(keyword).append("])");
            Tr.entry(tc, buf.toString());
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < IntegralDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!keyword.equals(IntegralDialectElementSelector.WASDIALECTS[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isIntegralWASDialect(String)");
            buf.append("returns int [").append(index).append("]");
            Tr.exit(tc, buf.toString());
        }
        return index;
    }

    public static int isConfidentialWASDialect(String keyword) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isConfidentialWASDialect(");
            buf.append("String keyword[").append(keyword).append("])");
            Tr.entry(tc, buf.toString());
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < ConfidentialDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!keyword.equals(ConfidentialDialectElementSelector.WASDIALECTS[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isConfidentialWASDialect(String)");
            buf.append("returns int [").append(index).append("]");
            Tr.exit(tc, buf.toString());
        }
        return index;
    }

    public static int isTimestampWASDialect(String keyword) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isTimestampWASDialect(");
            buf.append("String keyword[").append(keyword).append("])");
            Tr.entry(tc, buf.toString());
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < TimestampDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!keyword.equals(TimestampDialectElementSelector.WASDIALECTS[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isTimestampWASDialect(String)");
            buf.append("returns int [").append(index).append("]");
            Tr.exit(tc, buf.toString());
        }
        return index;
    }

    public static int isUsage(String usage) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsage(");
            buf.append("String usage[").append(usage).append("])");
            Tr.entry(tc, buf.toString());
        }
        int index = -1;
        if (usage != null) {
            usage = usage.trim();
            for (int i = 0; i < USAGE_VALUES.length; ++i) {
                if (!USAGE_VALUES[i].equalsIgnoreCase(usage)) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsage(String)");
            buf.append("returns int [").append(index).append("]");
            Tr.exit(tc, buf.toString());
        }
        return index;
    }

    public static boolean isUsageRequired(String usage) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageRequired(");
            buf.append("String usage[").append(usage).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[0].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageRequired(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isUsageOptional(String usage) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageOptional(");
            buf.append("String usage[").append(usage).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[1].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageOptional(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isUsageRejected(String usage) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageRejected(");
            buf.append("String usage[").append(usage).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[2].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageRejected(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isUsageObserved(String usage) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageObserved(");
            buf.append("String usage[").append(usage).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[3].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageObserved(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isUsageIgnored(String usage) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageIgnored(");
            buf.append("String usage[").append(usage).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[4].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isUsageIgonored(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static int isKeyInfoType(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoType(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        int index = -1;
        if (type != null) {
            type = type.trim();
            for (int i = 0; i < KEYINFO_TYPES.length; ++i) {
                if (!KEYINFO_TYPES[i].equalsIgnoreCase(type)) continue;
                index = i;
                break;
            }
            if (index == 3) {
                index = -1;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoType(String)");
            buf.append("returns int [").append(index).append("]");
            Tr.exit(tc, buf.toString());
        }
        return index;
    }

    public static boolean isKeyInfoStrref(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoStrref(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[0].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoStrref(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isKeyInfoEmb(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoEmb(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[1].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoEmb(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isKeyInfoKeyid(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoKeyid(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[2].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoKeyid(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isKeyInfoKeyname(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoKeyname(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[3].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoKeyname(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isKeyInfoX509issuer(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoX509issuer(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[4].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoX509issuer(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isKeyInfoThumbprint(String type) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoThumbprint(");
            buf.append("String type[").append(type).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[5].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isKeyInfoThumbprint(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isC14nTransform(String algorithm) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isC14nTransform(");
            buf.append("String algorithm[").append(algorithm).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = C14N_TRANSFORMS.contains(algorithm);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isC14nTransform(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isDOMRequiredTransform(String algorithm) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isDOMRequiredTransform(");
            buf.append("String algorithm[").append(algorithm).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = DOMREQUIRED_TRANSFORMS.contains(algorithm);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isDOMRequiredTransform(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static boolean isSecretKeyAlgorithm(String algorithm) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isSecretKeyAlgorithm(");
            buf.append("String algorithm[").append(algorithm).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        if (algorithm != null) {
            ret = SECRETKEY_ALGORITHMS.contains(algorithm);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("isSecretKeyAlgorithm(String)");
            buf.append("returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public static int getMinimumPosition(List<ReferencePartConfig> order, List<SigningReferenceConfig> references) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMinimumPosition(");
            buf.append("List order[").append(order).append("], ");
            buf.append("List references[").append(references).append("])");
            Tr.entry(tc, buf.toString());
        }
        int pos = 10000;
        for (SigningReferenceConfig srconfig : references) {
            int j = ConfigUtil.getPosition(order, srconfig.getReference());
            if (j >= pos) continue;
            pos = j;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMinimumPosition(List, List)");
            buf.append("returns int [").append(pos).append("]");
            Tr.exit(tc, buf.toString());
        }
        return pos;
    }

    public static int getPosition(List<ReferencePartConfig> order, ReferencePartConfig reference) {
        ReferencePartConfig rpart;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getPosition(");
            buf.append("List order[").append(order).append("], ");
            buf.append("ReferencePartConfig reference[").append(reference).append("])");
            Tr.entry(tc, buf.toString());
        }
        int pos = 0;
        Iterator<ReferencePartConfig> i = order.iterator();
        while (i.hasNext() && !(rpart = i.next()).equals(reference)) {
            if (!i.hasNext()) continue;
            ++pos;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getPosition(List, ReferencePartConfig)");
            buf.append("returns int [").append(pos).append("]");
            Tr.exit(tc, buf.toString());
        }
        return pos;
    }

    public static void insertGenerator(List<Configuration> operationGenerators, List<ReferencePartConfig> order, int orderNumber, Configuration config2) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertGenerator(");
            buf.append("List operationGenerators[").append(operationGenerators).append("], ");
            buf.append("List order[").append(order).append("], ");
            buf.append("int orderNumber[").append(orderNumber).append("], ");
            buf.append("Configuration config)");
            Tr.entry(tc, buf.toString());
        }
        int pos = 0;
        Iterator<Configuration> i = operationGenerators.iterator();
        boolean found = false;
        while (i.hasNext()) {
            Configuration obj = i.next();
            int j = 0;
            if (obj instanceof EncryptionGeneratorConfig) {
                j = ConfigUtil.getPosition(order, ((EncryptionGeneratorConfig)obj).getReference());
            } else if (obj instanceof SignatureGeneratorConfig) {
                j = ConfigUtil.getMinimumPosition(order, ((SignatureGeneratorConfig)obj).getReferences());
            }
            if (j > orderNumber) {
                operationGenerators.add(pos, config2);
                found = true;
                break;
            }
            ++pos;
        }
        if (!found) {
            operationGenerators.add(config2);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertGenerator(");
            buf.append("List, List, int, Configuration)");
            Tr.exit(tc, buf.toString());
        }
    }

    public static String trim(String value) {
        String ret = null;
        if (value != null) {
            ret = value.trim();
        }
        return ret;
    }

    public static String expandInstallLocation(String fileLocation) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("expandInstallLocation(");
            buf.append("String algorithm[").append(fileLocation).append("])");
            Tr.entry(tc, buf.toString());
        }
        VariableExpander varMap = VariableExpanderFactory.getVariableExpander();
        String ret = varMap.expand(ConfigUtil.trim(fileLocation));
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("expandInstallLocation(String)");
            buf.append("returns String [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    static {
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#");
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DOMREQUIRED_TRANSFORMS = new HashSet<String>();
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/06/xmldsig-filter2");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xslt-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/07/decrypt#XML");
        SECRETKEY_ALGORITHMS = new HashSet<String>();
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes128");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes256");
    }

    private static class _MessageCatalog {
        private static final TraceComponent tc1 = Tr.register(_MessageCatalog.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        private static ResourceBundle instance;

        private _MessageCatalog() {
        }

        private static void init() {
            block5: {
                if (tc1.isEntryEnabled()) {
                    Tr.entry(tc1, "init()");
                }
                try {
                    instance = ResourceBundle.getBundle("com.ibm.ws.wssecurity.resources.wssmessages");
                    if (tc1.isDebugEnabled()) {
                        Tr.debug(tc1, "Initialize resource bundle: com.ibm.ws.wssecurity.resources.wssmessages");
                    }
                }
                catch (Throwable t) {
                    instance = null;
                    Tr.processException(t, _MessageCatalog.class.getName(), "1529");
                    Tr.warning(tc1, "security.wssecurity.cannot.load.resource", new Object[]{t});
                    if (!tc1.isDebugEnabled()) break block5;
                    Tr.debug(tc1, "Failed to initialize resource bundle: com.ibm.ws.wssecurity.resources.wssmessages");
                }
            }
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "init()");
            }
        }

        static {
            _MessageCatalog.init();
        }
    }
}

