/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Parameters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.MessageContext;

public final class ConfigConstants {
    public static final String TR_GROUP = "Web Services Security";
    public static final String TR_NLSPROPS = "com.ibm.ws.wssecurity.resources.wssmessages";
    public static final String WS_SECURITY_RESOURCE_NAME = "ws-security.xml";
    public static final String WS_SECURITY_DEFAULT_LOCATION = "${USER_INSTALL_ROOT}/properties/ws-security.xml";
    public static final String WS_SECURITY_LOCATION_PROPERTY = "wssecurity.defaultbindings.location";
    public static final String WS_INITIAL_SENDER_ID = "wssecurity.initial.sender.id";
    public static final String BASICAUTH_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    public static final String BASICAUTH_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    public static final String BASICAUTH_NONCE_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    public static final String BASICAUTH_NONCE_TIMESTAMP_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    public static final String BASICAUTH_NONCE_MAX_AGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    public static final String BASICAUTH_NONCE_CLOCK_SKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    public static final String BASICAUTH_NONCE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.useCache";
    public static final String BASICAUTH_NONCE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName";
    public static final String BASICAUTH_NONCE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize";
    public static final String BASICAUTH_NONCE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout";
    public static final String BASICAUTH_NONCE_LENGTH = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length";
    public static final String CERTIFICATE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.certificate.useCache";
    public static final String CERTIFICATE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.certificate.cacheName";
    public static final String CERTIFICATE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.certificate.cacheSize";
    public static final String CERTIFICATE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout";
    public static final String DISTRIBUTED_CONFIG_CACHE_USED = "com.ibm.ws.wssecurity.handler.useConfigCache";
    public static final String CONFIG_CACHENAME = "com.ibm.ws.wssecurity.handler.configCacheName";
    public static final String DISTRIBUTED_CONFIG_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.configCacheSize";
    public static final String DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = "com.ibm.ws.wssecurity.handler.configCacheTimeToLive";
    public static final String TOKEN_CACHE_USED = "com.ibm.ws.wssecurity.handler.token.useCache";
    public static final String TOKEN_CACHE_NAME = "com.ibm.ws.wssecurity.handler.token.cacheName";
    public static final String TOKEN_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.token.cacheSize";
    public static final String TOKEN_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.handler.token.cacheTimeout";
    public static final String TOKEN_CACHE_CUSHION = "com.ibm.ws.wssecurity.handler.token.cushion";
    public static final boolean DEFAULT_DISTRIBUTED_CONFIG_CACHE_USED = true;
    public static final String DEFAULT_CONFIG_CACHENAME = "WSSReqGeneratorConfigMap";
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_SIZE = 128;
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = 900;
    public static final String WSSREQGEN_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.GenConfigCacheKey";
    public static final String WSSRESCON_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.ConConfigCacheKey";
    public static final String OFFLOAD_ALL_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadAllCryptography";
    public static final String OFFLOAD_RSA_PUBKEY_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography";
    public static final String HARDWARE_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.hardwareCacheSize";
    public static final int DEFAULT_HARDWARE_CACHE_SIZE = 1000;
    public static final String HARDWARE_CACHE_ENTRY_REFRESH = "com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours";
    public static final int DEFAULT_HARDWARE_CACHE_ENTRY_REFRESH = 8;
    public static final boolean DEFAULT_NONCE_CACHEUSED = true;
    public static final String DEFAULT_NONCE_CACHENAME = "NonceDistributionCacheMap";
    public static final int DEFAULT_NONCE_CACHESIZE = 1024;
    public static final int MIN_NONCE_CACHESIZE = 16;
    public static final int DEFAULT_NONCE_CACHETIMEOUT = 600;
    public static final int MIN_NONCE_CACHETIMEOUT = 300;
    public static final int DEFAULT_NONCE_LENGTH = 128;
    public static final int MIN_NONCE_LENGTH = 16;
    public static final int DEFAULT_NONCE_MAXAGE = 300;
    public static final int MIN_NONCE_MAXAGE = 300;
    public static final int DEFAULT_NONCE_CLOCKSKEW = 0;
    public static final int MIN_NONCE_CLOCKSKEW = 0;
    public static final boolean DEFAULT_NONCE_DISTRIBUTED = false;
    public static final boolean DEFAULT_CERT_CACHEUSED = true;
    public static final String DEFAULT_CERT_CACHENAME = "WSSCertCache";
    public static final int DEFAULT_CERT_CACHESIZE = 128;
    public static final int MIN_CERT_CACHESIZE = 16;
    public static final int DEFAULT_CERT_CACHETIMEOUT = 900;
    public static final int MIN_CERT_CACHETIMEOUT = 300;
    public static final boolean DEFAULT_TOKEN_CACHEUSED = true;
    public static final String DEFAULT_TOKEN_CACHENAME = "WSSTokenCache";
    public static final int DEFAULT_TOKEN_CACHESIZE = 128;
    public static final int MIN_TOKEN_CACHESIZE = 16;
    public static final int DEFAULT_TOKEN_CACHETIMEOUT = 900;
    public static final int MIN_TOKEN_CACHETIMEOUT = 300;
    public static final int DEFAULT_TOKEN_CUSHION = 600;
    public static final int MIN_TOKEN_CUSHION = 300;
    public static final int DEFAULT_SYNC_CLUSTER_TIMEOUT = 300;
    public static final int DEFAULT_TIMESTAMP_TIMEOUT = 600;
    public static final int MIN_TIMESTAMP_TIMEOUT = 300;
    public static final int DEFAULT_TIMESTAMP_MAXAGE = 300;
    public static final int MIN_TIMESTAMP_MAXAGE = 300;
    public static final int DEFAULT_TIMESTAMP_CLOCKSKEW = 180;
    public static final int MIN_TIMESTAMP_CLOCKSKEW = 0;
    public static final long MIN_SC_CACHE_CUSHION = 180000L;
    public static final long DEFAULT_SC_CACHE_CUSHION = 600000L;
    public static final long DEFAULT_SC_CACHE_EXTRA_TIME = 600000L;
    public static final long DEFAULT_SCT_CLOCKSKEW = 180000L;
    public static final long MAX_SCT_CLOCKSKEW = 600000L;
    public static final long DEFAULT_CLOCKSKEW = 180000L;
    public static final String WSSE_NS = "com.ibm.ws.wssecurity.config.WSSE.Namespace";
    public static final String DEFAULT_CONFIG_REF = "DEFAULT";
    public static final String LOCALTEST_MODE = "com.ibm.ws.wssecurity.config.localtest.on";
    public static final String DISTRIBUTED_CACHE_PRE_V70_INTEROP_MODE = "com.ibm.ws.wssecurity.distributedcache.PreV70InteropMode";
    private static final TraceComponent tc = Tr.register(ConfigConstants.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static String getMessage(String key) {
        return ConfigUtil.getMessage(key);
    }

    public static Map<Object, Object> getProperties(List props, VariableExpander varMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(List, VariableExpander):", new Object[]{props, varMap});
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ConfigConstants.getProperties(map, props, varMap);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(List, VariableExpander)");
        }
        return map;
    }

    public static void getProperties(Map<Object, Object> map, List props, VariableExpander varMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(Map, List, VariableExpander):", new Object[]{map, props, varMap});
        }
        if (map != null && props != null && !props.isEmpty()) {
            int size = props.size();
            for (int j = 0; j < size; ++j) {
                String value;
                Object p;
                Object object = props.get(j);
                if (object instanceof Properties) {
                    p = (Properties)object;
                    value = varMap.expand(((Properties)p).getValue());
                    map.put(((Properties)p).getName(), value);
                    continue;
                }
                if (object instanceof com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties) {
                    p = (com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties)object;
                    value = varMap.expand(((com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties)p).getValue());
                    map.put(((com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties)p).getName(), value);
                    continue;
                }
                if (object instanceof com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Parameters) {
                    p = (com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Parameters)object;
                    value = varMap.expand(((com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Parameters)p).getValue());
                    map.put(((com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Parameters)p).getName(), value);
                    continue;
                }
                if (object instanceof Parameters) {
                    p = (Parameters)object;
                    value = varMap.expand(((Parameters)p).getValue());
                    map.put(((Parameters)p).getName(), value);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Property type not recognized");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(Map, List, VariableExpander)");
        }
    }

    public static int validNonceCacheTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheTimeout(int):", new Object[]{timeout});
        }
        if ((ret = timeout) < 300) {
            Tr.warning(tc, "security.wssecurity.WSEC0116W", new Object[]{ret, 300});
            ret = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheTimeout(int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceMaxAge(int maxAge, int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceMaxAge(int, int):", new Object[]{maxAge, timeout});
        }
        if ((ret = maxAge) < 300 || ret > timeout) {
            Tr.warning(tc, "security.wssecurity.WSEC0118W", new Object[]{ret, 300, timeout, 300});
            ret = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceMaxAge(int, int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceClockSkew(int clockSkew, int maxAge) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceClockSkew(int, int):", new Object[]{clockSkew, maxAge});
        }
        if ((ret = clockSkew) < 0 || ret > maxAge) {
            Tr.warning(tc, "security.wssecurity.WSEC0119W", new Object[]{ret, 0, maxAge, 0});
            ret = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceClockSkew(int, int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceCacheSize(int cacheSize) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheSize(int):", new Object[]{new Integer(cacheSize)});
        }
        if ((ret = cacheSize) < 16) {
            Tr.warning(tc, "security.wssecurity.WSEC0124W", new Object[]{ret, 16, 1024});
            ret = 1024;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheSize(int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceLength(int length) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceLength(int):", new Object[]{new Integer(length)});
        }
        if ((ret = length) < 16) {
            Tr.warning(tc, "security.wssecurity.WSEC0127W", new Object[]{ret, 16, 128});
            ret = 128;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceLength(int) returns " + ret);
        }
        return ret;
    }

    public static int processNonceMaxAge(String maxAge, int timeout) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceMaxAge(String, int):", new Object[]{maxAge, new Integer(timeout)});
        }
        int nonceMaxAge = 300;
        if (maxAge != null && (maxAge = maxAge.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(maxAge);
                nonceMaxAge = ConfigConstants.validNonceMaxAge(i, timeout);
            }
            catch (NumberFormatException e) {
                nonceMaxAge = 300;
                Tr.processException(e, ConfigConstants.class.getName() + ".processNonceMaxAge", "692");
                Tr.warning(tc, "security.wssecurity.WSEC0117W", new Object[]{maxAge, 300});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceMaxAge(String, int) returns " + nonceMaxAge);
        }
        return nonceMaxAge;
    }

    public static int processNonceClockSkew(String clockSkew, int maxAge) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceClockSkew(String, int):", new Object[]{clockSkew, new Integer(maxAge)});
        }
        int nonceClockSkew = 0;
        if (clockSkew != null && (clockSkew = clockSkew.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(clockSkew);
                nonceClockSkew = ConfigConstants.validNonceClockSkew(i, maxAge);
            }
            catch (NumberFormatException e) {
                nonceClockSkew = 0;
                Tr.processException(e, ConfigConstants.class.getName() + ".processNonceClockSkew", "720");
                Tr.warning(tc, "security.wssecurity.WSEC0120W", new Object[]{clockSkew, 0});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceClockSkew(String, int) returns " + nonceClockSkew);
        }
        return nonceClockSkew;
    }

    public static int processNonceCacheSize(String cacheSize) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceCacheSize(String):", new Object[]{cacheSize});
        }
        int nonceCacheSize = 1024;
        if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(cacheSize);
                nonceCacheSize = ConfigConstants.validNonceCacheSize(i);
            }
            catch (NumberFormatException e) {
                nonceCacheSize = 1024;
                Tr.processException(e, ConfigConstants.class.getName() + ".processNonceCacheSize", "748");
                Tr.warning(tc, "security.wssecurity.WSEC6823W", new Object[]{cacheSize, 1024});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceCacheSize(String) returns " + nonceCacheSize);
        }
        return nonceCacheSize;
    }

    public static int processNonceLength(String length) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceLength(String):", new Object[]{length});
        }
        int nonceLength = 128;
        if (length != null && (length = length.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(length);
                nonceLength = ConfigConstants.validNonceLength(i);
            }
            catch (NumberFormatException e) {
                nonceLength = 128;
                Tr.processException(e, ConfigConstants.class.getName() + ".processNonceLength", "779");
                Tr.warning(tc, "security.wssecurity.WSEC6824W", new Object[]{length, 1024});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceLength(String) returns " + nonceLength);
        }
        return nonceLength;
    }

    public static int validCertCacheTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            ret = 300;
            Tr.warning(tc, "security.wssecurity.WSEC6825W", new Object[]{ret, 300});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheTimeout(int) returns " + ret);
        }
        return ret;
    }

    public static int validCertCacheSize(int cacheSize) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheSize(int):", new Object[]{new Integer(cacheSize)});
        }
        if ((ret = cacheSize) < 16) {
            ret = 128;
            Tr.warning(tc, "security.wssecurity.WSEC6826W", new Object[]{ret, 16, 128});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheSize(int) returns " + ret);
        }
        return ret;
    }

    public static int processCertCacheSize(String cacheSize) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processCertCacheSize(String):", new Object[]{cacheSize});
        }
        int certCacheSize = 128;
        if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(cacheSize);
                certCacheSize = ConfigConstants.validCertCacheSize(i);
            }
            catch (NumberFormatException e) {
                certCacheSize = 128;
                Tr.processException(e, ConfigConstants.class.getName() + ".processCertCacheSize", "856");
                Tr.warning(tc, "security.wssecurity.WSEC6827W", new Object[]{cacheSize, 128});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processCertCacheSize(String) returns " + certCacheSize);
        }
        return certCacheSize;
    }

    public static long processHardwareCacheEntryRefresh(String cacheEntryRefresh) {
        long hardwareCacheEntryRefresh;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheEntryRefresh(String):", new Object[]{cacheEntryRefresh});
            }
            hardwareCacheEntryRefresh = 0L;
            if (cacheEntryRefresh != null && (cacheEntryRefresh = cacheEntryRefresh.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheEntryRefresh);
                    if (i >= 0) {
                        hardwareCacheEntryRefresh = i;
                    }
                }
                catch (NumberFormatException e) {
                    hardwareCacheEntryRefresh = 0L;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processHardwareCacheEntryRefresh", "1147");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache refresh time" + cacheEntryRefresh + ", cache entry refresh disabled.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheEntryRefresh(String) returns " + hardwareCacheEntryRefresh);
        }
        return hardwareCacheEntryRefresh;
    }

    public static int processHardwareCacheSize(String cacheSize) {
        int hardwareCacheSize;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheSize(String):", new Object[]{cacheSize});
            }
            hardwareCacheSize = 1000;
            if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheSize);
                    if (i >= 0) {
                        hardwareCacheSize = i;
                    }
                }
                catch (NumberFormatException e) {
                    hardwareCacheSize = 1000;
                    Tr.processException(e, ConfigConstants.class.getName() + ".processHardwareCacheSize", "%C");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache size" + cacheSize + ", default value " + 1000 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheSize(String) returns " + hardwareCacheSize);
        }
        return hardwareCacheSize;
    }

    public static int validTokenCacheTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            ret = 300;
            Tr.warning(tc, "security.wssecurity.WSEC6828W", new Object[]{ret, 300});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheTimeout(int) returns " + ret);
        }
        return ret;
    }

    public static int validTokenCacheSize(int cacheSize) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheSize(int):", new Object[]{new Integer(cacheSize)});
        }
        if ((ret = cacheSize) < 16) {
            ret = 128;
            Tr.warning(tc, "security.wssecurity.WSEC6829W", new Object[]{ret, 16, 128});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheSize(int) returns " + ret);
        }
        return ret;
    }

    public static int processTokenCacheSize(String cacheSize) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTokenCacheSize(String):", new Object[]{cacheSize});
        }
        int tokenCacheSize = 128;
        if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(cacheSize);
                tokenCacheSize = ConfigConstants.validTokenCacheSize(i);
            }
            catch (NumberFormatException e) {
                tokenCacheSize = 128;
                Tr.processException(e, ConfigConstants.class.getName() + ".processTokenCacheSize", "966");
                Tr.warning(tc, "security.wssecurity.WSEC6830W", new Object[]{cacheSize, 128});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTokenCacheSize(String) returns " + tokenCacheSize);
        }
        return tokenCacheSize;
    }

    public static long validTokenCushion(long cushion) {
        long ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validTokenCushion(long cushion = " + cushion + ")");
        }
        if ((ret = cushion) < 300000L) {
            ret = 300000L;
            Tr.warning(tc, "security.wssecurity.WSEC6831W", new Object[]{cushion, ret});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validTokenCushion(long) returns " + ret);
        }
        return ret;
    }

    public static int validTimestampTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            Tr.warning(tc, "security.wssecurity.WSEC0139W", new Object[]{ret, 300});
            ret = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampTimeout(int) returns " + ret);
        }
        return ret;
    }

    private static int validTimestampMaxAge(int maxAge, int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampMaxAge(int, int):", new Object[]{new Integer(maxAge), new Integer(timeout)});
        }
        if ((ret = maxAge) < 300 || ret > timeout) {
            Tr.warning(tc, "security.wssecurity.WSEC0141W", new Object[]{ret, 300, timeout, 300});
            ret = 300;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampMaxAge(int, int) returns " + ret);
        }
        return ret;
    }

    private static int validTimestampClockSkew(int clockSkew, int maxAge) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampClockSkew(int, int):", new Object[]{new Integer(clockSkew), new Integer(maxAge)});
        }
        if ((ret = clockSkew) < 0 || ret > maxAge) {
            Tr.warning(tc, "security.wssecurity.WSEC0142W", new Object[]{ret, 0, maxAge, 0});
            ret = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampClockSkew(int, int) returns " + ret);
        }
        return ret;
    }

    public static int processTimestampMaxAge(String maxAge, int timeout) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampMaxAge(String, int):", new Object[]{maxAge, new Integer(timeout)});
        }
        int timestampMaxAge = 300;
        if (maxAge != null && (maxAge = maxAge.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(maxAge);
                timestampMaxAge = ConfigConstants.validTimestampMaxAge(i, timeout);
            }
            catch (NumberFormatException e) {
                timestampMaxAge = 300;
                Tr.processException(e, ConfigConstants.class.getName() + ".processTimestampMaxAge", "947");
                Tr.warning(tc, "security.wssecurity.WSEC0140W", new Object[]{maxAge, 300});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampMaxAge(String, int) returns " + timestampMaxAge);
        }
        return timestampMaxAge;
    }

    public static int processTimestampClockSkew(String clockSkew, int maxAge) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampClockSkew(String, int):", new Object[]{clockSkew, new Integer(maxAge)});
        }
        int timestampClockSkew = 180;
        if (clockSkew != null && (clockSkew = clockSkew.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(clockSkew);
                timestampClockSkew = ConfigConstants.validTimestampClockSkew(i, maxAge);
            }
            catch (NumberFormatException e) {
                timestampClockSkew = 180;
                Tr.processException(e, ConfigConstants.class.getName() + ".processTimestampClockSkew", "975");
                Tr.warning(tc, "security.wssecurity.WSEC0143W", new Object[]{clockSkew, 180});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampClockSkew(String, int) returns " + timestampClockSkew);
        }
        return timestampClockSkew;
    }

    public static String getWSSENS(MessageContext messageContext) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSENS(MessageContext)");
        }
        if ((ns = (String)messageContext.getProperty("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSSE namespace found in MessageContext, use default");
            }
            ns = Constants.NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSENS(MessageContext) returns " + ns);
        }
        return ns;
    }

    public static String getWSUNS(MessageContext messageContext) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSUNS(MessageContext)");
        }
        if ((ns = (String)messageContext.getProperty("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace")) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSU namespace found in MessageContext, use default");
            }
            ns = Constants.NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSUNS(SOAPMessageContext) returns " + ns);
        }
        return ns;
    }
}

