/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.enc.XMLPartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;

public class ConfidentialDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(ConfidentialDialectElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final int BODYCONTENT = 0;
    public static final int USERNAMETOKEN = 1;
    public static final int DIGESTVALUE = 2;
    public static final int SIGNATURE = 3;
    public static final int WSCONTEXTCONTENT = 4;
    public static final int TIMESTAMP = 5;
    public static final int SIGNATURECONFIRMATION = 6;
    public static final String[] WASDIALECTS = new String[]{"bodycontent".intern(), "usernametoken".intern(), "digestvalue".intern(), "signature".intern(), "wscontextcontent".intern(), "timestamp".intern(), "signatureconfirmation".intern()};

    @Override
    public void init(Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(Node node[" + DOMUtils.getDisplayName(node) + "], Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String dialect = (String)context.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + dialect + "]");
        }
        if (dialect == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_WAS.equals(dialect)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        String keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + keyword + "]");
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + obj + "]");
        }
        String processType = (String)context.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + processType + "]");
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + elements + "]");
        }
        Collection configs = (Collection)context.get("com.ibm.ws.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token configurations [" + configs + "]");
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        OMDocument doc = com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil.getOwnerDocument(node);
        OMElement el = doc.getOMDocumentElement();
        ArrayList<OMNode> list = null;
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[0] + "]");
            }
            list = new ArrayList<SOAPBody>();
            OMElement body = null;
            try {
                body = el instanceof SOAPEnvelope ? ((SOAPEnvelope)el).getBody() : DOMUtil.getOneChildElement(el, nsSoap, "Body");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from SOAPEnvelope.getBody()" + e);
                }
                Tr.processException((Throwable)e, this.getClass().getName() + ".getElements", "194", this);
                throw new SoapSecurityException(e);
            }
            list.add(body);
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Content", list);
        } else if (WASDIALECTS[1].equals(keyword)) {
            OMElement security;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
            }
            if ((security = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null && (list = DOMUtils.getChildElements(security, nsWsse, "UsernameToken")) != null) {
                list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
            }
        } else if (WASDIALECTS[2].equals(keyword)) {
            OMElement security;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[2] + "]");
            }
            if ((security = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null && (list = DOMUtils.getChildElements(security, Constants.NS_DSIG, "DigestValue")) != null) {
                list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
            }
        } else if (WASDIALECTS[3].equals(keyword)) {
            OMElement security;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[3] + "]");
            }
            if ((security = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null && (list = DOMUtils.getChildElements(security, Constants.NS_DSIG, "Signature")) != null) {
                list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
            }
        } else if (WASDIALECTS[5].equals(keyword)) {
            OMElement security;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[5] + "]");
            }
            if ((security = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null && (list = DOMUtils.getChildElements(security, Constants.NS_WSU, "Timestamp")) != null) {
                list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
            }
        } else if (WASDIALECTS[6].equals(keyword)) {
            OMElement security;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[6] + "]");
            }
            if ((security = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null && (list = DOMUtils.getChildElements(security, Constants.NS_WSSE11, "SignatureConfirmation")) != null) {
                list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
            }
        } else if (WASDIALECTS[4].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[4] + "]");
            }
            if ((list = IntegralDialectElementSelector.getWSContextHeaderElement(doc)) != null) {
                list = new PartList("http://www.w3.org/2001/04/xmlenc#Content", list);
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", keyword);
        }
        if (processType != null && encryption && (list = IntegralDialectElementSelector.postprocess(doc, processType, list, elements, nsWsse, nsWsu, nonceManager, false, encryption, dialect, keyword)) != null && list.size() > 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", keyword);
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getElements returns an OMNodeList. Contents follow:");
            CommonLogUtils.logDebug(list, tc);
            Tr.exit(tc, "getElements(OMNode, Map) returns ArrayList[list]");
        }
        return list;
    }

    @Override
    public ArrayList<XMLElement> getXMLElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLElements(Node node[" + DOMUtils.getDisplayName(node) + "], Map context)");
        }
        ArrayList<XMLElement> list = null;
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String dialect = (String)context.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + dialect + "]");
        }
        if (dialect == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_WAS.equals(dialect)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        String keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + keyword + "]");
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + obj + "]");
        }
        if (!encryption) {
            throw new RuntimeException("Internal error: getXMLElements() only supported for encryption, not decryption");
        }
        String processType = (String)context.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + processType + "]");
        }
        if (processType != null) {
            throw new RuntimeException("Internal error: WSSObject-based runtime does not support WAS extensions for nonce/timestamp");
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        OMDocument doc = com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil.getOwnerDocument(node);
        OMElement el = doc.getOMDocumentElement();
        Security security = WSSObjectUtils.getWSSObjectSecurityHeader(context);
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[0] + "]");
            }
            list = new ArrayList();
            OMElement body = null;
            try {
                body = el instanceof SOAPEnvelope ? ((SOAPEnvelope)el).getBody() : DOMUtil.getOneChildElement(el, nsSoap, "Body");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from SOAPEnvelope.getBody()" + e);
                }
                Tr.processException((Throwable)e, this.getClass().getName() + ".getElements", "194", this);
                throw new SoapSecurityException(e);
            }
            list.add(new XMLElement(body));
            list = new XMLPartList("http://www.w3.org/2001/04/xmlenc#Content", list);
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
            }
            list = WSSObjectUtils.getChildXMLElements(security, Utf8ByteConstantsQNames.WSSE10.QN_USERNAME_TOKEN);
            list = new XMLPartList("http://www.w3.org/2001/04/xmlenc#Element", list);
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[3] + "]");
            }
            list = WSSObjectUtils.getChildXMLElements(security, Utf8ByteConstantsQNames.DSIG.QN_SIGNATURE);
            list = new XMLPartList("http://www.w3.org/2001/04/xmlenc#Element", list);
        } else if (WASDIALECTS[5].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[5] + "]");
            }
            list = WSSObjectUtils.getChildXMLElements(security, Utf8ByteConstantsQNames.WSU.QN_TIMESTAMP);
            list = new XMLPartList("http://www.w3.org/2001/04/xmlenc#Element", list);
        } else if (WASDIALECTS[6].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[6] + "]");
            }
            list = WSSObjectUtils.getChildXMLElements(security, Utf8ByteConstantsQNames.WSSE11.QN_SIGNATURE_CONFIRMATION);
            list = new XMLPartList("http://www.w3.org/2001/04/xmlenc#Element", list);
        } else {
            throw new RuntimeException("Internal error: keyword " + keyword + " not supported by JAX-WS WS-Security runtime");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getXMLElements returns an XMLElement ArrayList. Contents follow:");
            CommonLogUtils.logDebugXMLElement(list, tc);
            Tr.exit(tc, "getXMLElements(OMNode, Map) returns ArrayList[list]");
        }
        return list;
    }
}

