/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.util.LogOutputStream;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;

public class CommonLogUtils {
    private CommonLogUtils() {
    }

    public static long logDebug(OMElement om, TraceComponent tc) {
        return CommonLogUtils.logDebug(om, tc, Integer.MAX_VALUE);
    }

    public static long logDebug(OMElement om, TraceComponent tc, int limit) {
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        format.setAutoCloseWriter(true);
        format.setIgnoreXMLDeclaration(true);
        return CommonLogUtils.logDebug(om, tc, limit, format);
    }

    public static long logDebug(OMElement om, TraceComponent tc, int limit, OMOutputFormat format) {
        LogOutputStream logStream = new LogOutputStream(tc, limit);
        if (om != null) {
            try {
                om.serialize(logStream, format);
                logStream.flush();
                logStream.close();
            }
            catch (Throwable t) {
                Tr.debug(tc, t.getMessage());
                Tr.error(tc, t.getMessage());
            }
        } else {
            Tr.debug(tc, "OMElement sent to logDebug is null. Nothing to show.");
        }
        return logStream.getLength();
    }

    public static void logDebug(ArrayList<OMNode> list, TraceComponent tc) {
        if (list != null) {
            Tr.debug(tc, "The ArrayList <OMNode> contents are:");
            for (OMNode aNode : list) {
                if (aNode.getType() == 1) {
                    OMElement element = (OMElement)aNode;
                    Tr.debug(tc, "OMNode = ");
                    CommonLogUtils.logDebug(element, tc);
                    continue;
                }
                Tr.debug(tc, "OMNode = " + aNode.toString());
            }
        } else {
            Tr.debug(tc, "List is null");
        }
    }

    public static void logDebug(List<ArrayList<OMNode>> list, TraceComponent tc) {
        if (list != null) {
            for (ArrayList<OMNode> nodeList : list) {
                CommonLogUtils.logDebug(nodeList, tc);
            }
        } else {
            Tr.debug(tc, "List of OMNode ArrayList is null");
        }
    }

    public static void logDebugXMLElement(List<ArrayList<XMLElement>> list, TraceComponent tc) {
        if (list != null) {
            for (ArrayList<XMLElement> nodeList : list) {
                CommonLogUtils.logDebugXMLElement(nodeList, tc);
            }
        } else {
            Tr.debug(tc, "List of XMLElement ArrayList is null");
        }
    }

    public static void logDebugXMLElement(ArrayList<XMLElement> list, TraceComponent tc) {
        if (list != null) {
            Tr.debug(tc, "The ArrayList <XMLElement> contents are:");
            for (XMLElement anElement : list) {
                if (anElement.getType() == 1) {
                    OMNode aNode = anElement.getOMNode();
                    if (aNode == null) continue;
                    if (aNode.getType() == 1) {
                        OMElement element = (OMElement)aNode;
                        Tr.debug(tc, "XMLElement = ");
                        CommonLogUtils.logDebug(element, tc);
                        continue;
                    }
                    Tr.debug(tc, "XMLElement=" + aNode.toString());
                    continue;
                }
                Tr.debug(tc, "XMLElement = " + anElement.toString());
            }
        } else {
            Tr.debug(tc, "ArrayList<XMLElement> is null");
        }
    }

    public static void logDebug(ByteArrayInputStream in, String encoding, TraceComponent tc) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        int LENGTH = 4096;
        byte[] readbyte = new byte[LENGTH];
        LogOutputStream testLog = new LogOutputStream(tc, Integer.MAX_VALUE);
        testLog.setEncoding(encoding);
        try {
            int numReadBytes = in.read(readbyte);
            while (numReadBytes != -1) {
                testLog.write(readbyte, 0, numReadBytes);
                numReadBytes = in.read(readbyte);
            }
            testLog.flush();
            testLog.close();
        }
        catch (Exception e) {
            Tr.debug(tc, "WARNING: An exception was caught while writing byte array contents to log. Exception was e=" + e.getMessage());
        }
    }

    public static void logDebugEncode64(byte[] bytes, TraceComponent tc) {
        LogOutputStream testLog = new LogOutputStream(tc, Integer.MAX_VALUE);
        try {
            Base64.encode(bytes, 0, bytes.length, testLog);
            testLog.flush();
            testLog.close();
        }
        catch (Exception e) {
            Tr.debug(tc, "WARNING: An exception was caught while encoding byte to base64 and sending to log. Exception was e=" + e.getMessage());
        }
    }
}

