/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.axiom.om.OMElement;

public class CertificateUtil {
    private static final TraceComponent tc = Tr.register(CertificateUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CertificateUtil.class.getName();
    public static final int ENCIPHERMENT = 0;
    public static final int SIGNATURE = 1;
    private static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};

    public static boolean isUsedFor(Certificate cert, int type) {
        boolean[] usage;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsedFor(" + cert + ", " + type + ")");
        }
        boolean used = true;
        if (cert != null && "X.509".equals(cert.getType()) && (usage = ((X509Certificate)cert).getKeyUsage()) != null) {
            switch (type) {
                case 0: {
                    used = usage.length > 3 && usage[2] && usage[3];
                    break;
                }
                case 1: {
                    used = usage.length > 0 && usage[0];
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown usage type: " + type);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsedFor(Certificate cert, int type) returns " + used);
        }
        return used;
    }

    public static String keyUsageToString(Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyUsageToString(" + cert + ")");
        }
        String str = null;
        if (cert != null && "X.509".equals(cert.getType())) {
            str = CertificateUtil.keyUsageToString(((X509Certificate)cert).getKeyUsage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyUsageToString(Certificate cert) returns " + str);
        }
        return str;
    }

    public static String keyUsageToString(boolean[] usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyUsageToString(" + usage + ")");
        }
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        for (int i = 0; i < KEY_USAGE.length && i < usage.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(KEY_USAGE[i]);
            buf.append('=');
            buf.append(usage[i]);
        }
        buf.append('}');
        String str = buf.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyUsageToString(boolean[] usage) returns " + str);
        }
        return str;
    }

    public static X509DataUtil[] getX509Data(OMElement signature) throws XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509Data(" + signature + ")");
        }
        X509DataUtil[] x5u = null;
        try {
            KeyInfo keyInfo = CertificateUtil.getKeyInfo(signature);
            KeyInfo.X509Data[] x5data = keyInfo.getX509Data();
            if (x5data == null || x5data.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key k = keyInfo.getKeyValue();
            x5u = new X509DataUtil[x5data.length];
            for (int i = 0; i < x5data.length; ++i) {
                x5u[i] = new X509DataUtil(x5data[i], k);
            }
        }
        catch (SignatureStructureException sse) {
            throw new XSignatureException(sse);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509Data(Element signature) returns " + x5u);
        }
        return x5u;
    }

    private static KeyInfo getKeyInfo(OMElement signature) throws SignatureStructureException, XSignatureException {
        OMElement keyInfoElement;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfo(" + signature + ")");
        }
        if ((keyInfoElement = KeyInfo.searchForKeyInfo(signature)) == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        KeyInfo keyinfo = new KeyInfo(keyInfoElement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfo(Element signature) returns " + keyinfo);
        }
        return keyinfo;
    }

    public static X509Certificate generateX509Certificate(byte[] binary, Provider provider) throws CertificateException, NoSuchProviderException {
        return (X509Certificate)CertificateUtil.generateCertificate(binary, "X.509", provider);
    }

    public static Certificate generateCertificate(byte[] binary, String type, Provider provider) throws CertificateException, NoSuchProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateX509Certificate(byte[] binary[" + binary + "]," + "String type[" + type + "]," + "Provider provider[" + provider + "])");
        }
        Certificate cert = null;
        if (binary != null && type != null) {
            CertificateFactory factory = provider == null ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
            cert = factory.generateCertificate(new ByteArrayInputStream(binary));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateX509Certificate(byte[] binary,String type,Provider provider) returns Certificate[" + cert + "]");
        }
        return cert;
    }

    public static byte[] encodePkiPath(Provider provider, List certStores, KeyStore kstore, String alias) throws CertificateException, KeyStoreException {
        CertPath path;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePkiPath(Provider provider[" + provider + "]," + "List certStores[" + certStores + "]," + "KeyStore kstore[" + kstore + "]," + "String alias[" + alias + "])");
        }
        byte[] encoded = null;
        if (kstore != null && alias != null && (path = CertificateUtil.getCertPath(kstore, alias, provider)) != null) {
            encoded = path.getEncoded("PkiPath");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePkiPath(Provider provider,CertStores certStores,KeyStore kstore,String alias) returns byte[][" + encoded + "]");
        }
        return encoded;
    }

    public static byte[] encodePKCS7(Provider provider, List certStores, KeyStore kstore, String alias) throws CertStoreException, KeyStoreException, IOException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePKCS7(Provider provider[" + provider + "]," + "List certStores[" + certStores + "]," + "KeyStore kstore[" + kstore + "]," + "String alias[" + alias + "])");
        }
        byte[] encoded = null;
        if (kstore != null && alias != null) {
            CRL[] crls = CertificateUtil.extractCRLs(certStores);
            Content content = CertificateUtil.getSignedData(kstore, alias, crls);
            encoded = CertificateUtil.getBinaryEncodedContent(content);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePKCS7(Provider provider,List certStores,KeyStore kstore,String alias) returns byte[][" + encoded + "]");
        }
        return encoded;
    }

    private static CRL[] extractCRLs(List certStores) throws CertStoreException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractCRLs(List certStores[" + certStores + "])");
        }
        ArrayList<? extends CRL> crlList = new ArrayList<CRL>();
        if (certStores != null && !certStores.isEmpty()) {
            for (CertStore cs : certStores) {
                X509CRLSelector crlselector = new X509CRLSelector();
                Collection<? extends CRL> mycl = null;
                mycl = cs.getCRLs(crlselector);
                if (mycl == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, mycl.size() + " CRLs found in the cert store[" + cs + "].");
                }
                crlList.addAll(mycl);
            }
        }
        CRL[] crls = new CRL[crlList.size()];
        for (int i = 0; i < crls.length; ++i) {
            crls[i] = (CRL)crlList.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractCRLs(List certStores) returns CRL[] " + crls);
        }
        return crls;
    }

    private static Content getSignedData(KeyStore ks, String alias, CRL[] crls) throws KeyStoreException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedData(KeyStore ks[" + ks + "], " + "String alias[" + alias + "], " + "CRL[] crls[" + crls + "])");
        }
        SignedData data = null;
        Certificate[] certs = ks.getCertificateChain(alias);
        if (certs != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, certs.length + " certificates found");
            }
            data = new SignedData(certs, crls);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignedData(KeyStore ks, String alias, CRL[] crls,  returns SignedData[" + data + "]");
        }
        return data;
    }

    private static byte[] getBinaryEncodedContent(Content data) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBinaryEncodedContent(Content data[" + data + "])");
        }
        byte[] encoded = null;
        ContentInfo info = new ContentInfo(data);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        info.encode((OutputStream)os);
        encoded = os.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBinaryEncodedContent(Content data) retunrs byte[] " + encoded);
        }
        return encoded;
    }

    private static CertPath getCertPath(KeyStore ks, String alias, Provider provider) throws KeyStoreException, CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertPath(KeyStore ks[" + ks + "], " + "String alias[" + alias + "], " + "Provider provider[" + provider + "])");
        }
        CertPath path = null;
        Certificate[] certs = ks.getCertificateChain(alias);
        final Vector<Certificate> list = new Vector<Certificate>();
        if (certs == null) {
            Tr.debug(tc, "Acquired certificate chain is null.");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, certs.length + " certificates found");
            }
            for (int i = 0; i < certs.length; ++i) {
                list.add(certs[i]);
            }
            final CertificateFactory factory = provider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            try {
                path = (CertPath)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CertificateException {
                        CertPath path = factory.generateCertPath(list);
                        return path;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e.getCause();
                if (th instanceof CertificateException) {
                    throw (CertificateException)th;
                }
                throw new CertificateException(th.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertPath(KeyStore ks, String alias,Provider provider) returns CertPath[" + path + "]");
        }
        return path;
    }

    public static CertPath generateCertPath(byte[] binary, String factoryType, String encodingType, Provider provider) throws CertificateException, NoSuchProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCertPath(byte[] binary[" + binary + "]," + "String factoryType[" + factoryType + "]," + "String encodingType[" + encodingType + "]," + "Provider provider[" + provider + "])");
        }
        CertPath path = null;
        if (binary != null && factoryType != null && encodingType != null) {
            CertificateFactory factory = provider == null ? CertificateFactory.getInstance(factoryType) : CertificateFactory.getInstance(factoryType, provider);
            path = factory.generateCertPath(new ByteArrayInputStream(binary), encodingType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateCertPath(byte[] binary,String factoryType,String encoingType,Provider provider) returns CertPath[" + path + "]");
        }
        return path;
    }

    public static Collection generateCRLs(byte[] binary, String factoryType, Provider provider) throws CertificateException, CRLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCRLs(byte[] binary[" + binary + "]," + "String factoryType[" + factoryType + "]," + "Provider provider[" + provider + "])");
        }
        Collection<? extends CRL> c = null;
        if (binary != null && factoryType != null) {
            CertificateFactory factory = provider == null ? CertificateFactory.getInstance(factoryType) : CertificateFactory.getInstance(factoryType, provider);
            c = factory.generateCRLs(new ByteArrayInputStream(binary));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateCRLs(byte[] binary,String factoryType,Provider provider) returns Collection[" + c + "]");
        }
        return c;
    }

    public static PKIXCertPathValidatorResult validateX509Certificate(X509Certificate cert, Provider provider, PKIXParameters params) throws CertPathBuilderException, CertPathValidatorException, CertStoreException, KeyStoreException, InvalidAlgorithmParameterException, IOException, NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateX509Certificate(X509Certificate cert[" + cert + "], " + "Provider provider[" + provider + "]," + "PKIXParameters params[" + params + "])");
        }
        CertPathBuilderResult cpbResult = null;
        PKIXCertPathValidatorResult result = null;
        if (cert != null && params != null) {
            boolean trustCert = false;
            Set<TrustAnchor> trustAnchors = params.getTrustAnchors();
            if (trustAnchors != null && trustAnchors.size() > 0) {
                for (TrustAnchor ta : trustAnchors) {
                    X509Certificate trustedCert = ta.getTrustedCert();
                    if (!cert.equals(trustedCert)) continue;
                    trustCert = true;
                    break;
                }
            }
            if (!trustCert) {
                CertPathBuilder builder = provider == null ? CertPathBuilder.getInstance("PKIX") : CertPathBuilder.getInstance("PKIX", provider);
                X509CertSelector selector = (X509CertSelector)params.getTargetCertConstraints();
                selector.setSubject(cert.getSubjectX500Principal().getEncoded());
                params.setTargetCertConstraints(selector);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CertPathProvider = " + (provider == null ? "default" : provider.getName()));
                    Tr.debug(tc, "CertPath Builder = " + builder.getClass().getName());
                    Tr.debug(tc, "CertPath Selector = " + selector.getClass().getName());
                    Tr.debug(tc, "SubjectDN = " + cert.getSubjectX500Principal().getName());
                }
                HashSet<X509Certificate> certSet = new HashSet<X509Certificate>();
                certSet.add(cert);
                CertStore cs = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(certSet)) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certSet), provider);
                params.addCertStore(cs);
                List<CertStore> csList = params.getCertStores();
                X509CRLSelector crlSelector = new X509CRLSelector();
                boolean setRevocation = false;
                if (csList != null) {
                    for (CertStore tempCs : csList) {
                        Iterator<? extends CRL> crlIt;
                        Collection<? extends CRL> crlList = tempCs.getCRLs(crlSelector);
                        if (crlList == null || !(crlIt = crlList.iterator()).hasNext()) continue;
                        setRevocation = true;
                        break;
                    }
                }
                if (setRevocation) {
                    params.setRevocationEnabled(true);
                    Tr.debug(tc, " RevocationEnabled.");
                } else {
                    params.setRevocationEnabled(false);
                    Tr.debug(tc, " Revocation Not Enabled.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Building the cert path...");
                }
                cpbResult = builder.build(params);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CertPathBuilderResult=" + cpbResult);
                }
                if (cpbResult != null) {
                    result = CertificateUtil.validateCertPath(cpbResult.getCertPath(), params);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateX509Certificate(X509Certificate cert, Provider provider,PKIXParameters params) returns PKIXCertPathValidatorResult[" + result + "]");
        }
        return result;
    }

    public static PKIXCertPathValidatorResult validateCertPath(CertPath path, PKIXParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateCertPath(CertPath path[" + path + "]," + "PKIXParameters params[" + params + "])");
        }
        PKIXCertPathValidatorResult result = null;
        if (path != null && params == null) {
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            result = (PKIXCertPathValidatorResult)validator.validate(path, params);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCertPath(CertPath path,PKIXParameters params) returns PKIXCertPathValidatorResult[" + result + "]");
        }
        return result;
    }

    public static BigInteger convertSerialNumber(String data) throws ParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSerialNumber(String data[" + data + "])");
        }
        BigInteger result = null;
        if (data != null) {
            long value = 0L;
            for (int i = 0; i < data.length(); ++i) {
                value <<= 4;
                char ch = data.charAt(i);
                if ('0' <= ch && ch <= '9') {
                    value += (long)(ch - 48);
                    continue;
                }
                if ('a' <= ch && ch <= 'f') {
                    value += (long)(ch + 10 - 97);
                    continue;
                }
                if ('A' <= ch && ch <= 'F') {
                    value += (long)(ch + 10 - 65);
                    continue;
                }
                throw new ParseException("Illegal character: " + ch, i);
            }
            result = BigInteger.valueOf(value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSerialNumber(String data) returns BigInteger[" + result + "]");
        }
        return result;
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x5d, Key k) {
            this.x5data = x5d;
            this.publicKey = k;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCertStore()");
            }
            Vector<X509Certificate> certs = new Vector<X509Certificate>();
            X509Certificate[] srccerts = this.x5data.getCertificates();
            if (srccerts != null) {
                for (int j = 0; j < srccerts.length; ++j) {
                    certs.addElement(srccerts[j]);
                }
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCertStore() returns " + certStore);
            }
            return certStore;
        }

        public Key validate(PKIXBuilderParameters params) throws XSignatureException {
            return this.validateAndGetCert(params).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters params) throws XSignatureException {
            X509Certificate cert;
            CertPath path;
            List<CertStore> storeList;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateAndGetCert(" + params + ")");
            }
            ArrayList<CertStore> newList = new ArrayList<CertStore>(((storeList = params.getCertStores()) == null ? 0 : storeList.size()) + 1);
            for (int i = 0; i < storeList.size(); ++i) {
                newList.add(storeList.get(i));
            }
            try {
                newList.add(this.createCertStore());
                params.setCertStores(newList);
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                path = builder.build(params).getCertPath();
                validator.validate(path, params);
            }
            catch (InvalidAlgorithmParameterException iape) {
                params.setCertStores(storeList);
                throw new XSignatureException(iape);
            }
            catch (NoSuchAlgorithmException nsae) {
                params.setCertStores(storeList);
                throw new XSignatureException(nsae);
            }
            catch (CertPathBuilderException cpbe) {
                params.setCertStores(storeList);
                throw new XSignatureException(cpbe);
            }
            catch (CertPathValidatorException cpve) {
                params.setCertStores(storeList);
                throw new XSignatureException(cpve);
            }
            List<? extends Certificate> certs = path.getCertificates();
            X509Certificate x509Certificate = cert = certs.isEmpty() ? null : (X509Certificate)certs.get(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateAndGetCert(PKIXBuilderParameters params) returns " + cert);
            }
            return cert;
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] certs;
            String[] subjects;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSelector()");
            }
            X509CertSelector selector = new X509CertSelector();
            String[] issuers = this.x5data.getIssuerNames();
            if (issuers != null && issuers.length > 0) {
                BigInteger[] serials = this.x5data.getSerialNumbers();
                selector.setIssuer(issuers[0]);
                selector.setSerialNumber(serials[0]);
            }
            if ((subjects = this.x5data.getSubjectNames()) != null && subjects.length > 0) {
                selector.setSubject(subjects[0]);
            } else {
                X509Certificate[] certs2 = this.x5data.getCertificates();
                if (certs2 != null && certs2.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CertPath Selector = " + selector.getClass().getName());
                        Tr.debug(tc, "SubjectDN = " + certs2[0].getSubjectX500Principal().getName());
                    }
                    selector.setSubject(certs2[0].getSubjectX500Principal().getEncoded());
                }
            }
            Object[] skis = this.x5data.getSKIs();
            if (skis != null && skis.length > 0) {
                selector.setSubjectKeyIdentifier((byte[])skis[0]);
            }
            if ((certs = this.x5data.getCertificates()) != null && certs.length == 1) {
                selector.setCertificate(certs[0]);
            }
            if (this.publicKey != null) {
                selector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSelector() returns " + selector);
            }
            return selector;
        }
    }
}

