/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

public final class ArraysUtil {
    public static final boolean equals(byte[] array1, int off1, byte[] array2, int off2, int len) {
        if (array1 == null || array2 == null) {
            return false;
        }
        if (off1 + len > array1.length) {
            return false;
        }
        if (off2 + len > array2.length) {
            return false;
        }
        if (array1 == array2 && off1 == off2) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (array1[off1 + i] == array2[off2 + i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(int[] array1, int off1, int[] array2, int off2, int len) {
        if (array1 == null || array2 == null) {
            return false;
        }
        if (off1 + len > array1.length) {
            return false;
        }
        if (off2 + len > array2.length) {
            return false;
        }
        if (array1 == array2 && off1 == off2) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (array1[off1 + i] == array2[off2 + i]) continue;
            return false;
        }
        return true;
    }

    public static final String toHexString(byte[] array) {
        if (array == null) {
            return "null";
        }
        return ArraysUtil.toHexString(array, 0, array.length);
    }

    public static final String toHexString(int[] array) {
        if (array == null) {
            return "null";
        }
        return ArraysUtil.toHexString(array, 0, array.length);
    }

    public static final String toHexString(byte[] array, int off, int len) {
        if (array == null) {
            return "null";
        }
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(2 + len * 6);
        builder.append("[0x");
        builder.append(Integer.toHexString(array[off + 0] & 0xFF).toUpperCase());
        for (int i = 1; i < len; ++i) {
            builder.append(", 0x");
            builder.append(Integer.toHexString(array[off + i] & 0xFF).toUpperCase());
        }
        builder.append("]");
        return builder.toString();
    }

    public static final String toHexString(int[] array, int off, int len) {
        if (array == null) {
            return "null";
        }
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(2 + len * 6);
        builder.append("[0x");
        builder.append(Integer.toHexString(array[off + 0] & 0xFF).toUpperCase());
        for (int i = 1; i < len; ++i) {
            builder.append(", 0x");
            builder.append(Integer.toHexString(array[off + i] & 0xFF).toUpperCase());
        }
        builder.append("]");
        return builder.toString();
    }
}

