/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.net.URI;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTValidate
implements RequestHandler {
    private static final TraceComponent tc = Tr.register(SCTValidate.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    @Override
    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken request, String requestType, IConstants constants) throws InvalidRequestException {
        IElement validateTarget;
        String method = "handleRequest()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if ((validateTarget = request.getValidateTarget()) == null) {
            String errorMsg = "Missing ValidateTarget element.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s16", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        String uuid = SCTValidate.extractUUIDFromValidateTarget(validateTarget);
        if (uuid == null) {
            String errorMsg = "UUID was not successfully extracted from validate request. Validate failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s17", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        boolean valid = false;
        SCT sct = (SCT)SCTHelper.getCache().getToken(uuid);
        if (sct == null) {
            String errorMsg = "SCT with the UUID " + uuid + " does not exist. Validate failed.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
        } else {
            String[] instances;
            for (String instance : instances = sct.getInstances()) {
                if (!sct.isValid(instance, 0L)) continue;
                valid = true;
                break;
            }
            if (!valid && tc.isDebugEnabled()) {
                Tr.debug(tc, "All keys associated with the specified SCT have expired. Validate failed.");
            }
        }
        URI code = valid ? constants.getValidStatusCode() : constants.getInvalidStatusCode();
        IElement elemStatusRSTR = SCTValidate.generateStatus(code, null, constants);
        IRequestSecurityTokenResponse rstr = SCTHelper.createRSTR(request.getContext());
        rstr.setStatus(elemStatusRSTR);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return rstr;
    }

    @Override
    public void initialize(Properties configuration) {
    }

    private static String extractUUIDFromValidateTarget(IElement validateTarget) {
        String uuid = SCTHelper.extractTextFrom(validateTarget, new String[]{"SecurityContextToken", "Identifier"});
        return uuid;
    }

    private static IElement generateStatus(URI code, String reason, IConstants constants) {
        String method = "generateStatus()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (code == null || code.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Code is null or empty: this parameter is required.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        IElement elemStatus = SCTHelper.createIElement("Status", "wst", constants.getWSTrustNamespace());
        IElement elemCode = SCTHelper.createIElement("Code", "wst", constants.getWSTrustNamespace());
        SCTHelper.addTextTo(elemCode, code.toString());
        SCTHelper.addChildTo(elemStatus, elemCode);
        if (reason != null && !reason.equals("")) {
            IElement elemReason = SCTHelper.createIElement("Reason", "wst", constants.getWSTrustNamespace());
            SCTHelper.addTextTo(elemReason, reason);
            SCTHelper.addChildTo(elemStatus, elemReason);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return elemStatus;
    }
}

