/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.util.Date;
import java.util.Properties;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTPutToken
implements RequestHandler {
    private int renewalWindowMSec;
    private boolean initialized = false;
    private static final String CLASS_NAME = SCTPutToken.class.getName();
    private static final TraceComponent tc = Tr.register(SCTPutToken.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    @Override
    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken request, String requestType, IConstants constants) {
        String uuid;
        String method = "handleRequest()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (!this.initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return null;
        }
        SCT sct = (SCT)request.getData();
        boolean success = false;
        if (sct != null && (uuid = sct.getUUID()) != null && SCTHelper.getCache() != null && !SCTHelper.getCache().containsToken(uuid)) {
            Date earliestDate;
            String[] instances = sct.getInstances();
            Date latest = earliestDate = new Date(0L);
            if (instances != null) {
                for (int i = 0; i < instances.length; ++i) {
                    String currentInstance = instances[i];
                    Date currentExpiration = sct.getExpiration(currentInstance);
                    if (currentExpiration == null || !currentExpiration.after(latest)) continue;
                    latest = currentExpiration;
                }
                Date now = new Date();
                long timeout = -1L;
                if (!latest.equals(earliestDate)) {
                    timeout = latest.getTime() - now.getTime() + (long)this.renewalWindowMSec;
                }
                success = SCTHelper.getCache().cacheToken(uuid, sct, timeout);
            }
        }
        IRequestSecurityTokenResponse rstr = SCTHelper.createRSTR(request.getContext());
        rstr.setData(success);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return rstr;
    }

    @Override
    public void initialize(Properties configuration) {
        String renewalWindowMinutesString = configuration.getProperty("renewalWindowMinutes");
        this.renewalWindowMSec = Integer.valueOf(renewalWindowMinutesString);
        this.initialized = true;
    }
}

