/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.ext.sct;

import com.ibm.ws.wssecurity.trust.server.sts.ext.InvalidRequestException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandler;
import com.ibm.ws.wssecurity.trust.server.sts.ext.RequestHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.UninitializedHandlerException;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT13;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.eclipse.higgins.sts.IAppliesTo;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IElement;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.ILifetime;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.IRequestSecurityTokenResponse;

public class SCTIssue
implements RequestHandler {
    private URI wsc = null;
    private int lifetimeMSec;
    protected int renewalWindowMSec;
    private boolean renewableAfterExpiration;
    private String provider;
    private String provider_short;
    private String algorithm;
    private String algorithm_short;
    private String keySizeStr;
    private String keySizeStr_short;
    private int keySize;
    private String supportWSTrust10Draft;
    private static URI wsc10Draft = null;
    private static URI wsc13 = null;
    private URI wscURI = wsc13;
    private boolean initialized = false;
    protected static final int MINUTE_MSEC_CONVERSION_FACTOR = 60000;
    private static final String CLASS_NAME = SCTIssue.class.getName();
    private static final TraceComponent tc = Tr.register(SCTIssue.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    @Override
    public IRequestSecurityTokenResponse handleRequest(IRequestSecurityToken request, String requestType, IConstants constants) throws RequestHandlerException {
        URI tokenTypeURI;
        boolean renewableAfterExpirationRST;
        Integer keySize;
        String method = "handleRequest()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (!this.initialized) {
            String errorMsg = CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s06", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (UninitializedHandlerException)SCTHelper.populateIFault(new UninitializedHandlerException(errorMsg), "wst", constants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
        }
        URI wstNamespaceURI = constants.getWSTrustNamespace();
        String wstNamespace = wstNamespaceURI.toString();
        if (!this.supportWSTrust10Draft.equalsIgnoreCase("true") && wstNamespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            String errorMsg = "WSTrust 10 Draft not supported.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "supportWSTrust10Draft: " + this.supportWSTrust10Draft);
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IAppliesTo appliesTo = request.getAppliesTo();
        if (appliesTo == null) {
            String errorMsg = "AppliesTo element should not be null.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IEndpointReference appliesToEPR = appliesTo.getEndpointReference();
        if (appliesToEPR == null) {
            String errorMsg = "AppliesTo endpoint reference should not be null.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        IElement elemEntropyRST = request.getEntropy();
        byte[] clientSecret = this.extractBinarySecret(elemEntropyRST);
        String secretType = SCTHelper.extractAttributeFrom(elemEntropyRST, new String[]{"BinarySecret"}, "Type");
        if (clientSecret == null) {
            String errorMsg = "RequestSecurityToken is missing Entropy/BinarySecret";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s07", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        ILifetime elemLifetimeRST = request.getLifetime();
        Date created = null;
        Date expires = null;
        if (elemLifetimeRST != null) {
            created = elemLifetimeRST.getCreated();
            expires = elemLifetimeRST.getExpires();
        }
        if (created == null) {
            created = new Date();
        }
        Date defaultExpiration = new Date(created.getTime() + (long)this.lifetimeMSec);
        if (expires == null) {
            expires = defaultExpiration;
        }
        if (expires.getTime() - created.getTime() > (long)this.lifetimeMSec) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested lifetime is greater than the configured maximum lifetime. Using the configured maximum lifetime.");
            }
            expires = defaultExpiration;
        }
        if ((keySize = request.getKeySize()) == null) {
            keySize = this.keySize;
        }
        IElement elemRenewingRST = request.getRenewing();
        String renewableString = SCTHelper.extractAttributeFrom(elemRenewingRST, new String[0], "Allow");
        String renewableAfterExpirationString = SCTHelper.extractAttributeFrom(elemRenewingRST, new String[0], "OK");
        boolean renewableRST = renewableString == null ? true : Boolean.valueOf(renewableString);
        boolean bl = renewableAfterExpirationRST = renewableAfterExpirationString == null ? this.renewableAfterExpiration : Boolean.valueOf(renewableAfterExpirationString);
        if (!this.renewableAfterExpiration && renewableAfterExpirationRST) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current configuration prohibits renewing of this token after expiration.");
            }
            renewableAfterExpirationRST = false;
        }
        if ((tokenTypeURI = request.getTokenType()) == null) {
            String errorMsg = "RequestSecurityToken is missing TokenType";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.warning(tc, SCTHelper.getMessage("security.wssecurity.sct.s07", null));
        }
        SCT sct = this.createSCT(tokenTypeURI, clientSecret, keySize, created, expires, renewableRST, renewableAfterExpirationRST, appliesToEPR, wstNamespace);
        String sctValueType = null;
        QName sctValueTypeQName = sct.getValueType();
        if (sctValueTypeQName != null) {
            sctValueType = sctValueTypeQName.getLocalPart();
        }
        if (sctValueType == null) {
            sctValueType = tokenTypeURI.toString();
        }
        String wsuID = SCTHelper.generateUUID();
        String firstInstance = sct.getInstances()[0];
        IElement elemRequestedSecurityTokenRSTR = this.generateRequestedSecurityToken(sct, this.wscURI, wsuID, firstInstance, constants);
        IEndpointReference elemAppliesToRSTR = this.generateAppliesTo(appliesToEPR.getAddress());
        IElement elemRequestedAttachedReference = this.generateRequestedAttachedReference(wsuID, sctValueType, constants);
        IElement elemRequestedUnattachedReference = this.generateRequestedUnattachedReference(sct.getUUID(), sctValueType, constants);
        IElement elemEntropyRSTR = this.generateEntropy(sct.getServerSecret(firstInstance), secretType, constants);
        IElement elemRequestedProofTokenRSTR = this.generateRequestedProofToken(constants);
        ILifetime elemLifetimeRSTR = this.generateLifetime(sct.getCreation(firstInstance), sct.getExpiration(firstInstance));
        IElement elemRenewingRSTR = this.generateRenewing(renewableRST, renewableAfterExpirationRST, constants);
        IRequestSecurityTokenResponse rstr = SCTHelper.createRSTR(request.getContext());
        rstr.setRequestedSecurityToken(elemRequestedSecurityTokenRSTR);
        rstr.setAppliesTo(elemAppliesToRSTR);
        rstr.setRequestedAttachedReference(elemRequestedAttachedReference);
        rstr.setRequestedUnattachedReference(elemRequestedUnattachedReference);
        rstr.setEntropy(elemEntropyRSTR);
        rstr.setRequestedProofToken(elemRequestedProofTokenRSTR);
        rstr.setLifetime(elemLifetimeRSTR);
        rstr.setRenewing(elemRenewingRSTR);
        rstr.setKeySize(keySize);
        boolean cacheSuccess = this.cacheSCT(sct);
        if (!cacheSuccess) {
            String errorMsg = "SCT was not cached successfully.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            Tr.error(tc, SCTHelper.getMessage("security.wssecurity.sct.s08", null));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", constants.getWSTrustNamespace(), "RequestFailed", "security.wssecurity.WSEC6852E");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return rstr;
    }

    @Override
    public void initialize(Properties configuration) {
        String method = "initialize";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String lifetimeMinutesString = configuration.getProperty("lifetimeMinutes");
        String renewalWindowMinutesString = configuration.getProperty("renewalWindowMinutes");
        String renewableAfterExpirationString = configuration.getProperty("renewableAfterExpiration");
        this.lifetimeMSec = Integer.valueOf(lifetimeMinutesString) * 60000;
        this.renewalWindowMSec = Integer.valueOf(renewalWindowMinutesString) * 60000;
        this.renewableAfterExpiration = Boolean.valueOf(renewableAfterExpirationString);
        this.provider_short = configuration.getProperty("provider", "IBMJCE");
        this.provider = configuration.getProperty("com.ibm.wsspi.wssecurity.trust.provider", this.provider_short);
        this.algorithm_short = configuration.getProperty("com.ibm.wsspi.wssecurity.trust.algorithm", "AES");
        this.algorithm = configuration.getProperty("algorithm", this.algorithm_short);
        this.keySizeStr_short = configuration.getProperty("com.ibm.wsspi.wssecurity.trust.keySize", "128");
        this.keySizeStr = configuration.getProperty("com.ibm.wsspi.wssecurity.trust.keySize", this.keySizeStr_short);
        this.keySize = Integer.valueOf(this.keySizeStr);
        this.supportWSTrust10Draft = configuration.getProperty("com.ibm.wsspi.wssecurity.trust.supportWSTrust10Draft", "false");
        if (tc.isDebugEnabled()) {
            Enumeration<?> e = configuration.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Tr.debug(tc, "(" + key + ", " + configuration.getProperty(key) + ")");
            }
            Tr.debug(tc, "Configured value - lifetimeMSec: " + this.lifetimeMSec);
            Tr.debug(tc, "Configured value - renewalWindowMSec: " + this.renewalWindowMSec);
            Tr.debug(tc, "Configured value - renewableAfterExpiration: " + this.renewableAfterExpiration);
            Tr.debug(tc, "Configured value - provider: " + this.provider);
            Tr.debug(tc, "Configured value - algorithm: " + this.algorithm);
            Tr.debug(tc, "Configured value - keySize: " + this.keySize);
            Tr.debug(tc, "Configured value - supportWSTrust10Draft: " + this.supportWSTrust10Draft);
        }
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    protected byte[] extractBinarySecret(IElement elemEntropy) {
        String binarySecretString;
        byte[] binarySecret = null;
        if (elemEntropy != null && (binarySecretString = SCTHelper.extractTextFrom(elemEntropy, new String[]{"BinarySecret"})) != null) {
            binarySecret = SCTHelper.decode(binarySecretString);
        }
        return binarySecret;
    }

    protected IElement generateRequestedSecurityToken(SCT sct, URI wscURI, String wsuID, String instance, IConstants constants) {
        IElement elemRequestedSecurityToken = null;
        if (sct != null) {
            elemRequestedSecurityToken = SCTHelper.createIElement("RequestedSecurityToken", "wst", constants.getWSTrustNamespace());
            IElement elemSecureContextToken = SCTHelper.createIElement("SecurityContextToken", "wsc", wscURI);
            SCTHelper.addAttributeTo(elemSecureContextToken, "Id", "wsu", constants.getWSSecurityUtilityNamespace(), wsuID);
            IElement elemIdentifier = SCTHelper.createIElement("Identifier", "wsc", wscURI);
            SCTHelper.addTextTo(elemIdentifier, sct.getUUID());
            SCTHelper.addChildTo(elemSecureContextToken, elemIdentifier);
            SCTHelper.addChildTo(elemRequestedSecurityToken, elemSecureContextToken);
            if (instance != null) {
                IElement elemInstance = SCTHelper.createIElement("Instance", "wsc", wscURI);
                SCTHelper.addTextTo(elemInstance, instance);
                SCTHelper.addChildTo(elemSecureContextToken, elemInstance);
            }
        }
        return elemRequestedSecurityToken;
    }

    protected IEndpointReference generateAppliesTo(URI endpointURI) {
        return SCTHelper.createIEndpointReference(endpointURI);
    }

    protected IElement generateRequestedAttachedReference(String wsuID, String sctValueType, IConstants constants) {
        IElement elemRequestedAttachedReference = SCTHelper.createIElement("RequestedAttachedReference", "wst", constants.getWSTrustNamespace());
        IElement elemSecurityTokenReference = SCTHelper.createIElement("SecurityTokenReference", "wsse", constants.getWSSecurityNamespace());
        IElement elemReference = SCTHelper.createIElement("Reference", "wsse", constants.getWSSecurityNamespace());
        SCTHelper.addAttributeTo(elemReference, "URI", null, null, "#" + wsuID);
        SCTHelper.addAttributeTo(elemReference, "ValueType", null, null, sctValueType);
        SCTHelper.addChildTo(elemRequestedAttachedReference, elemSecurityTokenReference);
        SCTHelper.addChildTo(elemSecurityTokenReference, elemReference);
        return elemRequestedAttachedReference;
    }

    protected IElement generateRequestedUnattachedReference(String uuid, String sctValueType, IConstants constants) {
        IElement elemRequestedUnattachedReference = null;
        if (uuid != null) {
            elemRequestedUnattachedReference = SCTHelper.createIElement("RequestedUnattachedReference", "wst", constants.getWSTrustNamespace());
            IElement elemSecurityTokenReference = SCTHelper.createIElement("SecurityTokenReference", "wsse", constants.getWSSecurityNamespace());
            IElement elemReference = SCTHelper.createIElement("Reference", "wsse", constants.getWSSecurityNamespace());
            SCTHelper.addAttributeTo(elemReference, "URI", null, null, uuid);
            SCTHelper.addAttributeTo(elemReference, "ValueType", null, null, sctValueType);
            SCTHelper.addChildTo(elemRequestedUnattachedReference, elemSecurityTokenReference);
            SCTHelper.addChildTo(elemSecurityTokenReference, elemReference);
        }
        return elemRequestedUnattachedReference;
    }

    protected IElement generateEntropy(byte[] serverSecret, String secretType, IConstants constants) {
        String serverSecretString;
        IElement elemEntropy = null;
        if (serverSecret != null && (serverSecretString = SCTHelper.encode(serverSecret)) != null) {
            elemEntropy = SCTHelper.createIElement("Entropy", "wst", constants.getWSTrustNamespace());
            IElement elemBinarySecret = SCTHelper.createIElement("BinarySecret", "wst", constants.getWSTrustNamespace());
            if (secretType != null && !secretType.equals("")) {
                SCTHelper.addAttributeTo(elemBinarySecret, "Type", null, null, secretType);
            }
            SCTHelper.addTextTo(elemBinarySecret, serverSecretString);
            SCTHelper.addChildTo(elemEntropy, elemBinarySecret);
        }
        return elemEntropy;
    }

    protected IElement generateRequestedProofToken(IConstants constants) {
        IElement requestedProofToken = SCTHelper.createIElement("RequestedProofToken", "wst", constants.getWSTrustNamespace());
        IElement computedKey = SCTHelper.createIElement("ComputedKey", "wst", constants.getWSTrustNamespace());
        SCTHelper.addTextTo(computedKey, constants.getPSHA1ComputedKey().toString());
        SCTHelper.addChildTo(requestedProofToken, computedKey);
        return requestedProofToken;
    }

    protected ILifetime generateLifetime(Date created, Date expires) {
        return SCTHelper.createILifetime(created, expires);
    }

    protected IElement generateRenewing(boolean renewable, boolean renewableAfterExpiration, IConstants constants) {
        IElement elemRenewing = SCTHelper.createIElement("Renewing", "wst", constants.getWSTrustNamespace());
        SCTHelper.addAttributeTo(elemRenewing, "Allow", null, null, new Boolean(renewable).toString());
        SCTHelper.addAttributeTo(elemRenewing, "OK", null, null, new Boolean(renewableAfterExpiration).toString());
        return elemRenewing;
    }

    private SCT createSCT(URI tokenTypeURI, byte[] clientSecret, int keySize, Date created, Date expires, boolean renewable, boolean renewableAfterExpiration, IEndpointReference epr, String ns_wst) throws InvalidRequestException {
        String method = "createSCT()";
        byte[] serverSecret = SCTHelper.generateSecret(this.algorithm, this.provider, keySize);
        String firstInstance = SCTHelper.generateUUID();
        SCT.KeyHistoryEntry keyEntry = new SCT.KeyHistoryEntry(firstInstance, clientSecret, serverSecret, created, expires, SCT.SCTState.ISSUED);
        String newUUID = SCTHelper.generateUUID();
        while (SCTHelper.isCached(newUUID)) {
            newUUID = SCTHelper.generateUUID();
        }
        SCT sct = null;
        String tokenType = null;
        if (tokenTypeURI != null) {
            tokenType = tokenTypeURI.toString();
        }
        if (tokenType == null) {
            if (ns_wst.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
                sct = new SCT(newUUID, new SCT.KeyHistoryEntry[]{keyEntry});
                this.wscURI = wsc10Draft;
            } else {
                sct = new SCT13(newUUID, new SCT.KeyHistoryEntry[]{keyEntry});
                this.wscURI = wsc13;
            }
        } else if (tokenType.equals("http://schemas.xmlsoap.org/ws/2005/02/sc/sct")) {
            sct = new SCT(newUUID, new SCT.KeyHistoryEntry[]{keyEntry});
            this.wscURI = wsc10Draft;
        } else if (tokenType.equals("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct")) {
            sct = new SCT13(newUUID, new SCT.KeyHistoryEntry[]{keyEntry});
            this.wscURI = wsc13;
        } else {
            String errorMsg = "Invalid TokenType, tokentype = " + tokenType;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw (InvalidRequestException)SCTHelper.populateIFault(new InvalidRequestException(errorMsg), "wst", tokenTypeURI, "InvalidRequest", "security.wssecurity.WSEC6850E");
        }
        if (sct != null) {
            sct.setRenewable(renewable);
            sct.setRenewableAfterExpiration(renewableAfterExpiration);
            sct.setAlgorithm(this.algorithm);
            sct.setProvider(this.provider);
            sct.setKeySize(keySize);
            sct.setAppliesTo(epr.getAddress().toString());
        }
        return sct;
    }

    private boolean cacheSCT(SCT sct) throws UninitializedHandlerException {
        String[] instances;
        String method = "cacheSCT()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (!this.initialized) {
            String errorMsg = CLASS_NAME + " has not been initialized. " + "Initialize the handler before handling requests.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            throw new UninitializedHandlerException(errorMsg);
        }
        String identifier = sct.getIdentifier();
        if (identifier != null && SCTHelper.getCache() != null && !SCTHelper.getCache().containsToken(identifier) && (instances = sct.getInstances()).length > 0) {
            String instance = instances[0];
            Date expiration = sct.getExpiration(instance);
            Date now = new Date();
            if (!SCTHelper.getCache().getPreV70InteropMode()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issue key = " + identifier + instance);
                }
                SCTHelper.getCache().cacheToken(identifier + instance, sct, expiration == null ? -1L : expiration.getTime() - now.getTime() + (long)this.renewalWindowMSec);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Issue key again = " + identifier);
            }
            return SCTHelper.getCache().cacheToken(identifier, sct, expiration == null ? -1L : expiration.getTime() - now.getTime() + (long)this.renewalWindowMSec);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return false;
    }

    static {
        try {
            wsc10Draft = new URI("http://schemas.xmlsoap.org/ws/2005/02/sc");
            wsc13 = new URI("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        catch (URISyntaxException e) {
            Tr.warning(tc, "unable to instantiate wsc URIs");
        }
    }
}

