/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.net.InetAddress;
import java.net.URL;

public class STSUriUtil {
    private static final TraceComponent tc = Tr.register(STSUriUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static int URICompare(String attachedResourceURI, String testResourceURI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "URICompare(attachedResourceURI[" + attachedResourceURI + "], testResourceURI[" + testResourceURI + "])");
        }
        int distanceNormalized = Integer.MAX_VALUE;
        int distance = Integer.MAX_VALUE;
        String[] normalizedSoapURIs = null;
        String[] normalizedConfigURIs = null;
        distance = STSUriUtil.StringCompare(attachedResourceURI = attachedResourceURI.trim(), testResourceURI = testResourceURI.trim());
        if (distance > 0) {
            normalizedSoapURIs = STSUriUtil.NormalizeURI(attachedResourceURI);
            normalizedConfigURIs = STSUriUtil.NormalizeURI(testResourceURI);
            for (int i = 0; i < normalizedSoapURIs.length; ++i) {
                for (int j = 0; j < normalizedConfigURIs.length; ++j) {
                    distanceNormalized = STSUriUtil.StringCompare(normalizedSoapURIs[i], normalizedConfigURIs[j]);
                    if (distanceNormalized >= distance) continue;
                    distance = distanceNormalized;
                }
            }
            if (distance == Integer.MAX_VALUE) {
                distance = -1;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "URICompare(...) returns distance[" + distance + "]");
        }
        return distance;
    }

    public static int ResourceCompare(String attachedResource, String testResource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourceCompare(attachedResource[" + attachedResource + "], testResource[" + testResource + "]");
        }
        int distance = Integer.MAX_VALUE;
        int distanceNormalized = Integer.MAX_VALUE;
        String[] normalizedSoapURIs = null;
        String[] normalizedConfigURIs = null;
        distance = STSUriUtil.StringCompare(attachedResource, testResource);
        if (distance == Integer.MAX_VALUE) {
            String prefixTest;
            String prefixAttached = STSUriUtil.getPrefix(attachedResource);
            if (!STSUriUtil.equals(prefixAttached, prefixTest = STSUriUtil.getPrefix(testResource))) {
                distance = Integer.MAX_VALUE;
            } else {
                String serviceTest;
                String serviceAttached = STSUriUtil.getService(attachedResource);
                if (!STSUriUtil.equals(serviceAttached, serviceTest = STSUriUtil.getService(testResource))) {
                    distance = Integer.MAX_VALUE;
                } else {
                    String protocolTest;
                    String protocolAttached = STSUriUtil.getResourceProtocol(attachedResource);
                    if (!STSUriUtil.equalsIgnoreCase(protocolAttached, protocolTest = STSUriUtil.getResourceProtocol(testResource))) {
                        distance = Integer.MAX_VALUE;
                    } else {
                        normalizedSoapURIs = STSUriUtil.NormalizeResource(attachedResource);
                        normalizedConfigURIs = STSUriUtil.NormalizeResource(testResource);
                        for (int i = 0; i < normalizedSoapURIs.length; ++i) {
                            for (int j = 0; j < normalizedConfigURIs.length; ++j) {
                                distanceNormalized = STSUriUtil.StringCompare(normalizedSoapURIs[i], normalizedConfigURIs[j]);
                                if (distanceNormalized >= distance) continue;
                                distance = distanceNormalized;
                            }
                        }
                    }
                }
            }
            if (distance == Integer.MAX_VALUE) {
                distance = -1;
            }
        }
        if (tc.isDebugEnabled()) {
            if (distance == 0) {
                Tr.debug(tc, "TRUST POLICY SET MATCH FOUND!");
            } else if (distance != -1) {
                Tr.debug(tc, "Inherited trust policy set found.  Keep looking for better match.");
            } else {
                Tr.debug(tc, "Policy set does not apply.  Keep looking.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourceCompare(...) returns distance[" + distance + "]");
        }
        return distance;
    }

    private static String[] NormalizeURI(String anURL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NormalizeURI(anURL[" + anURL + "])");
        }
        String HTTP_PROTOCOL = "http://";
        String HTTPS_PROTOCOL = "https://";
        int DEFAULT_HTTP_PORT = 80;
        boolean includedProtocol = false;
        URL normalizedURL = null;
        URL urlToNormalize = null;
        String hostName = null;
        String protocol = null;
        int normalizedPort = 80;
        String normalizedHostName = null;
        String urlString = null;
        String[] normalizedURIs = null;
        InetAddress[] ipAddresses = null;
        if (anURL.length() == 0) {
            normalizedURIs = new String[]{anURL};
        } else {
            block22: {
                block21: {
                    if (anURL.regionMatches(true, 0, "http://", 0, "http://".length()) || anURL.regionMatches(true, 0, "https://", 0, "https://".length())) {
                        urlString = anURL;
                        includedProtocol = true;
                    } else {
                        urlString = "http://" + anURL;
                    }
                    try {
                        urlToNormalize = new URL(urlString);
                        normalizedPort = urlToNormalize.getPort();
                        if (normalizedPort == -1 && (normalizedPort = urlToNormalize.getDefaultPort()) == -1) {
                            normalizedPort = 80;
                        }
                        if ((hostName = urlToNormalize.getHost()).equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1") || hostName.equalsIgnoreCase("localhost.localdomain")) {
                            InetAddress localhost = InetAddress.getLocalHost();
                            String localHostName = localhost.getHostName();
                            ipAddresses = InetAddress.getAllByName(localHostName);
                        } else {
                            ipAddresses = InetAddress.getAllByName(hostName);
                        }
                        normalizedURIs = new String[ipAddresses.length];
                        for (int i = 0; i < ipAddresses.length; ++i) {
                            normalizedHostName = ipAddresses[i].getHostAddress();
                            normalizedURL = new URL(urlToNormalize.getProtocol(), normalizedHostName, normalizedPort, urlToNormalize.getFile());
                            if (includedProtocol) {
                                normalizedURIs[i] = normalizedURL.toString();
                                continue;
                            }
                            if (includedProtocol) continue;
                            normalizedURIs[i] = normalizedURL.toString().substring("http://".length());
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "Unable to normalize URL: " + e.getMessage());
                    }
                }
                if (normalizedURIs == null || normalizedURIs[0] == null) {
                    String lcProtocol = null;
                    String lcHostName = null;
                    try {
                        protocol = STSUriUtil.getURLProtocol(anURL);
                        if (protocol != null) {
                            lcProtocol = protocol.toLowerCase();
                        }
                        if ((hostName = STSUriUtil.getIPAddress(anURL)) != null) {
                            lcHostName = hostName.toLowerCase();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "protocol[" + protocol + "], lcProtocol[" + lcProtocol + "], hostName[" + hostName + "], lcHostName[" + lcHostName + "]");
                        }
                        if (lcHostName != null && lcProtocol != null) {
                            String tempURL1 = null;
                            tempURL1 = protocol.equals(lcProtocol) ? anURL : STSUriUtil.replaceSubstring(anURL, protocol, lcProtocol);
                            String tempURL2 = null;
                            tempURL2 = hostName.equals(lcHostName) ? anURL : STSUriUtil.replaceSubstring(tempURL1, hostName, lcHostName);
                            normalizedURIs = new String[]{tempURL2};
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "Unable to lowercase protocol and IP Address in URL: " + e.getMessage());
                    }
                }
            }
            if (normalizedURIs == null || normalizedURIs[0] == null) {
                normalizedURIs = new String[]{anURL};
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NormalizeURI(...) returns normalizedURIs");
        }
        return normalizedURIs;
    }

    private static String[] NormalizeResource(String resource) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NormalizeResource(resource[" + resource + "])");
        }
        String URI_START = ":/";
        int uriStartIndex = 0;
        String[] normalizedURI = null;
        String[] normalizedResource = null;
        uriStartIndex = resource.indexOf(":/") + 2;
        normalizedURI = STSUriUtil.NormalizeURI(resource.substring(uriStartIndex));
        if (normalizedURI != null) {
            normalizedResource = new String[normalizedURI.length];
            for (i = 0; i < normalizedURI.length; ++i) {
                normalizedResource[i] = resource.substring(0, uriStartIndex) + normalizedURI[i];
            }
        } else {
            normalizedResource = new String[]{resource};
        }
        if (tc.isDebugEnabled()) {
            if (normalizedResource == null) {
                Tr.debug(tc, "normalizedResource == null");
            } else {
                for (i = 0; i < normalizedResource.length; ++i) {
                    Tr.debug(tc, "normalizedResource[" + i + "] is [" + normalizedResource[i] + "]");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NormalizeResource(...) returns normalizedResource");
        }
        return normalizedResource;
    }

    public static int StringCompare(String attachedResource, String testResource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StringCompare(attachedResource[" + attachedResource + "], testResource[" + testResource + "]");
        }
        int distance = 0;
        distance = testResource.startsWith(attachedResource) ? testResource.length() - attachedResource.length() : Integer.MAX_VALUE;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StringCompare(...) returns distance[" + distance + "]");
        }
        return distance;
    }

    public static boolean equals(String string1, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(string1[" + string1 + "], string2[" + string2 + "])");
        }
        boolean rc = false;
        rc = string1 == null || string2 == null ? false : string1.equals(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(...) returns rc[" + rc + "]");
        }
        return rc;
    }

    public static boolean equalsIgnoreCase(String string1, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsIgnoreCase(string1[" + string1 + "], string2[" + string2 + "])");
        }
        boolean rc = false;
        rc = string1 == null || string2 == null ? false : string1.equalsIgnoreCase(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsIgnoreCase(...) returns rc[" + rc + "]");
        }
        return rc;
    }

    public static String getPrefix(String resource) {
        String prefix = STSUriUtil.getSubstring(resource, null, ":/");
        return prefix;
    }

    public static String getResourceProtocol(String resource) {
        String protocol = STSUriUtil.getSubstring(resource, ":/", "://");
        return protocol;
    }

    public static String getURLProtocol(String resource) {
        String protocol = STSUriUtil.getSubstring(resource, null, "://");
        return protocol;
    }

    public static String getIPAddress(String resource) {
        String ipAddress = STSUriUtil.getSubstring(resource, "://", ":");
        if (ipAddress == null) {
            ipAddress = STSUriUtil.getSubstring(resource, "://", "/");
        }
        return ipAddress;
    }

    public static String getPort(String resource, String ipAddress) {
        String port = null;
        if (ipAddress != null) {
            StringBuffer address = new StringBuffer(ipAddress);
            address.append(':');
            port = STSUriUtil.getSubstring(resource, address.toString(), "/");
        }
        return port;
    }

    public static String getService(String resource) {
        String ipAddress = null;
        String port = null;
        String service = null;
        StringBuffer address = null;
        ipAddress = STSUriUtil.getIPAddress(resource);
        if (ipAddress != null) {
            address = new StringBuffer(ipAddress);
            port = STSUriUtil.getPort(resource, ipAddress);
            if (port != null && port.length() > 0) {
                address.append(':');
                address.append(port);
            }
            service = STSUriUtil.getSubstring(resource, address.toString(), null);
        }
        return service;
    }

    public static String getSubstring(String resource, String before, String after) {
        int startIndex = -1;
        int endIndex = -1;
        String substring = null;
        if (before == null) {
            startIndex = 0;
        } else {
            startIndex = resource.indexOf(before);
            if (startIndex != -1) {
                startIndex += before.length();
            }
        }
        if (startIndex != -1) {
            endIndex = after == null ? resource.length() : resource.indexOf(after, startIndex);
        }
        substring = startIndex == -1 || endIndex == -1 ? null : resource.substring(startIndex, endIndex);
        return substring;
    }

    public static String replaceSubstring(String string, String substring, String newSubstring) {
        StringBuffer buffer = null;
        int startIndex = -1;
        int endIndex = -1;
        String before = null;
        String after = null;
        String lowercaseString = null;
        if (string != null && substring != null && newSubstring != null && (startIndex = string.indexOf(substring)) != -1) {
            endIndex = startIndex + substring.length();
            before = string.substring(0, startIndex);
            after = string.substring(endIndex, string.length());
            buffer = new StringBuffer(before);
            if (buffer != null) {
                buffer.append(newSubstring);
                buffer.append(after);
                lowercaseString = buffer.toString();
            }
        }
        return lowercaseString;
    }
}

