/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.trust.server.sts.STSCallbackHandler;
import com.ibm.ws.wssecurity.trust.server.sts.Util.Constants;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSUriUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;
import org.eclipse.higgins.sts.IAddressingInformation;
import org.eclipse.higgins.sts.IAppliesTo;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.ISTSRequest;

public class STSSecurityUtil {
    private static final TraceComponent tc = Tr.register(STSSecurityUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = STSSecurityUtil.class.getName();
    private URI to = null;
    private URI appliesTo = null;
    private URI issuer = null;
    private STSTargetMap targetMap;
    private Subject subject;
    private Set<SecurityToken> securityTokenSet = null;

    public void invoke(ISTSRequest request, MessageContext inMessage) throws SoapSecurityException {
        List requestSecurityTokenList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + request + ", " + inMessage + ")");
        }
        IAddressingInformation addressingInformation = request.getAddressingInformation();
        this.to = addressingInformation.getTo();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stsTo: " + this.to);
        }
        if ((requestSecurityTokenList = request.getRequestSecurityTokenCollection()).isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException e = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw e;
        }
        IRequestSecurityToken requestSecurityToken = (IRequestSecurityToken)requestSecurityTokenList.get(0);
        IAppliesTo appliesTo = requestSecurityToken.getAppliesTo();
        if (appliesTo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException e = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw e;
        }
        IEndpointReference appliesToEPR = appliesTo.getEndpointReference();
        if (appliesToEPR == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException e = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw e;
        }
        this.appliesTo = appliesToEPR.getAddress();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appliesTo: " + this.appliesTo);
        }
        IEndpointReference issuerEPR = requestSecurityToken.getIssuer();
        this.issuer = null;
        if (issuerEPR != null) {
            this.issuer = issuerEPR.getAddress();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "issuer: " + this.issuer);
        }
        this.targetMap = STSConfigUtil.getSTSTargetMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetMap: " + this.targetMap);
        }
        this.subject = (Subject)inMessage.getProperties().get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subject: " + this.subject);
        }
        this.securityTokenSet = null;
        if (this.subject != null) {
            this.securityTokenSet = this.subject.getPrivateCredentials(SecurityToken.class);
        }
        this.processTargetMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(request, inMessage)");
        }
    }

    private void processTargetMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTargetMap()");
        }
        boolean pass = false;
        boolean rule_exists = false;
        boolean found = false;
        try {
            List<Target> targetList = this.targetMap.getTarget();
            for (Target target : targetList) {
                block28: {
                    DefaultIssuerRule defaultIssuerRule;
                    block27: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  - processing target (" + target + ")");
                        }
                        String AppliesTo2 = target.getAppliesTo();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  comparing target.getAppliesTo (" + AppliesTo2 + ") to soap envelope's AppliesTo (" + this.appliesTo + ")");
                        }
                        if (STSUriUtil.URICompare(AppliesTo2, this.appliesTo.toString()) != 0) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  they are equivalent");
                        }
                        found = true;
                        defaultIssuerRule = target.getDefaultIssuerRule();
                        if (defaultIssuerRule != null) break block27;
                        if (!tc.isDebugEnabled()) break block28;
                        Tr.debug(tc, "NO JAAS config found for Issuer==null");
                        break block28;
                    }
                    List<TokenTypeRule> tokenTypeRuleList = defaultIssuerRule.getTokenTypeRule();
                    for (TokenTypeRule tokenTypeRule : tokenTypeRuleList) {
                        if (!this.identityRuleExists(tokenTypeRule, null)) continue;
                        rule_exists = true;
                        pass = this.processTokenTypeRule(tokenTypeRule, null);
                        if (!pass) continue;
                        break;
                    }
                }
                if (!pass) {
                    List<IssuerRule> issuerRuleList = target.getIssuerRule();
                    block4: for (IssuerRule issuerRule : issuerRuleList) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  - processing rule (" + issuerRule + ")");
                        }
                        String issuer = issuerRule.getIssuerURI();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "issuer: " + issuer + ".");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing issuer and this.issuer");
                        }
                        if (issuer != null && issuer.equals(this.issuer)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "issuer equals this.issuer");
                            }
                            List<TokenTypeRule> tokenTypeRuleList = issuerRule.getTokenTypeRule();
                            for (TokenTypeRule tokenTypeRule : tokenTypeRuleList) {
                                if (!this.identityRuleExists(tokenTypeRule, this.issuer)) continue;
                                rule_exists = true;
                                pass = this.processTokenTypeRule(tokenTypeRule, this.issuer);
                                if (!pass) continue;
                                break block4;
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "  issuer does NOT equal this.issuer");
                    }
                    if (!rule_exists) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  tokenTypeRuleList is empty, therefore there are no JAASConfig settings");
                            Tr.debug(tc, "  comparing " + this.appliesTo.toString() + " and " + this.to.toString());
                        }
                        boolean bl = pass = 0 == STSUriUtil.URICompare(this.appliesTo.toString(), this.to.toString());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  URICompare returned: " + pass);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Target element was found: breaking from targets iteration.");
                }
                break;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to process tokentype rules");
            }
            Tr.processException((Throwable)e, clsName + ".processTargetMap", "254", this);
        }
        if (!found) {
            boolean bl = pass = 0 == STSUriUtil.URICompare(this.appliesTo.toString(), this.to.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  target was not found: no rules exist for specified target.");
                Tr.debug(tc, "  comparing " + this.appliesTo.toString() + " and " + this.toString());
                Tr.debug(tc, "  URICompare returned: " + pass);
            }
        }
        if (!pass) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization failed in invokeSecurityLayer()");
            }
            SoapSecurityException e = SoapSecurityException.format(Constants.TRUST_FAULT_FAILED_AUTHENTICATION, "security.wssecurity.WSEC6851E");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTargetMap()");
        }
    }

    private boolean identityRuleExists(TokenTypeRule tokenTypeRule, URI issuer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "identityRuleExists(TokenTypeRule tokenTypeRule[" + tokenTypeRule + "], URI issuer[" + issuer + "])");
        }
        boolean pass = false;
        boolean rules_exist = false;
        try {
            pass = this.processToken(tokenTypeRule, issuer, null);
            if (!pass) {
                rules_exist = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to process token");
            }
            Tr.processException((Throwable)e, clsName + ".identityRuleExists", "297", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "identityRuleExists(TokenTypeRule tokenTypeRule, URI issuer) returns boolean[" + rules_exist + "]");
        }
        return rules_exist;
    }

    private boolean processTokenTypeRule(TokenTypeRule tokenTypeRule, URI issuer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTokenTypeRule(TokenTypeRule tokenTypeRule[" + tokenTypeRule + "], URI issuer[" + issuer + "])");
        }
        boolean pass = false;
        try {
            String tokenType = tokenTypeRule.getRequiredTokenTypeURI();
            for (SecurityToken token : this.securityTokenSet) {
                QName valueTypeQName = token.getValueType();
                String valueType = null;
                if (valueTypeQName != null) {
                    valueType = valueTypeQName.getLocalPart();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  comparing " + tokenType + " and " + valueType);
                }
                if (!tokenType.equals(valueType)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  they are equal");
                }
                if (!(pass = this.processToken(tokenTypeRule, issuer, token))) continue;
                break;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to process token*");
            }
            Tr.processException((Throwable)e, clsName + ".processTokenTypeRule", "337", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTokenTypeRule(TokenTypeRule tokenTypeRule, URI issuer) returns boolean[" + pass + "]");
        }
        return pass;
    }

    private boolean processToken(TokenTypeRule tokenTypeRule, URI issuer, SecurityToken token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processToken(TokenTypeRule tokenTypeRule[" + tokenTypeRule + "], URI issuer[" + issuer + "], SecurityToken token[" + token + "]");
        }
        boolean pass = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "calling tokenTypeRule.getCallbackHandler()");
        }
        try {
            String tokenType = tokenTypeRule.getRequiredTokenTypeURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenType: " + tokenType);
            }
            URI tokenTypeURI = null;
            if (tokenType != null) {
                tokenTypeURI = new URI(tokenType);
            }
            String callbackHandlerString = tokenTypeRule.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "callbackHandlerString: " + callbackHandlerString);
            }
            Class<?> callbackHandlerClass = Class.forName(callbackHandlerString);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "callbackHandlerClass: " + callbackHandlerClass);
            }
            CallbackHandler callbackHandler = (CallbackHandler)callbackHandlerClass.newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " calling STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass)");
            }
            if (STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass) returned true");
                }
                ((STSCallbackHandler)callbackHandler).setAppliesTo(this.appliesTo);
                ((STSCallbackHandler)callbackHandler).setIssuer(issuer);
                ((STSCallbackHandler)callbackHandler).setTokenType(tokenTypeURI);
                ((STSCallbackHandler)callbackHandler).setToken(token);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  STSCallbackHandler.class.isAssignableFrom(callbackHandlerClass) returned false");
            }
            String jaasConfigName = tokenTypeRule.getJAASConfigName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  jaasConfigName: " + jaasConfigName);
            }
            pass = this.processJAASConfig(jaasConfigName, callbackHandler);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to process JAAS config");
            }
            Tr.processException((Throwable)e, clsName + ".CheckToken", "402", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processToken(TokenTypeRule tokenTypeRule, URI issuer, SecurityToken token) returns boolean[" + pass + "] ");
        }
        return pass;
    }

    private boolean processJAASConfig(String jaasConfigName, CallbackHandler callbackHandler) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processJAASConfig(String jaasConfigName[" + jaasConfigName + "], CallbackHandler callbackHandler[" + callbackHandler + "])");
        }
        LoginContext lcontext = null;
        boolean pass = false;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "callbackHandler.getClass().getName(): " + callbackHandler.getClass().getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating LoginContext");
            }
            lcontext = new LoginContext(jaasConfigName, this.subject, callbackHandler);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeeded to construct the login context.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invoking LoginModules");
            }
            lcontext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSSecurityLayer JAAS login succeeded.");
            }
            pass = true;
        }
        catch (LoginException le) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSSecurityLayer JAAS login failed.");
            }
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, ".X509TokenConsumer.s02", (Throwable)le);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "logging out of context");
            }
            lcontext.logout();
        }
        catch (LoginException le) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSSecurityLayer JAAS logout failed.");
            }
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, ".X509TokenConsumer.s02", (Throwable)le);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processJAASConfig(String jaasConfigName, CallbackHandler callbackHandler) returns boolean[" + pass + "]");
        }
        return pass;
    }
}

