/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSResourceEvaluator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

public class STSPolicySetUtil {
    private static byte[] lock;
    private static TraceComponent tc;
    private static long defaultTimeout;
    private static long timeoutMinutes;
    private static HashMap<String, String> actionURIToActionMap;
    private static HashMap<String, PolicySetConfiguration> cache;
    private static final String FFDC_ID_1 = "FFDC-1";

    public static boolean isTrustRequest(MessageContext msgContext, String action) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrustRequest(MessageContext msgContext, String action)" + action);
        }
        boolean trustRequest = false;
        if (action == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "action is not included in message");
            }
        } else {
            AxisService axisService = msgContext.getAxisService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "msgContext.getAxisService(): " + axisService);
            }
            if (axisService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get AxisService");
                }
            } else {
                AxisOperation axisOperation = axisService.getOperationByAction(action);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "axisService.getOperationByAction(" + action + "): " + axisOperation);
                }
                if (axisOperation == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unable to get AxisOperation");
                    }
                } else {
                    QName operationName = axisOperation.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "axisOperation.getName(): " + operationName);
                    }
                    if (operationName == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unable to get AxisOperation Name");
                        }
                    } else {
                        String operation = operationName.getLocalPart();
                        if (operation != null && operation.startsWith("STSInOutOperation_")) {
                            trustRequest = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "operationName.getLocalPart().startsWith(com.ibm.ws.wssecurity.trust.server.sts.Util.Constants.TRUSTOPERATION_PREFIX) == " + trustRequest);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrustRequest(MessageContext msgContext, String action) returns boolean[" + trustRequest + "]");
        }
        return trustRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure() throws SoapSecurityException {
        STSConfigGroup messageReceiverConfigRoot;
        String method = "configure";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        STSConfigGroup stsConfigRoot = STSConfigUtil.getSTSConfigurationMap();
        long newTimeoutMinutes = defaultTimeout;
        HashMap<String, String> newActionURIToActionMap = new HashMap<String, String>();
        List<STSProperty> stsProperties = STSConfigUtil.getProperties(stsConfigRoot, new String[]{"TrustServiceProperties"});
        if (stsProperties != null) {
            for (STSProperty currentProp : stsProperties) {
                String propName = currentProp.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  Found property " + propName);
                }
                if (!propName.equals("policySetCacheTimeoutMinutes")) continue;
                newTimeoutMinutes = Integer.parseInt(currentProp.getValue());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Successfully configured policy set timeout cache to " + timeoutMinutes + " minutes.");
            }
        }
        List<STSProperty> searchSchemasProps = STSConfigUtil.getProperties(stsConfigRoot, new String[]{"PolicySet", "Schemas"});
        HashSet<String> searchSchemas = new HashSet<String>();
        if (searchSchemasProps != null) {
            Iterator<STSProperty> searchSchemasIter = searchSchemasProps.iterator();
            while (searchSchemasIter.hasNext()) {
                String schema = searchSchemasIter.next().getValue();
                searchSchemas.add(schema);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Search schema: " + schema);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not extract properties from PolicySet/Schemas configuration group.");
        }
        if ((messageReceiverConfigRoot = STSConfigUtil.getConfiguration(stsConfigRoot, new String[]{"MessageReceiver"})) != null) {
            List<STSConfigGroup> messageReceiverActionGroups = messageReceiverConfigRoot.getSTSConfigGroup();
            Iterator<STSConfigGroup> groupIter = messageReceiverActionGroups.iterator();
            while (groupIter.hasNext()) {
                List<STSProperty> actions;
                String schema = groupIter.next().getName();
                if (!searchSchemas.contains(schema)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Searching through MessageReceiver|" + schema + "|Action configuration group for action properties.");
                }
                if ((actions = STSConfigUtil.getProperties(messageReceiverConfigRoot, new String[]{schema, "Action"})) != null) {
                    for (STSProperty currentAction : actions) {
                        String uri = currentAction.getValue();
                        String actionType = currentAction.getName();
                        newActionURIToActionMap.put(uri, actionType);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Learned mapping from " + uri + " to " + actionType);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not extract action properties.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not extract MessageReceiver configuration group.");
        }
        timeoutMinutes = newTimeoutMinutes;
        actionURIToActionMap = newActionURIToActionMap;
        byte[] byArray = lock;
        synchronized (lock) {
            cache.clear();
            // ** MonitorExit[var9_8] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
    }

    public static String mapTrustAction(String actionURI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapTrustAction(String:" + actionURI + ")");
        }
        String action = null;
        if (actionURI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "actionURI == null");
            }
        } else {
            action = actionURIToActionMap.get(actionURI);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapTrustAction returns String:action: " + action);
        }
        return action;
    }

    public static String getTrustResourceString(String action, String endpoint) {
        return new String("Trust." + action + ":/" + endpoint);
    }

    public static PolicySetConfiguration getTrustPolicySetConfiguration(MessageContext msgContext, String action, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustPolicySetConfiguration(MessageContext msgContext, action[String:" + action + "] Classloader classLoader)");
        }
        String endpoint = null;
        PolicySetConfiguration psc = null;
        try {
            EndpointReference endpointReferenceTo = null;
            endpointReferenceTo = msgContext.getTo();
            if (endpointReferenceTo != null) {
                endpoint = endpointReferenceTo.getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endpoint = " + endpoint);
            }
        }
        catch (Exception e) {
            Tr.processException(e, "security.wssecurity.WSSecurityConsumerHandler.s04", "368");
            throw new SoapSecurityException("security.wssecurity.WSSecurityConsumerHandler.s04");
        }
        psc = STSPolicySetUtil.getTrustPolicySetConfiguration(action, endpoint, classLoader);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustPolicySetConfiguration() returns psc");
        }
        return psc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PolicySetConfiguration getTrustPolicySetConfiguration(String action, String endpoint, ClassLoader classLoader) throws SoapSecurityException {
        PolicySetConfiguration psc;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTrustPolicySetConfiguration(action[String:" + action + "], endpoint[String:" + endpoint + "], ClassLoader classLoader)");
            }
            psc = null;
            String reference = STSPolicySetUtil.getTrustResourceString(action, endpoint);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reference = " + reference);
            }
            byte[] byArray = lock;
            // MONITORENTER : lock
            psc = cache.get(reference);
            // MONITOREXIT : byArray
            try {
                if (psc != null) break block14;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reference [String:" + reference + "] not found in cache");
                    Tr.debug(tc, "calling PolicySetUtil.getInstance(classLoader.getSystemClassLoader()");
                }
                PolicySetUtil util2 = PolicySetUtil.getInstance(classLoader.getSystemClassLoader());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[PolicySetUtil:util] == " + util2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling util.getSystemAttachments(new String(system/trust))");
                }
                PolicySetAttachments psa = util2.getSystemAttachments(new String("system/trust"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[PolicySetAttachments:psa] == " + psa);
                }
                if ((psc = psa.getPolicySet(reference, new STSResourceEvaluator(), classLoader.getSystemClassLoader(), classLoader.getSystemClassLoader())) != null) {
                    byte[] byArray2 = lock;
                    // MONITORENTER : lock
                    cache.put(reference, psc);
                    // MONITOREXIT : byArray2
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating an alarm to remove policy set " + reference + " in " + timeoutMinutes + " minutes");
                    }
                    AlarmManager.createDeferrable(timeoutMinutes * 60L * 1000L, new AlarmListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void alarm(Object alarmContext) {
                            String reference = (String)alarmContext;
                            byte[] byArray = lock;
                            synchronized (byArray) {
                                cache.remove(reference);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Policy set " + reference + " removed from the cache.");
                            }
                        }
                    }, reference);
                }
            }
            catch (Exception e) {
                Tr.processException(e, "security.wssecurity.WSSecurityConsumerHandler.s04", "368");
                throw new SoapSecurityException("security.wssecurity.WSSecurityConsumerHandler.s04");
            }
        }
        if (!tc.isEntryEnabled()) return psc;
        Tr.exit(tc, "getTrustPolicySetConfiguration() returns psc");
        return psc;
    }

    private static void initialize() {
        tc = Tr.register(STSPolicySetUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        lock = new byte[0];
        timeoutMinutes = defaultTimeout = 120L;
        actionURIToActionMap = new HashMap();
        cache = new HashMap();
        try {
            STSPolicySetUtil.configure();
        }
        catch (SoapSecurityException ex) {
            FFDCFilter.processException(ex, "STSPolicySetUtil.initialize", FFDC_ID_1);
            Tr.error(tc, "security.wssecurity.config.s01");
        }
    }

    static {
        STSPolicySetUtil.initialize();
    }
}

