/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.server.sts.Util;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSConfigurationMapLoader;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSExtensionMapLoader;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSTargetMapLoader;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.higgins.sts.impl.AppliesToMapping;
import org.eclipse.higgins.sts.impl.ExtensionMappingKey;
import org.eclipse.higgins.sts.server.impl.SecurityTokenService;
import org.eclipse.higgins.sts.server.impl.SecurityTokenServiceFactory;
import org.eclipse.higgins.sts.utilities.ObjectFactoryHelper;

public class STSConfigUtil {
    private static final String comp = "security.wssecurity";
    private static boolean bInitialized = false;
    private static HashMap actionStringsMap = new HashMap();
    private static final String CLASS_NAME = STSConfigUtil.class.getName();
    private static final TraceComponent tc;
    private static final STSConfigUtil singleton;
    private static SecurityTokenService securityTokenServiceSingleton;
    private static STSExtensionMap stsPluginMap;
    private static STSTargetMap stsTargetMap;
    private static STSConfigGroup stsConfigMap;

    public boolean loadSTSConfiguration() throws SoapSecurityException {
        String method = "loadSTSConfiguration";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        boolean success = false;
        STSConfigUtil stsConfigUtil = STSConfigUtil.getSingletonInstance();
        if (stsConfigUtil != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling STSConfigUtil.getSecurityTokenServiceSingletonInstance()");
            }
            try {
                SecurityTokenService securityTokenService = STSConfigUtil.getSecurityTokenServiceSingletonInstance(true);
                if (securityTokenService != null) {
                    success = true;
                }
            }
            catch (SoapSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error loading STSConfiguration: " + e.getLocalizedMessage());
                }
                FFDCFilter.processException(e, CLASS_NAME + ".getSecurityTokenServiceSingletonInstance", "53");
                success = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return success;
    }

    public static STSConfigUtil getSingletonInstance() {
        return singleton;
    }

    public static void initializeSecurityTokenService(SecurityTokenService SecurityTokenService2) throws SoapSecurityException {
        STSExtensionMap stsPluginMap;
        String method = "initializeSecurityTokenService(ISecurityTokenService SecurityTokenService)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if ((stsPluginMap = STSConfigUtil.loadSTSExtensionMap()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stsplugins.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s02");
        }
        STSTargetMap stsTargetMap = STSConfigUtil.loadSTSTargetMap();
        if (stsTargetMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ststargets.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s03");
        }
        STSConfigGroup stsConfigMap = STSConfigUtil.loadSTSConfigurationMap();
        if (stsConfigMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stsconfig.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s01");
        }
        HashMap<URI, AppliesToMapping> mapAppliesTo2ATM = new HashMap<URI, AppliesToMapping>();
        HashMap<ExtensionMappingKey, String> mapExtensionMappingKey2Configuration = new HashMap<ExtensionMappingKey, String>();
        HashMap<String, String> mapConfiguration2FactoryClassName = new HashMap<String, String>();
        HashMap<String, Properties> mapConfiguration2Properties = new HashMap<String, Properties>();
        Vector<ExtensionMappingKey> defaultEMKs = new Vector<ExtensionMappingKey>();
        HashMap<String, String> defaultRequestTypes = new HashMap<String, String>();
        STSConfigUtil.populateActionStringsMap(stsConfigMap);
        STSConfigGroup defaultRoot = STSConfigUtil.getConfiguration(stsConfigMap, new String[]{"STSMapping", "Default"});
        if (defaultRoot == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Path STSMapping|Default not found in generic STS configuration file.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s01");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building default EMKs...");
        }
        List<STSConfigGroup> defaultMappings = defaultRoot.getSTSConfigGroup();
        for (STSConfigGroup current : defaultMappings) {
            List<STSProperty> keys = current.getSTSProperty();
            Iterator<STSProperty> keysIter = keys.iterator();
            URI action = null;
            URI tokenType = null;
            URI requestType = null;
            URI issuer = null;
            while (keysIter.hasNext()) {
                STSProperty key = keysIter.next();
                String keyName = key.getName();
                String keyType = key.getType();
                if (keyType == null || !keyType.equals("EMK")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expecting Type=\"EMK\". Actual type=" + keyType);
                    }
                    throw SoapSecurityException.format("security.wssecurity.config.s01");
                }
                if (keyName.equals("Action")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Action: " + key.getValue());
                    }
                    action = STSConfigUtil.extractURIFromValue(key, stsConfigMap);
                    continue;
                }
                if (keyName.equals("TokenType")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found TokenType: " + key.getValue());
                    }
                    tokenType = STSConfigUtil.extractURIFromValue(key, stsConfigMap);
                    continue;
                }
                if (keyName.equals("RequestType")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found RequestType: " + key.getValue());
                    }
                    requestType = STSConfigUtil.extractURIFromValue(key, stsConfigMap);
                    continue;
                }
                if (keyName.equals("Issuer")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Issuer: " + key.getValue());
                    }
                    issuer = STSConfigUtil.extractURIFromValue(key, stsConfigMap);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key name not recognized: " + keyName);
                }
                throw SoapSecurityException.format("security.wssecurity.config.s01");
            }
            if (action == null && tokenType == null && requestType == null && issuer == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Specified key is not valid. At least one of Action, TokenType, RequestType or Issuer must be present.");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s01");
            }
            defaultEMKs.add(new ExtensionMappingKey(action, tokenType, requestType, issuer));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Default EMK added - {action: " + action + " tokenType: " + tokenType + " requestType: " + requestType + " issuer: " + issuer + "}.");
        }
        STSConfigGroup defaultRequestTypesRoot = STSConfigUtil.getConfiguration(stsConfigMap, new String[]{"MessageReceiver", "http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestType"});
        if (defaultRequestTypesRoot == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Path MessageReceiver|http://schemas.xmlsoap.org/ws/2005/02/trust|RequestType was not found in generic STS configuration file.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s01");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Extracting default request types...");
        }
        List<STSProperty> defaultRequestTypeProps = defaultRequestTypesRoot.getSTSProperty();
        for (STSProperty current : defaultRequestTypeProps) {
            String key = "RequestType_" + current.getName();
            if (current.getName() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestType cannot be null");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s01");
            }
            String value = current.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  Found request type: " + key + " = " + value);
            }
            if (value == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RequestType value cannot be null");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s01");
            }
            defaultRequestTypes.put(key, value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Finished Building default EMKs...");
        }
        ArrayList extensionList = (ArrayList)stsPluginMap.getExtension();
        for (int i = 0; i < extensionList.size(); ++i) {
            STSConfigGroup requestTypesRoot;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  - processing extension (" + i + ")");
            }
            Extension extension = (Extension)extensionList.get(i);
            String STSTokenTypeURI = extension.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenTypeURI:  " + STSTokenTypeURI);
            }
            if (STSTokenTypeURI == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to retrieve the configured TokenType URI of the STS token provider (Plugin)");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s02");
            }
            String STSConfigName = extension.getLocalName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigName:  " + STSConfigName);
            }
            if (STSConfigName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to retrieve the configuration name of the STS token provider (Plugin)");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s02");
            }
            String STSHandlerFactory = extension.getHandlerFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HandlerFactory:  " + STSHandlerFactory);
            }
            if (STSHandlerFactory == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to retrieve the configured HandlerFactory of the STS token provider (Plugin)");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s02");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapConfiguration2FactoryClassName.put(" + STSConfigName + ", " + STSHandlerFactory + ")");
            }
            mapConfiguration2FactoryClassName.put(STSConfigName, STSHandlerFactory);
            Configuration config2 = extension.getConfiguration();
            ArrayList propertyList = (ArrayList)config2.getProperty();
            Properties STSProperties = new Properties();
            for (int j = 0; j < propertyList.size(); ++j) {
                Property prop = (Property)propertyList.get(j);
                String name = prop.getName();
                String value = prop.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  - found property (" + i + ") (" + name + ", " + value + ")");
                }
                if (name == null || value == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Neither STS token provider (Plugin) property name nor its value can be null");
                    }
                    throw SoapSecurityException.format("security.wssecurity.config.s02");
                }
                STSProperties.setProperty(name, value);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapConfiguration2Properties.put(" + STSConfigName + ", STSProperties" + ")");
            }
            mapConfiguration2Properties.put(STSConfigName, STSProperties);
            boolean useDefaults = true;
            STSConfigGroup pluginRoot = STSConfigUtil.getConfiguration(stsConfigMap, new String[]{"STSMapping", STSConfigName});
            if (pluginRoot == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Path STSMapping|" + STSConfigName + " not found in generic STS configuration file.  Will attempt to use defaults.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Building new EMKs for " + STSConfigName + "...");
                }
                useDefaults = false;
                List<STSConfigGroup> mappings = pluginRoot.getSTSConfigGroup();
                for (STSConfigGroup current : mappings) {
                    List<STSProperty> keys = current.getSTSProperty();
                    Iterator<STSProperty> keysIter = keys.iterator();
                    URI action = null;
                    URI tokenType = null;
                    URI requestType = null;
                    URI issuer = null;
                    while (keysIter.hasNext()) {
                        STSProperty key = keysIter.next();
                        String keyName = key.getName();
                        String keyType = key.getType();
                        if (keyType == null || !keyType.equals("EMK")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Expecting Type=\"EMK\". Actual type=" + keyType);
                            }
                            throw SoapSecurityException.format("security.wssecurity.config.s01");
                        }
                        if (keyName.equals("Action")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Action: " + key.getValue());
                            }
                            action = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue(key, stsConfigMap), extension);
                            continue;
                        }
                        if (keyName.equals("TokenType")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found TokenType: " + key.getValue());
                            }
                            tokenType = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue(key, stsConfigMap), extension);
                            continue;
                        }
                        if (keyName.equals("RequestType")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found RequestType: " + key.getValue());
                            }
                            requestType = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue(key, stsConfigMap), extension);
                            continue;
                        }
                        if (keyName.equals("Issuer")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found Issuer: " + key.getValue());
                            }
                            issuer = STSConfigUtil.resolveURI(STSConfigUtil.extractURIFromValue(key, stsConfigMap), extension);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Key name not recognized: " + keyName);
                        }
                        throw SoapSecurityException.format("security.wssecurity.config.s01");
                    }
                    if (action == null && tokenType == null && requestType == null && issuer == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Specified key is not valid. At least one of Action, TokenType, RequestType or Issuer must be present.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.config.s01");
                    }
                    ExtensionMappingKey newEMK = new ExtensionMappingKey(action, tokenType, requestType, issuer);
                    mapExtensionMappingKey2Configuration.put(newEMK, STSConfigName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "New EMK added - {action: " + action + " tokenType: " + tokenType + " requestType: " + requestType + " issuer: " + issuer + "}.");
                }
            }
            if (useDefaults) {
                if (defaultEMKs.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default mappings are not available. No mappings for this token type will be created.");
                    }
                    throw SoapSecurityException.format("security.wssecurity.config.s01");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default mappings are available. These will be used to create mappings for this token type.");
                }
                for (ExtensionMappingKey currentEMK : defaultEMKs) {
                    URI action = STSConfigUtil.resolveURI(currentEMK.getAction(), extension);
                    URI tokenType = STSConfigUtil.resolveURI(currentEMK.getTokenType(), extension);
                    URI requestType = STSConfigUtil.resolveURI(currentEMK.getRequestType(), extension);
                    URI issuer = STSConfigUtil.resolveURI(currentEMK.getIssuer(), extension);
                    if (action == null && tokenType == null && requestType == null && issuer == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Specified key is not valid. At least one of Action, TokenType, RequestType or Issuer must be present.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.config.s01");
                    }
                    ExtensionMappingKey newEMK = new ExtensionMappingKey(action, tokenType, requestType, issuer);
                    mapExtensionMappingKey2Configuration.put(newEMK, STSConfigName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "New EMK added - {action: " + action + " tokenType: " + tokenType + " requestType: " + requestType + " issuer: " + issuer + "}.");
                }
            }
            if ((requestTypesRoot = STSConfigUtil.getConfiguration(stsConfigMap, new String[]{"MessageReceiver", STSTokenTypeURI, "RequestType"})) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Path MessageReceiver|" + STSTokenTypeURI + "|" + "RequestType" + " was not found in generic STS configuration file.");
                    Tr.debug(tc, "Using default request type URIs...");
                }
                if (defaultRequestTypes.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default request types are not available. No request type URIs will be passed to the plugin configuration.");
                    }
                    throw SoapSecurityException.format("security.wssecurity.config.s01");
                }
                Set keys = defaultRequestTypes.keySet();
                Iterator keysIter = keys.iterator();
                while (keysIter.hasNext()) {
                    String currentKey = new String((String)keysIter.next());
                    String currentValue = new String((String)defaultRequestTypes.get(currentKey));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "  Adding: [" + currentKey + " : " + currentValue + "] to the plugin configuration.");
                    }
                    STSProperties.put(currentKey, currentValue);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extracting specific request types...");
                }
                List<STSProperty> requestTypeProps = requestTypesRoot.getSTSProperty();
                for (STSProperty current : requestTypeProps) {
                    String key = "RequestType_" + current.getName();
                    String value = current.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "  Adding: [" + key + " : " + value + "] to the plugin configuration.");
                    }
                    STSProperties.put(key, value);
                }
            }
            String supportAltTokenType = "false";
            if (STSProperties.containsKey("com.ibm.wsspi.wssecurity.trust.supportWSTrust10Draft")) {
                supportAltTokenType = (String)STSProperties.get("com.ibm.wsspi.wssecurity.trust.supportWSTrust10Draft");
            }
            if (!supportAltTokenType.equalsIgnoreCase("true")) continue;
            STSConfigGroup requestTypesRootAlt = STSConfigUtil.getConfiguration(stsConfigMap, new String[]{"MessageReceiver", "http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestType"});
            if (requestTypesRootAlt == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Path MessageReceiver|" + STSTokenTypeURI + "|" + "RequestType" + " was not found in generic STS configuration file.");
                Tr.debug(tc, "Using default request type URIs...");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting specific request types...");
            }
            List<STSProperty> requestTypeProps = requestTypesRootAlt.getSTSProperty();
            for (STSProperty current : requestTypeProps) {
                String key = "RequestType_" + current.getName() + "_alt";
                String value = current.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  Adding: [" + key + " : " + value + "] to the plugin configuration.");
                }
                STSProperties.put(key, value);
            }
        }
        URI sct10DraftTokenType = null;
        URI sct13TokenType = null;
        URI sctRequestGetToken = null;
        URI sctRequestPutToken = null;
        try {
            sct10DraftTokenType = new URI("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            sct13TokenType = new URI("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct");
            sctRequestGetToken = new URI("http://w3.ibm.com/ws/2005/02/trust/getToken");
            sctRequestPutToken = new URI("http://w3.ibm.com/ws/2005/02/trust/putToken");
        }
        catch (URISyntaxException e) {
            FFDCFilter.processException(e, CLASS_NAME, "331");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Syntax problem for getToken/putToken URIs. " + e.getLocalizedMessage());
            }
            throw SoapSecurityException.format("security.wssecurity.config.s04", e);
        }
        mapExtensionMappingKey2Configuration.put(new ExtensionMappingKey(null, sct10DraftTokenType, sctRequestGetToken, null), "Security Context Token");
        mapExtensionMappingKey2Configuration.put(new ExtensionMappingKey(null, sct10DraftTokenType, sctRequestPutToken, null), "Security Context Token");
        mapExtensionMappingKey2Configuration.put(new ExtensionMappingKey(null, sct13TokenType, sctRequestGetToken, null), "Security Context Token");
        mapExtensionMappingKey2Configuration.put(new ExtensionMappingKey(null, sct13TokenType, sctRequestPutToken, null), "Security Context Token");
        ArrayList targetList = (ArrayList)stsTargetMap.getTarget();
        for (int i = 0; i < targetList.size(); ++i) {
            Target target;
            String STSAppliesToString;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  - processing target (" + i + ")");
            }
            if ((STSAppliesToString = (target = (Target)targetList.get(i)).getAppliesTo()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppliesTo string cannot be null");
                }
                throw SoapSecurityException.format("security.wssecurity.config.s03");
            }
            URI STSAppliesTo = null;
            try {
                STSAppliesTo = new URI(STSAppliesToString);
            }
            catch (URISyntaxException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Syntax problem with URIs. This element will not be added to the STS mapping. " + e.getLocalizedMessage());
                }
                throw SoapSecurityException.format("security.wssecurity.config.s03", e);
            }
            List<AssignedTokenType> assignedTokenTypes = target.getAssignedTokenType();
            for (AssignedTokenType currentAssignedTT : assignedTokenTypes) {
                String currentTTURI = currentAssignedTT.getTokenTypeURI();
                String currentIssuerURI = currentAssignedTT.getIssuerURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For endpoint " + STSAppliesToString + ":");
                    Tr.debug(tc, "  TokenTypeURI: " + currentTTURI);
                    Tr.debug(tc, "  IssuerURI: " + currentIssuerURI);
                }
                URI ttURI = null;
                URI issuerURI = null;
                try {
                    if (currentTTURI == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TokenTypeURI is a required attribute and was found to be null. This element will not be added to the STS mapping.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.config.s03");
                    }
                    ttURI = new URI(currentTTURI);
                    if (currentIssuerURI != null) {
                        issuerURI = new URI(currentIssuerURI);
                    }
                }
                catch (URISyntaxException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Syntax problem with URIs. This element will not be added to the STS mapping. " + e.getLocalizedMessage());
                    }
                    throw SoapSecurityException.format("security.wssecurity.config.s03", e);
                }
                if (STSAppliesTo == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Target AppliesTo cannot be null");
                    }
                    throw SoapSecurityException.format("security.wssecurity.config.s03");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding mapping from " + STSAppliesToString + " to (" + currentTTURI + ", " + currentIssuerURI + ") to mapAppliesTo2ATM.");
                }
                mapAppliesTo2ATM.put(STSAppliesTo, new AppliesToMapping(ttURI, issuerURI));
            }
        }
        URI defaultTokenType = null;
        try {
            defaultTokenType = new URI(stsTargetMap.getDefaultTokenTypeURI());
        }
        catch (URISyntaxException e) {
            FFDCFilter.processException(e, CLASS_NAME, "456");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem with default token type URI syntax. " + e.getLocalizedMessage());
            }
            throw SoapSecurityException.format("security.wssecurity.config.s03", e);
        }
        try {
            mapAppliesTo2ATM.put(new URI("*"), new AppliesToMapping(defaultTokenType, null));
        }
        catch (URISyntaxException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Syntax problem with \"*\". This element will not be added to the STS mapping. " + e.getLocalizedMessage());
            }
            throw SoapSecurityException.format("security.wssecurity.config.s03", e);
        }
        try {
            SecurityTokenService2.configure(mapAppliesTo2ATM, mapExtensionMappingKey2Configuration, mapConfiguration2FactoryClassName, mapConfiguration2Properties);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught while configuring STS" + e.getLocalizedMessage());
            }
            throw SoapSecurityException.format("security.wssecurity.config.s09", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    public static synchronized SecurityTokenService getSecurityTokenServiceSingletonInstance(boolean reload) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityTokenServiceSingletonInstance()");
        }
        SecurityTokenService newSecurityTokenService = null;
        if (securityTokenServiceSingleton == null || reload) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting new instance of SecurityTokenService");
            }
            String SecurityTokenServiceFactoryClass = SecurityTokenServiceFactory.class.getName();
            try {
                newSecurityTokenService = (SecurityTokenService)ObjectFactoryHelper.getNewInstanceFromFactory(SecurityTokenServiceFactoryClass);
            }
            catch (Exception e) {
                SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.config.s07");
                sse.initCause(e);
                throw sse;
            }
            if (null == newSecurityTokenService) {
                throw SoapSecurityException.format("security.wssecurity.config.s07");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded: " + SecurityTokenServiceFactoryClass);
                Tr.debug(tc, "about to call initializeSecurityTokenService()");
            }
            STSConfigUtil.initializeSecurityTokenService(newSecurityTokenService);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "finished calling initializeSecurityTokenService()");
            }
            securityTokenServiceSingleton = newSecurityTokenService;
            if (reload) {
                STSPolicySetUtil.configure();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityTokenServiceSingletonInstance()");
        }
        return securityTokenServiceSingleton;
    }

    private static STSConfigGroup loadSTSConfigurationMap() throws SoapSecurityException {
        stsConfigMap = null;
        STSConfigurationMapLoader configMapLoader = (STSConfigurationMapLoader)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.stsConfigurationMapLoader");
        if (configMapLoader != null && (stsConfigMap = configMapLoader.loadSTSConfigurationMap()) != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Generic STS configuration successfully loaded.");
        }
        if (stsConfigMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSTSConfigurationMap, stsconfig.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s01");
        }
        return stsConfigMap;
    }

    private static STSExtensionMap loadSTSExtensionMap() throws SoapSecurityException {
        stsPluginMap = null;
        STSExtensionMapLoader extensionMapLoader = (STSExtensionMapLoader)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.stsExtensionMapLoader");
        if (extensionMapLoader != null && (stsPluginMap = extensionMapLoader.loadSTSExtensionMap()) != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Extensions configuration successfully loaded.");
        }
        if (stsPluginMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSTSExtensionMap, stsplugins.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s02");
        }
        return stsPluginMap;
    }

    private static STSTargetMap loadSTSTargetMap() throws SoapSecurityException {
        stsTargetMap = null;
        STSTargetMapLoader targetMapLoader = (STSTargetMapLoader)WSSecurityFactoryBuilder.getInstance("com.ibm.ws.wssecurity.platform.stsTargetMapLoader");
        if (targetMapLoader != null && (stsTargetMap = targetMapLoader.loadSTSTargetMap()) != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Targets configuration successfully loaded.");
        }
        if (stsTargetMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSTSTargetMap, ststargets.xml was not successfully parsed.");
            }
            throw SoapSecurityException.format("security.wssecurity.config.s03");
        }
        return stsTargetMap;
    }

    public static STSConfigGroup getSTSConfigurationMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSTSConfigurationMap");
        }
        if (stsConfigMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSTSConfigurationMap, stsConfigMap is null and need to load it");
            }
            stsConfigMap = STSConfigUtil.loadSTSConfigurationMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSTSConfigurationMap");
        }
        return stsConfigMap;
    }

    public static STSExtensionMap getSTSExtensionMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSTSExtensionMap");
        }
        if (stsPluginMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSTSExtensionMap, stsPluginMap is null and need to load it");
            }
            stsPluginMap = STSConfigUtil.loadSTSExtensionMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSTSExtensionMap");
        }
        return stsPluginMap;
    }

    public static STSTargetMap getSTSTargetMap() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSTSTargetMap");
        }
        if (stsTargetMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSTSTargetMap, stsTargetMap is null and need to load it");
            }
            stsTargetMap = STSConfigUtil.loadSTSTargetMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSTSTargetMap");
        }
        return stsTargetMap;
    }

    public static STSConfigGroup getConfiguration(STSConfigGroup root, String[] namePath) {
        if (root == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Root element is null.");
            }
            return null;
        }
        for (String name : namePath) {
            List<STSConfigGroup> configs = root.getSTSConfigGroup();
            Iterator<STSConfigGroup> iter = configs.iterator();
            root = null;
            while (iter.hasNext()) {
                STSConfigGroup current = iter.next();
                if (!current.getName().equals(name)) continue;
                root = current;
                break;
            }
            if (root != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, name + " was not found in the configuration path.");
            }
            return null;
        }
        return root;
    }

    public static List<STSProperty> getProperties(STSConfigGroup root, String[] namePath) {
        STSConfigGroup config2 = STSConfigUtil.getConfiguration(root, namePath);
        if (config2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getProperties could not find the specified STSConfigGroup.");
            }
            return null;
        }
        return config2.getSTSProperty();
    }

    public static String mapActionRST2ActionRSTR(String actionRST) {
        return (String)actionStringsMap.get(actionRST);
    }

    private static URI extractURIFromValue(STSProperty property, STSConfigGroup configRoot) {
        URI value;
        String method;
        block24: {
            method = "extractURIFromValue";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, method);
            }
            if (property == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the STSProperty passed in is null.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return null;
            }
            value = null;
            String uriString = null;
            String valueString = property.getValue();
            if (valueString.startsWith("#")) {
                valueString = valueString.substring("#".length());
                String[] fullPath = valueString.split("\\|");
                String[] path = new String[fullPath.length - 1];
                System.arraycopy(fullPath, 0, path, 0, path.length);
                List<STSProperty> propsInPath = STSConfigUtil.getProperties(configRoot, path);
                if (propsInPath == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Path " + valueString + " was not found in the configuration.");
                    }
                } else {
                    String fullKey = fullPath[fullPath.length - 1];
                    int separatorIndex = fullKey.indexOf(",");
                    String nameKey = null;
                    String typeKey = null;
                    if (separatorIndex == -1) {
                        nameKey = fullKey;
                    } else {
                        nameKey = fullKey.substring(0, separatorIndex);
                        typeKey = fullKey.substring(separatorIndex + 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nameKey: " + nameKey + " typeKey: " + typeKey);
                    }
                    for (STSProperty currentProp : propsInPath) {
                        String propName = currentProp.getName();
                        String propType = currentProp.getType();
                        String propValue = currentProp.getValue();
                        if (typeKey == null) {
                            if (!propName.equals(nameKey)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found a match: {name: " + propName + " type: " + propType + " value: " + propValue + "}");
                            }
                            uriString = propValue;
                        } else {
                            if (!propName.equals(nameKey) || propType == null || !propType.equals(typeKey)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found a match: {name: " + propName + " type: " + propType + " value: " + propValue + "}");
                            }
                            uriString = propValue;
                        }
                        break;
                    }
                }
            } else {
                uriString = valueString;
            }
            if (uriString == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not extract the URI from value " + valueString);
                }
            } else {
                try {
                    value = new URI(uriString);
                }
                catch (URISyntaxException e) {
                    FFDCFilter.processException(e, CLASS_NAME, "569");
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, "Value does not correspond to a valid URI. " + e.getLocalizedMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return value;
    }

    private static URI resolveURI(URI uri, Extension context) {
        URI resolved;
        String method;
        block17: {
            method = "resolveURI";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, method);
            }
            if (uri == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Input URI is null.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return null;
            }
            String uriString = uri.toString();
            if (!uriString.startsWith("$")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Input URI does not need to be resolved. " + uri);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return uri;
            }
            resolved = null;
            String accessorName = "get" + uriString.substring("$".length());
            String resolvedString = null;
            try {
                Method accessor = context.getClass().getMethod(accessorName, new Class[0]);
                resolvedString = (String)accessor.invoke((Object)context, (Object[])null);
                resolved = new URI(resolvedString);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resolved URI: " + resolved);
                }
            }
            catch (SecurityException e) {
                FFDCFilter.processException(e, CLASS_NAME, "625");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Specified URI " + uriString + " was not successfully resolved. " + e.getLocalizedMessage());
                }
            }
            catch (NoSuchMethodException e) {
                FFDCFilter.processException(e, CLASS_NAME, "628");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Specified URI " + uriString + " was not successfully resolved. No accessor method called " + accessorName + " in " + Extension.class.getName() + ". " + e.getLocalizedMessage());
                }
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException(e, CLASS_NAME, "633");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resolved URI " + resolvedString + " is not a valid URI. " + e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASS_NAME, "636");
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "Specified URI " + uriString + " was not successfully resolved. " + e.getLocalizedMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return resolved;
    }

    private static void populateActionStringsMap(STSConfigGroup configRoot) throws SoapSecurityException {
        String method = "populateActionStringsMap";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing actionStringsMap.");
        }
        actionStringsMap.clear();
        List<STSProperty> schemaProps = STSConfigUtil.getProperties(configRoot, new String[]{"PolicySet", "Schemas"});
        if (schemaProps != null) {
            Iterator<STSProperty> schemasIter = schemaProps.iterator();
            while (schemasIter.hasNext()) {
                List<STSProperty> actionProps;
                HashMap<String, String> op2rstMap = new HashMap<String, String>();
                STSProperty current = schemasIter.next();
                String schema = current.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  Found schema: " + schema);
                }
                if ((actionProps = STSConfigUtil.getProperties(configRoot, new String[]{"MessageReceiver", schema, "Action"})) != null) {
                    String actionValue;
                    String actionType;
                    String actionName;
                    for (STSProperty currentAction : actionProps) {
                        actionName = currentAction.getName();
                        actionType = currentAction.getType();
                        actionValue = currentAction.getValue();
                        if (actionName == null || actionType == null || actionValue == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "      Action property should have a name, type and value. Skipping.");
                            }
                            throw SoapSecurityException.format("security.wssecurity.config.s01");
                        }
                        if (!actionType.equals("RST")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "    Found action - " + actionName + " " + actionType + " " + actionValue);
                        }
                        op2rstMap.put(actionName, actionValue);
                    }
                    for (STSProperty currentAction : actionProps) {
                        String rstString;
                        actionName = currentAction.getName();
                        actionType = currentAction.getType();
                        actionValue = currentAction.getValue();
                        if (actionName == null || actionType == null || actionValue == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "      Action property should have a name, type and value. Skipping.");
                            }
                            throw SoapSecurityException.format("security.wssecurity.config.s01");
                        }
                        if (!actionType.equals("RSTR")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "    Found action - " + actionName + " " + actionType + " " + actionValue);
                        }
                        if ((rstString = (String)op2rstMap.get(actionName)) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating entry: " + rstString + " -> " + actionValue);
                            }
                            actionStringsMap.put(rstString, actionValue);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "      RSTR does not have matching RST. Skipping.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.config.s01");
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Actions were not found for schema " + schema + ". Skipping.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Schemas were not found in stsconfig.xml. Could not populate actionStringsMap.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }

    static {
        securityTokenServiceSingleton = null;
        stsPluginMap = null;
        stsTargetMap = null;
        stsConfigMap = null;
        tc = Tr.register(STSConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        singleton = new STSConfigUtil();
    }
}

