/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.v13;

import com.ibm.ws.wssecurity.trust.ext.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustClient;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13Formatter;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13Properties;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13RequestSecurityToken;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13RequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13RequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.List;

public class Trust13Client
extends TrustClient
implements ITrustClient {
    private static final TraceComponent tc = Tr.register(Trust13Client.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static Trust13Client trust13Client = null;
    private static Trust13Properties trustProperties = null;

    public static Trust13Client getInstance() {
        if (trust13Client == null) {
            trust13Client = new Trust13Client();
        }
        return trust13Client;
    }

    private Trust13Client() {
        trustProperties = new Trust13Properties();
    }

    @Override
    public TrustProperties getTrustProperties() {
        return trustProperties;
    }

    @Override
    public ITrustRequestSecurityTokenTemplate getRequestSecurityTokenTemplate(ITrustRequesterConfig request) throws SoapSecurityException {
        Trust13Formatter formatter = new Trust13Formatter(trustProperties);
        return new Trust13RequestSecurityTokenTemplate(trustProperties, request, formatter);
    }

    @Override
    public ITrustRequestSecurityToken createRequestSecurityToken(ITrustRequestSecurityTokenTemplate rstt) {
        Trust13RequestSecurityToken rst = new Trust13RequestSecurityToken(rstt);
        return rst;
    }

    @Override
    public ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(ITrustRequestSecurityToken rst) throws SoapSecurityException {
        Trust13RequestSecurityTokenCollection rstc = null;
        if (rst != null) {
            rstc = new Trust13RequestSecurityTokenCollection((TrustProperties)trustProperties, rst);
        }
        return rstc;
    }

    @Override
    public ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(List<ITrustRequestSecurityToken> rstList) throws SoapSecurityException {
        Trust13RequestSecurityTokenCollection rstc = null;
        if (rstList != null && rstList.size() >= 1) {
            rstc = new Trust13RequestSecurityTokenCollection((TrustProperties)trustProperties, rstList);
        }
        return rstc;
    }
}

