/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.v12;

import com.ibm.ws.wssecurity.trust.ext.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustClient;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.v12.Trust12Formatter;
import com.ibm.ws.wssecurity.trust.ext.client.v12.Trust12Properties;
import com.ibm.ws.wssecurity.trust.ext.client.v12.Trust12RequestSecurityToken;
import com.ibm.ws.wssecurity.trust.ext.client.v12.Trust12RequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.ext.client.v12.Trust12RequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.List;

public class Trust12Client
extends TrustClient
implements ITrustClient {
    private static final TraceComponent tc = Tr.register(Trust12Client.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static Trust12Client trust12Client = null;
    private static Trust12Properties trustProperties = null;

    public static Trust12Client getInstance() {
        if (trust12Client == null) {
            trust12Client = new Trust12Client();
        }
        return trust12Client;
    }

    private Trust12Client() {
        trustProperties = new Trust12Properties();
    }

    @Override
    public TrustProperties getTrustProperties() {
        return trustProperties;
    }

    @Override
    public ITrustRequestSecurityTokenTemplate getRequestSecurityTokenTemplate(ITrustRequesterConfig request) throws SoapSecurityException {
        Trust12Formatter formatter = new Trust12Formatter(trustProperties);
        return new Trust12RequestSecurityTokenTemplate(trustProperties, request, formatter);
    }

    @Override
    public ITrustRequestSecurityToken createRequestSecurityToken(ITrustRequestSecurityTokenTemplate rstt) {
        Trust12RequestSecurityToken rst = new Trust12RequestSecurityToken(rstt);
        return rst;
    }

    @Override
    public ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(ITrustRequestSecurityToken rst) throws SoapSecurityException {
        Trust12RequestSecurityTokenCollection rstc = null;
        if (rst != null) {
            rstc = new Trust12RequestSecurityTokenCollection((TrustProperties)trustProperties, rst);
        }
        return rstc;
    }

    @Override
    public ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(List<ITrustRequestSecurityToken> rstList) throws SoapSecurityException {
        Trust12RequestSecurityTokenCollection rstc = null;
        if (rstList != null && rstList.size() >= 1) {
            rstc = new Trust12RequestSecurityTokenCollection((TrustProperties)trustProperties, rstList);
        }
        return rstc;
    }
}

