/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.util;

import com.ibm.ws.wssecurity.trust.ext.client.util.OMElementUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.trust.config.RequesterConfig;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;

public class ValidateUtils {
    private static final TraceComponent tc = Tr.register(ValidateUtils.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static boolean validKey(Class clazz, String key) {
        boolean valid = false;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            Field[] fields;
            for (Field field : fields = clazz.getFields()) {
                keys.add((String)field.get(String.class));
            }
            if (keys.contains(key)) {
                valid = true;
            }
        }
        catch (Throwable e) {
            valid = false;
        }
        return valid;
    }

    public static boolean validURI(String url) {
        boolean valid = false;
        try {
            new URI(url);
        }
        catch (Throwable e) {
            valid = false;
        }
        valid = true;
        return valid;
    }

    public static boolean validXMLText(String xmlText) {
        boolean valid = false;
        try {
            OMElementUtil.toOMElement(xmlText);
            valid = true;
        }
        catch (Throwable e) {
            valid = false;
        }
        return valid;
    }

    public static boolean validNamespaceKey(String key) {
        return ValidateUtils.validKey(RequesterConfig.Namespace.class, key);
    }
}

