/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.util;

import com.ibm.ws.policyset.runtime.EmptyPolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.TrustClientPolicySetAttachments;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustProviderConfig;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Properties;

public class TrustClientPSUtils {
    private static final TraceComponent tc = Tr.register(TrustClientPSUtils.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static String getApplicationName(ITrustProviderConfig providerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationName");
        }
        String applicationName = providerConfig.getApplicationName();
        if (PlatformContextUtil.isWebSphereThinClient() && applicationName == null) {
            applicationName = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationName returns " + applicationName);
        }
        return applicationName;
    }

    public static TrustClientPolicySetAttachments getTrustClientPolicySetAttachments(String applicationName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustClientPolicySetAttachments");
        }
        PolicySetUtil psUtil = PolicySetUtil.getInstance(null);
        TrustClientPolicySetAttachments trustClientAttachment = null;
        Properties assetProps = new Properties();
        assetProps.setProperty("applicationName", applicationName);
        trustClientAttachment = null;
        try {
            trustClientAttachment = psUtil.getTrustClientAttachments(assetProps);
        }
        catch (Throwable e) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.loadpolicyset", "0", e);
        }
        if (trustClientAttachment == null || trustClientAttachment instanceof EmptyPolicySetAttachmentsImpl) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.loadpolicyset", "1");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustClientPolicySetAttachments");
        }
        return trustClientAttachment;
    }

    public static PolicySetConfiguration getPolicySetConfiguration(TrustClientPolicySetAttachments trustClientAttachment, String policySetName, String bindingName, ClassLoader appClassLoader, ClassLoader systemClassLoader, String bindingScope, boolean loadFromJar) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfiguration");
        }
        if (appClassLoader == null) {
            appClassLoader = TrustClientPSUtils.class.getClassLoader();
        }
        if (systemClassLoader == null) {
            systemClassLoader = appClassLoader.getSystemClassLoader();
        }
        PolicySetConfiguration psc = null;
        try {
            psc = trustClientAttachment.getPolicySet(appClassLoader, systemClassLoader, policySetName, bindingName, bindingScope, loadFromJar);
        }
        catch (Throwable e) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.loadpolicyset", "2", e);
        }
        if (psc == null) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.loadpolicyset", "3");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfiguration");
        }
        return psc;
    }
}

