/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.util;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.trust.WSSTrustClientValidateResult;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.TrustClientPolicySetAttachments;
import com.ibm.ws.wssecurity.saml.saml11.assertion.utils.SAMLTokenBuilder;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustProviderConfig;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustDispatchResponse;
import com.ibm.ws.wssecurity.trust.ext.client.util.TrustClientPSUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.GenericSecurityTokenImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class TrustClientHelperUtils
implements WSSConstants {
    private static final TraceComponent tc = Tr.register(TrustClientHelperUtils.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static Map<String, Object> makePublic(Map<String, Object> privateMap) {
        HashMap<String, Object> publicMap = null;
        if (privateMap != null) {
            publicMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : privateMap.entrySet()) {
                String key = entry.getKey();
                if (key.equals("RequestedSecurityToken")) continue;
                Object privateValue = entry.getValue();
                Object publicValue = null;
                publicValue = privateValue != null && privateValue instanceof OMElement ? new OMStructure((OMElement)privateValue) : privateValue;
                publicMap.put(key, publicValue);
            }
        }
        return publicMap;
    }

    public static SecurityToken createSecurityToken(Map<String, Object> rstrProperties, boolean includeXML) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSecurityToken");
        }
        GenericSecurityTokenImpl token = null;
        if (rstrProperties.containsKey("TokenType")) {
            String tokenType = (String)rstrProperties.get("TokenType");
            OMElement omRequestedSecurityTokenElement = (OMElement)rstrProperties.get("RequestedSecurityToken");
            if (omRequestedSecurityTokenElement != null) {
                OMElement omToken = omRequestedSecurityTokenElement.getFirstElement();
                Map<String, Object> publicRSTRProperties = null;
                if (includeXML) {
                    publicRSTRProperties = TrustClientHelperUtils.makePublic(rstrProperties);
                }
                if (WSSConstants.SAML.SAML11_VALUE_TYPE.equals(tokenType)) {
                    token = SAMLTokenBuilder.createSAMLToken(rstrProperties, publicRSTRProperties, omToken);
                } else if (WSSConstants.SAML.SAML20_VALUE_TYPE.equals(tokenType)) {
                    token = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLTokenBuilder.createSAMLToken(rstrProperties, publicRSTRProperties, omToken);
                } else {
                    QName tokenTypeQName = null;
                    if (tokenType != null) {
                        tokenTypeQName = new QName("", tokenType);
                    }
                    token = new GenericSecurityTokenImpl(publicRSTRProperties, omToken, tokenTypeQName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSecurityToken");
        }
        return token;
    }

    public static PolicySetConfiguration getPSC(ITrustProviderConfig providerConfig, TrustClientPolicySetAttachments trustClientAttachment) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPSC");
        }
        PolicySetConfiguration psc = null;
        ClassLoader appLoader = null;
        ClassLoader sysLoader = null;
        psc = (PolicySetConfiguration)providerConfig.getPolicySetConfiguration();
        if (psc == null) {
            String policySetName = null;
            String bindingName = null;
            String bindingScope = null;
            boolean loadFromJar = false;
            policySetName = providerConfig.getPolicySetName();
            bindingName = providerConfig.getBindingName();
            appLoader = providerConfig.getApplicationClassLoader();
            sysLoader = providerConfig.getSystemClassLoader();
            bindingScope = providerConfig.getBindingScope();
            loadFromJar = providerConfig.getLoadPolicySetAndBindingFromJar();
            psc = TrustClientPSUtils.getPolicySetConfiguration(trustClientAttachment, policySetName, bindingName, appLoader, sysLoader, bindingScope, loadFromJar);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPSC");
        }
        return psc;
    }

    public static Map<String, Object> parseRSTR(ITrustRequestSecurityTokenResponse rstr) {
        OMElement omRST;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseRSTR");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (rstr.getEntropyBinarySecret() != null) {
            response.put("EntropyBinarySecret", rstr.getEntropyBinarySecret());
        }
        if (rstr.getCreatedDate() != null) {
            response.put("LifetimeCreated", rstr.getCreatedDate());
        }
        if (rstr.getExpiresDate() != null) {
            response.put("LifetimeExpires", rstr.getExpiresDate());
        }
        if (rstr.getKeySize() != null) {
            response.put("KeySize", rstr.getKeySize());
        }
        if (rstr.getRenewingAllow() != null) {
            response.put("RenewingAllow", rstr.getRenewingAllow());
        }
        if (rstr.getRenewingOK() != null) {
            response.put("RenewingOK", rstr.getRenewingOK());
        }
        if (rstr.getAppliesToAddress() != null) {
            response.put("AppliesToAddress", rstr.getAppliesToAddress());
        }
        if (rstr.getAppliesToPortType() != null) {
            response.put("AppliesToPortType", rstr.getAppliesToPortType());
        }
        if (rstr.getAppliesToAddress() != null) {
            response.put("AppliesToServiceName", rstr.getAppliesToServiceName());
        }
        if (rstr.getAppliesToAddress() != null) {
            response.put("IssuerAddress", rstr.getIssuerAddress());
        }
        if (rstr.getAppliesToPortType() != null) {
            response.put("IssuerPortType", rstr.getIssuerPortType());
        }
        if (rstr.getAppliesToAddress() != null) {
            response.put("IssuerServiceName", rstr.getIssuerServiceName());
        }
        if (rstr.getStatusCode() != null) {
            response.put("StatusCode", rstr.getStatusCode());
        }
        if (rstr.getTokenType() != null) {
            response.put("TokenType", rstr.getTokenType());
        }
        if (rstr.getRequestType() != null) {
            response.put("RequestType", rstr.getRequestType());
        }
        if (rstr.getAllowPostdating().booleanValue()) {
            response.put("AllowPostdating", rstr.getAllowPostdating());
        }
        if (rstr.getAuthenticationType() != null) {
            response.put("AuthenticationType", rstr.getAuthenticationType());
        }
        if (rstr.getKeyType() != null) {
            response.put("KeyType", rstr.getKeyType());
        }
        if (rstr.getSignatureAlgorithm() != null) {
            response.put("SignatureAlgorithm", rstr.getSignatureAlgorithm());
        }
        if (rstr.getEncryptionAlgorithm() != null) {
            response.put("EncryptionAlgorithm", rstr.getEncryptionAlgorithm());
        }
        if (rstr.getCanonicalizationAlgorithm() != null) {
            response.put("CanonicalizationAlgorithm", rstr.getCanonicalizationAlgorithm());
        }
        if (rstr.getProofEncryptionXML() != null) {
            response.put("ProofEncryptionXML", rstr.getProofEncryptionXML());
        }
        if (rstr.getEncryptionXML() != null) {
            response.put("EncryptionXML", rstr.getEncryptionXML());
        }
        if (rstr.getSignWith() != null) {
            response.put("SignWith", rstr.getSignWith());
        }
        if (rstr.getEncryptWith() != null) {
            response.put("EncryptWith", rstr.getEncryptWith());
        }
        if (rstr.getForwardable() != null) {
            response.put("Forwardable", rstr.getForwardable());
        }
        if (rstr.getDelegatable() != null) {
            response.put("Delegatable", rstr.getDelegatable());
        }
        if (rstr.getStatusReason() != null) {
            response.put("StatusReason", rstr.getStatusReason());
        }
        if (rstr.getRequestedSecurityTokenXML() != null) {
            response.put("RequestedSecurityToken", rstr.getRequestedSecurityTokenXML());
        }
        if (rstr.getRequestedProofToken() != null) {
            response.put("RequestedProofTokenXML", rstr.getRequestedProofToken());
        }
        if (rstr.getRequestedUnattachedReference() != null) {
            response.put("RequestedUnattachedReferenceXML", rstr.getRequestedUnattachedReference());
        }
        if (rstr.getRequestedAttachedReference() != null) {
            response.put("RequestedAttachedReferenceXML", rstr.getRequestedAttachedReference());
        }
        response.put("RequestSecurityTokenResponseXML", rstr.getRSTR());
        TrustDispatchResponse dispatchResponse = rstr.getDispatchResponse();
        if (dispatchResponse != null && dispatchResponse.getDispatchTest() && (omRST = dispatchResponse.getRST()) != null) {
            response.put("wstrustClientStandAloneTest", new OMStructure(omRST));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseRSTR");
        }
        return response;
    }

    public static List<SecurityToken> processRSTRC(ITrustRequestSecurityTokenResponseCollection rstrc, List<ITrustRequesterConfig> requestList, boolean includeXML) throws SoapSecurityException {
        ITrustRequestSecurityTokenResponse rstr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRSTRC");
        }
        ArrayList<SecurityToken> issuedTokens = new ArrayList<SecurityToken>();
        Map<String, Object> rstrProperties = null;
        SecurityToken token = null;
        Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
        if (iter.hasNext() && (rstrProperties = TrustClientHelperUtils.parseRSTR(rstr = iter.next())) != null && (token = TrustClientHelperUtils.createSecurityToken(rstrProperties, includeXML)) != null) {
            issuedTokens.add(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRSTRC");
        }
        return issuedTokens;
    }

    public static List<WSSTrustClientValidateResult> processValidateRSTRC(ITrustRequestSecurityTokenResponseCollection rstrc, List<ITrustRequesterConfig> requestList, boolean includeXML) throws SoapSecurityException {
        ITrustRequestSecurityTokenResponse rstr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRSTRC");
        }
        ArrayList<WSSTrustClientValidateResult> results = new ArrayList<WSSTrustClientValidateResult>();
        Map<String, Object> rstrProperties = null;
        SecurityToken token = null;
        Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
        if (iter.hasNext() && (rstrProperties = TrustClientHelperUtils.parseRSTR(rstr = iter.next())) != null) {
            if (rstrProperties.containsKey("RequestedSecurityToken")) {
                token = TrustClientHelperUtils.createSecurityToken(rstrProperties, includeXML);
            }
            String code = (String)rstrProperties.get("StatusCode");
            String reason = (String)rstrProperties.get("StatusReason");
            WSSTrustClientValidateResult result = new WSSTrustClientValidateResult(code, reason, token);
            if (includeXML) {
                OMElement omRST;
                TrustDispatchResponse dispatchResponse;
                OMElement omRSTR = rstr.getRSTR();
                if (omRSTR != null) {
                    result.setProperty("RequestSecurityTokenResponseXML", new OMStructure(omRSTR));
                }
                if ((dispatchResponse = rstr.getDispatchResponse()) != null && dispatchResponse.getDispatchTest() && (omRST = dispatchResponse.getRST()) != null) {
                    result.setProperty("wstrustClientStandAloneTest", new OMStructure(omRST));
                }
            }
            results.add(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRSTRC");
        }
        return results;
    }

    public static SecurityToken processRSTR(ITrustRequestSecurityTokenResponse rstr, ITrustRequesterConfig request, boolean includeXML) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRSTR");
        }
        Map<String, Object> rstrProperties = null;
        SecurityToken token = null;
        rstrProperties = TrustClientHelperUtils.parseRSTR(rstr);
        if (rstrProperties != null && rstrProperties.containsKey("RequestedSecurityToken")) {
            token = TrustClientHelperUtils.createSecurityToken(rstrProperties, includeXML);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRSTR");
        }
        return token;
    }

    public static List<WSSTrustClientValidateResult> processValidateRSTRC(ITrustRequestSecurityTokenResponseCollection rstrc, ITrustRequesterConfig request, boolean includeXML) throws SoapSecurityException {
        ITrustRequestSecurityTokenResponse rstr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRSTR");
        }
        Map<String, Object> rstrProperties = null;
        SecurityToken token = null;
        ArrayList<WSSTrustClientValidateResult> results = new ArrayList<WSSTrustClientValidateResult>();
        Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
        if (iter.hasNext() && (rstrProperties = TrustClientHelperUtils.parseRSTR(rstr = iter.next())) != null) {
            if (rstrProperties.containsKey("RequestedSecurityToken")) {
                token = TrustClientHelperUtils.createSecurityToken(rstrProperties, includeXML);
            }
            String code = (String)rstrProperties.get("StatusCode");
            String reason = (String)rstrProperties.get("StatusReason");
            WSSTrustClientValidateResult result = new WSSTrustClientValidateResult(code, reason, token);
            if (includeXML) {
                OMElement omRST;
                TrustDispatchResponse dispatchResponse;
                OMElement omRSTR = rstr.getRSTR();
                if (omRSTR != null) {
                    result.setProperty("RequestSecurityTokenResponseXML", new OMStructure(omRSTR));
                }
                if ((dispatchResponse = rstr.getDispatchResponse()) != null && dispatchResponse.getDispatchTest() && (omRST = dispatchResponse.getRST()) != null) {
                    result.setProperty("wstrustClientStandAloneTest", new OMStructure(omRST));
                }
            }
            results.add(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRSTR");
        }
        return results;
    }
}

