/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.util;

import com.ibm.ws.wssecurity.trust.ext.client.util.OMElementUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;

public class TokenDereferenceUtils
implements WSSConstants {
    private static final TraceComponent tc = Tr.register(TokenDereferenceUtils.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static OMElement lookupTokenReference(OMElement omElement, OMElement soapHeaders, String strWSSENamespace, QName referenceAttribute) {
        OMElement newOMElement = omElement;
        if (omElement != null && soapHeaders != null) {
            QName qnReference = new QName(strWSSENamespace, "Reference");
            try {
                OMElement omReference = omElement.getFirstChildWithName(qnReference);
                OMElement omSecurityToken = null;
                if (omReference != null && (omSecurityToken = TokenDereferenceUtils.resolveReference(omReference, soapHeaders, strWSSENamespace, referenceAttribute)) != null) {
                    newOMElement = OMAbstractFactory.getOMFactory().createOMElement(omElement.getQName());
                    Iterator i = omElement.getAllAttributes();
                    while (i.hasNext()) {
                        newOMElement.addAttribute((OMAttribute)i.next());
                    }
                    Iterator ie = omElement.getChildElements();
                    while (ie.hasNext()) {
                        OMElement next = (OMElement)ie.next();
                        if (next.equals(omReference)) {
                            newOMElement.addChild(omSecurityToken);
                            continue;
                        }
                        newOMElement.addChild(next);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return newOMElement;
    }

    public static OMElement resolveReference(OMElement omReference, OMElement soapHeaders, String strWSSENamespace, QName referenceAttribute) {
        OMElement omSecurityToken = omReference;
        if (omReference != null && soapHeaders != null) {
            String strURI;
            OMAttribute attributeURI;
            QName qnReference = new QName(strWSSENamespace, "Reference");
            if (omReference.getQName().equals(qnReference) && (attributeURI = omReference.getAttribute(referenceAttribute)) != null && (strURI = attributeURI.getAttributeValue()) != null && strURI.startsWith("#")) {
                strURI = strURI.substring(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "looking for wsse:Id '" + strURI + "'");
                }
                if ((omSecurityToken = TokenDereferenceUtils.getSecurityTokenFromHeaders(soapHeaders, strWSSENamespace, strURI)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " Found an SecurityToken Item :" + omSecurityToken);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did Not Find an SecurityToken Item");
                }
            }
        }
        return omSecurityToken;
    }

    public static OMElement getSecurityTokenFromHeaders(OMElement soapHeaders, String wsseNamespace, String strID) {
        QName SecurityQName = new QName(wsseNamespace, "Security");
        OMElement omSecurityToken = null;
        Iterator iterHeaders = soapHeaders.getChildrenWithName(SecurityQName);
        while (iterHeaders.hasNext()) {
            OMElement omHeader = (OMElement)iterHeaders.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Security Item :" + omHeader);
            }
            Iterator iter = omHeader.getChildren();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof OMElement)) continue;
                OMElement child = (OMElement)next;
                Iterator iterAttrs = child.getAllAttributes();
                while (iterAttrs.hasNext()) {
                    String strValue;
                    OMAttribute attr = (OMAttribute)iterAttrs.next();
                    if (!attr.getLocalName().equals("Id")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found an Item with Id :" + OMElementUtil.toString(child));
                    }
                    if (!(strValue = attr.getAttributeValue()).equals(strID)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found matching security token:" + OMElementUtil.toString(child));
                    }
                    omSecurityToken = child;
                }
            }
        }
        return omSecurityToken;
    }
}

