/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.axis2.util.XMLUtils;

public class OMElementUtil {
    private static final TraceComponent tc = Tr.register(OMElementUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static String stackTrace(Throwable e) {
        String stackTrace = null;
        try {
            StringWriter sWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(sWriter));
            stackTrace = sWriter.getBuffer().toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stackTrace;
    }

    public static boolean compareNamespaceURI(OMNamespace om1, OMNamespace om2) {
        String ns2;
        String ns1;
        boolean rc = false;
        if (om1 != null && om2 != null && (ns1 = om1.getNamespaceURI()).equals(ns2 = om2.getNamespaceURI())) {
            rc = true;
        }
        return rc;
    }

    public static boolean compareQName(OMElement om1, OMElement om2) {
        QName qn2;
        QName qn1;
        boolean rc = false;
        if (om1 != null && om2 != null && (qn1 = om1.getQName()).equals(qn2 = om2.getQName())) {
            rc = true;
        }
        return rc;
    }

    public static String formatXML(OMElement omInput) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String output = "";
        try {
            XMLPrettyPrinter.prettify(omInput, out);
            output = out.toString();
        }
        catch (Throwable e) {
            try {
                output = OMElementUtil.toString(omInput);
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
        return output;
    }

    public static OMElement toOMElement(String s) throws XMLStreamException {
        OMElement omElement;
        block2: {
            omElement = null;
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(s.getBytes());
            omElement = (OMElement)XMLUtils.toOM(bytearrayinputstream);
            try {
                bytearrayinputstream.close();
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, e.getMessage());
            }
        }
        return omElement;
    }

    public static OMElement toOMElement(Protocol soap2, String strElement) throws XMLStreamException {
        OMElement omElement = null;
        StringReader sr = new StringReader(strElement);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader inputReader = null;
        try {
            inputReader = inputFactory.createXMLStreamReader(sr);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        if (soap2 == null) {
            soap2 = Protocol.soap11;
        }
        MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
        Message msg = null;
        try {
            msg = mf.createFrom(inputReader, soap2);
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw e;
        }
        omElement = msg.getAsOMElement();
        return omElement;
    }

    public static String toString(OMElement omElement) {
        String strElement;
        block5: {
            if (null == omElement) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            strElement = null;
            try {
                omElement.serialize(outputStream);
                strElement = outputStream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UnsupportedEncodingException " + e.getMessage());
                }
            }
            catch (XMLStreamException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "XMLStreamExceptoin " + e.getMessage());
            }
        }
        return strElement;
    }
}

