/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustDispatchResponse;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.util.OMElementUtil;
import com.ibm.ws.wssecurity.trust.ext.client.util.WSSContextPolicySetConfiguratorFactory;
import com.ibm.ws.wssecurity.trust.ext.client.util.WSSPolicySetConfigurator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.trust.config.ProviderConfig;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.jaxws.utility.JavaUtils;

public class TrustSecurityTokenServiceDispatch {
    private static final TraceComponent tc = Tr.register(TrustSecurityTokenServiceDispatch.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    protected static void addHeaderBlock(SOAPHeader sh, OMElement om) {
        OMNamespace namespace = om.getNamespace();
        String localname = om.getLocalName();
        if (namespace != null && localname != null) {
            SOAPHeaderBlock shb = sh.addHeaderBlock(localname, namespace);
            String text = om.getText();
            if (text != null) {
                shb.setText(text);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TrustDispatchResponse requestSecurityToken(OMElement to, OMElement messageID, OMElement action, List<OMElement> otherHeaders, OMElement request, PolicySetConfiguration psc, TrustProperties trustProperties, ProviderConfig providerConfig, ITrustRequesterConfig requestConfig) throws SoapSecurityException {
        OMElement omResponseEnvelope;
        boolean dispatchTest;
        SOAPEnvelope omRequestEnvelope;
        OMElement resp;
        block38: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "requestSecurityToken");
            }
            resp = null;
            omRequestEnvelope = null;
            dispatchTest = false;
            if (to == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Provider address is null");
                    Tr.debug(tc, OMElementUtil.stackTrace(new Throwable()));
                }
                throw SoapSecurityException.format("security.wssecurity.trust.client.provider", providerConfig.getProvider());
            }
            String binding = null;
            SOAPFactory soapFactory = null;
            if (requestConfig.getSOAPNamespace() != null && requestConfig.getSOAPNamespace().equals("http://www.w3.org/2003/05/soap-envelope")) {
                soapFactory = OMAbstractFactory.getSOAP12Factory();
                binding = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
            } else {
                soapFactory = OMAbstractFactory.getSOAP11Factory();
                binding = "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
            WSSPolicySetConfigurator configurator = null;
            try {
                configurator = WSSContextPolicySetConfiguratorFactory.getPolicySetConfigurator();
            }
            catch (Throwable e) {
                throw SoapSecurityException.format("security.wssecurity.trust.client.provider", providerConfig.getProvider(), e);
            }
            Object orgContextPSLoader = null;
            omResponseEnvelope = null;
            try {
                block37: {
                    omRequestEnvelope = soapFactory.createSOAPEnvelope();
                    SOAPHeader sh = soapFactory.createSOAPHeader(omRequestEnvelope);
                    TrustSecurityTokenServiceDispatch.addHeaderBlock(sh, to);
                    TrustSecurityTokenServiceDispatch.addHeaderBlock(sh, messageID);
                    TrustSecurityTokenServiceDispatch.addHeaderBlock(sh, action);
                    if (otherHeaders != null && otherHeaders.size() > 0) {
                        for (OMElement other : otherHeaders) {
                            TrustSecurityTokenServiceDispatch.addHeaderBlock(sh, other);
                        }
                    }
                    SOAPBody sb = soapFactory.createSOAPBody(omRequestEnvelope);
                    sb.addChild(request);
                    if (requestConfig.containsKey("wstrustClientStandAloneTest")) {
                        String response = requestConfig.get("wstrustClientStandAloneTest");
                        try {
                            omResponseEnvelope = OMElementUtil.toOMElement(response);
                            dispatchTest = true;
                        }
                        catch (XMLStreamException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, e.getMessage());
                            }
                            break block37;
                        }
                    }
                    if (configurator == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WSSContextPolicySetConfiguratorFactory.getPolicySetConfigurator returned null.  Unable to set outgoing Trust Client PolicySet.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.trust.client.provider", providerConfig.getProvider());
                    }
                    orgContextPSLoader = configurator.setContextPolicySet(psc);
                    QName serviceName = providerConfig.getServiceName();
                    QName portName = providerConfig.getPortName();
                    Service service = Service.create((QName)serviceName);
                    try {
                        service.addPort(portName, binding, to.getText());
                    }
                    catch (Throwable e) {
                        Tr.debug(tc, "service.addPort failure: " + e.getMessage());
                        Tr.debug(tc, OMElementUtil.stackTrace(e));
                        throw SoapSecurityException.format("security.wssecurity.trust.client.provider", providerConfig.getProvider(), e);
                    }
                    Dispatch dispatch = null;
                    try {
                        dispatch = service.createDispatch(portName, OMElement.class, Service.Mode.MESSAGE);
                    }
                    catch (Throwable e) {
                        Tr.debug(tc, "service.createDispatch failure: " + e.getMessage());
                        Tr.debug(tc, OMElementUtil.stackTrace(e));
                        throw SoapSecurityException.format("security.wssecurity.trust.client.requestfalied", providerConfig.getProvider(), e);
                    }
                    if (dispatch == null) {
                        Tr.debug(tc, "Trust Client dispact == null");
                        Tr.debug(tc, OMElementUtil.stackTrace(new Throwable()));
                        throw SoapSecurityException.format("security.wssecurity.trust.client.requestfalied", providerConfig.getProvider());
                    }
                    Dispatch bp = dispatch;
                    Map rc = bp.getRequestContext();
                    rc.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
                    rc.put("javax.xml.ws.soap.http.soapaction.uri", action.getText());
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Trust Client outgoing request:");
                            Tr.debug(tc, OMElementUtil.formatXML(omRequestEnvelope));
                        }
                        omResponseEnvelope = (OMElement)dispatch.invoke((Object)omRequestEnvelope);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security Token Service reponse:");
                            Tr.debug(tc, OMElementUtil.formatXML(omResponseEnvelope));
                        }
                    }
                    catch (Throwable e) {
                        FFDCFilter.processException(e, TrustSecurityTokenServiceDispatch.class.getName(), "1");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dispatch.invoke failure: " + e.getMessage());
                            Tr.debug(tc, OMElementUtil.stackTrace(e));
                            Tr.debug(tc, OMElementUtil.formatXML(omRequestEnvelope));
                        }
                        throw SoapSecurityException.format("security.wssecurity.trust.client.requestfalied", providerConfig.getProvider(), e);
                    }
                }
                if (omResponseEnvelope == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dispatch.invoke() returned null");
                    }
                    throw SoapSecurityException.format("security.wssecurity.trust.client.serverresponse");
                }
                OMElement respBody = omResponseEnvelope.getFirstChildWithName(new QName(requestConfig.getSOAPNamespace(), "Body"));
                if (respBody == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dispatch.invoke() returned soapenv with no Body");
                    }
                    throw SoapSecurityException.format("security.wssecurity.trust.client.serverresponse");
                }
                resp = respBody.getFirstElement();
                if (resp == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dispatch.invoke() returned body with no child element");
                    }
                    throw SoapSecurityException.format("security.wssecurity.trust.client.serverresponse");
                }
                if (configurator == null) break block38;
            }
            catch (SoapSecurityException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (configurator != null) {
                        configurator.setContextPolicySetLoader(orgContextPSLoader);
                    }
                    TrustSecurityTokenServiceDispatch.consume(omResponseEnvelope);
                    throw throwable;
                }
            }
            configurator.setContextPolicySetLoader(orgContextPSLoader);
        }
        TrustSecurityTokenServiceDispatch.consume(omResponseEnvelope);
        OMElement respHeader = omResponseEnvelope.getFirstChildWithName(new QName(requestConfig.getSOAPNamespace(), "Header"));
        TrustDispatchResponse dispatchResponse = new TrustDispatchResponse(respHeader, resp, omRequestEnvelope, dispatchTest);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSecurityToken");
        }
        return dispatchResponse;
    }

    public static void consume(OMElement omResponse) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "consume");
            }
            if (omResponse != null && omResponse instanceof OMElementImpl) {
                try {
                    omResponse.build();
                    OMElementImpl root = null;
                    root = (OMElementImpl)omResponse;
                    while (root.getParent() instanceof OMElementImpl) {
                        root = (OMElementImpl)root.getParent();
                    }
                    if (!root.isComplete() && root.getBuilder() != null && !root.getBuilder().isCompleted()) {
                        Tr.debug(tc, "Forwarding the parser so that it closes");
                        while (root.getBuilder().next() != 8) {
                        }
                    }
                }
                catch (Throwable e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Builder next error:" + e.getMessage());
                    Tr.debug(tc, JavaUtils.stackToString(e));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "consume");
        }
    }
}

