/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.util.ValidateUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TrustRequesterConfig
extends ValidateUtils
implements ITrustRequesterConfig {
    private static final TraceComponent tc = Tr.register(TrustRequesterConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    String action = null;
    String messageID = null;
    protected List<XMLStructure> omList = null;
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Map<String, String> secondaryParameters = null;
    protected List<String> listKeySet = null;
    protected HashMap<String, List<String>> listMap = null;
    protected HashMap<String, List<String>> secondaryListMap = null;

    public TrustRequesterConfig() {
        this.omList = new ArrayList<XMLStructure>();
        this.secondaryParameters = new HashMap<String, String>();
        this.listKeySet = new ArrayList<String>();
        this.listMap = new HashMap();
        this.secondaryListMap = new HashMap();
    }

    @Override
    public void addXML(XMLStructure xmlStructure) {
        this.omList.add(xmlStructure);
    }

    @Override
    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    public boolean containsNamespaceKey(String key) {
        return this.namespaces.containsKey(key);
    }

    @Override
    public String get(String key) {
        return this.parameters.get(key);
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getMessageID() {
        return this.messageID;
    }

    @Override
    public String getNamespace(String key) {
        String entry = null;
        if (ValidateUtils.validNamespaceKey(key)) {
            entry = this.namespaces.get(key);
        }
        return entry;
    }

    @Override
    public List<XMLStructure> getXMLList() {
        return this.omList;
    }

    @Override
    public String getSOAPNamespace() {
        String soap2 = this.namespaces.get("soap");
        if (soap2 == null) {
            soap2 = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        return soap2;
    }

    @Override
    public String getWSAddressingNamespace() {
        return this.namespaces.get("wsa");
    }

    @Override
    public void put(String key, String text) throws WSSException {
        if (!this.validRSTTKey(key)) {
            throw WSSException.format("security.wssecurity.trust.client.key", key);
        }
        this.putAny(key, text);
    }

    @Override
    public void putAny(String key, String text) {
        String prefix = this.lookupPrefix(key, this.listKeySet);
        if (prefix != null) {
            List<String> list = this.listMap.get(prefix);
            if (list == null) {
                list = new ArrayList<String>();
                this.listMap.put(prefix, list);
            }
            list.add(text);
        }
        this.parameters.put(key, text);
    }

    String lookupPrefix(String key, List<String> listKeySet) {
        String prefix = null;
        if (key != null && listKeySet != null && !listKeySet.isEmpty()) {
            for (String keySet : listKeySet) {
                if (keySet == null || !key.startsWith(keySet)) continue;
                try {
                    String suffix = key.substring(keySet.length());
                    if (suffix == null || !suffix.equals("") && Integer.parseInt(suffix) < 0) continue;
                    prefix = keySet;
                    break;
                }
                catch (Throwable e) {
                }
            }
        }
        return prefix;
    }

    @Override
    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    @Override
    public void setRSTTProperties(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            for (String key : map.keySet()) {
                this.putAny(key, map.get(key));
            }
        }
    }

    @Override
    public void setSOAPNamespace(String namespace) throws WSSException {
        if (!namespace.equals("http://schemas.xmlsoap.org/soap/envelope/") && !namespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw WSSException.format("security.wssecurity.trust.client.soapnamespace", namespace);
        }
        this.namespaces.put("soap", namespace);
    }

    public void setWSAddressingNamespace(String namespace) throws WSSException {
        if (!namespace.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && !namespace.equals("http://www.w3.org/2005/08/addressing")) {
            throw WSSException.format("security.wssecurity.trust.client.wsanamespace", namespace);
        }
        this.namespaces.put("wsa", namespace);
    }

    @Override
    public void validate() throws SoapSecurityException {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            for (String key : this.parameters.keySet()) {
                if (this.validRSTTKey(key)) continue;
                throw SoapSecurityException.format("security.wssecurity.trust.client.key", key);
            }
        }
    }

    @Override
    public boolean containsSecondaryParameterKey(String key) {
        return this.secondaryParameters.containsKey(key);
    }

    @Override
    public String getSecondaryParameter(String key) {
        return this.secondaryParameters.get(key);
    }

    @Override
    public Map<String, String> getSecondaryParameters() {
        return this.secondaryParameters;
    }

    @Override
    public Map<String, String> getRSTTProperties() {
        return this.parameters;
    }

    @Override
    public List<String> getList(String key) {
        List<String> list = null;
        if (this.listKeySet.contains(key)) {
            list = this.listMap.get(key);
        }
        return list;
    }

    @Override
    public List<String> getSecondaryList(String key) {
        List<String> list = null;
        if (this.listKeySet.contains(key)) {
            list = this.secondaryListMap.get(key);
        }
        return list;
    }

    @Override
    public void putSecondaryParameter(String key, String text) throws WSSException {
        if (this.validRSTTKey(key)) {
            String prefix = this.lookupPrefix(key, this.listKeySet);
            if (prefix != null) {
                List<String> list = this.secondaryListMap.get(prefix);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.secondaryListMap.put(prefix, list);
                }
                list.add(text);
            }
        } else {
            throw WSSException.format("security.wssecurity.trust.client.key", key);
        }
        this.secondaryParameters.put(key, text);
    }

    public abstract boolean validRSTTKey(String var1);
}

