/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustFormatter;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.util.TrustOMFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;

public abstract class TrustRequestSecurityTokenTemplate
implements ITrustRequestSecurityTokenTemplate {
    protected TrustProperties trustProperties;
    protected OMAttribute attributeContext = null;
    protected List<OMElement> otherHeaderList = new ArrayList<OMElement>();
    protected List<OMElement> bodyList = new ArrayList<OMElement>();
    protected List<OMElement> secondaryParameterList = new ArrayList<OMElement>();
    protected OMElement to = null;
    protected OMElement messageID = null;
    protected OMElement action = null;

    public TrustRequestSecurityTokenTemplate(TrustProperties trustProperties, ITrustRequesterConfig request, TrustFormatter formatter) throws SoapSecurityException {
        this.trustProperties = trustProperties;
        this.setAction(formatter.formatAction(request));
        this.setMessageID(formatter.formatMessageID(request));
        this.setContext(formatter.formatContext(request.getRSTTProperties()));
        this.addElements(this.bodyList, formatter, request.getRSTTProperties(), request.getList("wstrustClientClaimsRequiredClaimTypeURI"), request.getList("wstrustClientClaimsOptionalClaimTypeURI"));
        this.addElements(this.secondaryParameterList, formatter, request.getSecondaryParameters(), request.getSecondaryList("wstrustClientClaimsRequiredClaimTypeURI"), request.getSecondaryList("wstrustClientClaimsOptionalClaimTypeURI"));
        List<XMLStructure> omList = request.getXMLList();
        for (XMLStructure item : omList) {
            if (!(item instanceof OMStructure)) continue;
            this.addBodyElement(this.bodyList, ((OMStructure)item).getNode());
        }
    }

    protected void addElements(List<OMElement> list, TrustFormatter formatter, Map<String, String> map, List<String> requiredClaimTypeList, List<String> optionalClaimTypeList) throws SoapSecurityException {
        this.addBodyElement(list, formatter.formatTokenType(map));
        this.addBodyElement(list, formatter.formatRequestType(map));
        this.addBodyElement(list, formatter.formatKeyType(map));
        this.addBodyElement(list, formatter.formatKeySize(map));
        this.addBodyElement(list, formatter.formatComputedKeyAlgorithm(map));
        this.addBodyElement(list, formatter.formatAppliesTo(map));
        this.addBodyElement(list, formatter.formatClaimType(map, requiredClaimTypeList, optionalClaimTypeList));
        this.addBodyElement(list, formatter.formatEntropy_BinarySecret(map));
        this.addBodyElement(list, formatter.formatEntropy_EncryptedKey(map));
        this.addBodyElement(list, formatter.formatLifetime(map));
        this.addBodyElement(list, formatter.formatAllowPostdating(map));
        this.addBodyElement(list, formatter.formatRenewing(map));
        this.addBodyElement(list, formatter.formatIssuer_EPR(map));
        this.addBodyElement(list, formatter.formatAuthenticationType(map));
        this.addBodyElement(list, formatter.formatSignatureAlgorithm(map));
        this.addBodyElement(list, formatter.formatEncryptionAlgorithm(map));
        this.addBodyElement(list, formatter.formatCanonicalizationAlgorithm(map));
        this.addBodyElement(list, formatter.formatSignWith(map));
        this.addBodyElement(list, formatter.formatEncryptWith(map));
        this.addBodyElement(list, formatter.formatForwardable(map));
        this.addBodyElement(list, formatter.formatDelegatable(map));
        this.addBodyElement(list, formatter.formatPolicyReference(map));
        this.addBodyElement(list, formatter.formatValidateTarget_STR(map));
        this.addBodyElement(list, formatter.formatBase(map));
    }

    public void addBodyElement(List<OMElement> list, OMElement element) {
        if (element != null) {
            list.add(element);
        }
    }

    public void addSecondaryParameterElement(OMElement element) {
        if (element != null) {
            this.secondaryParameterList.add(element);
        }
    }

    @Override
    public boolean addHeader(OMElement header) {
        return this.otherHeaderList.add(header);
    }

    public OMElement getHeader(QName qname) {
        OMElement header = null;
        for (OMElement element : this.otherHeaderList) {
            if (!qname.equals(element.getQName())) continue;
            header = element;
            break;
        }
        return header;
    }

    public List<OMElement> getHeaders() {
        return this.otherHeaderList;
    }

    @Override
    public List<OMElement> getBodyList() {
        return this.bodyList;
    }

    @Override
    public List<OMElement> getSecondaryParameterList() {
        return this.secondaryParameterList;
    }

    @Override
    public OMElement getBody() {
        OMElement body = null;
        body = TrustOMFactory.createOMElement(this.trustProperties.REQUESTSECURITYTOKEN);
        List<OMElement> bodyList = this.getBodyList();
        for (OMElement element : bodyList) {
            body.addChild(element);
        }
        OMAttribute omContext = this.getContext();
        if (omContext != null) {
            body.addAttribute(omContext);
        }
        if (!this.secondaryParameterList.isEmpty()) {
            OMElement secondaryParameters = TrustOMFactory.createOMElement(this.trustProperties.SECONDARYPARAMETERS);
            for (OMElement element : this.secondaryParameterList) {
                secondaryParameters.addChild(element);
            }
            body.addChild(secondaryParameters);
        }
        return body;
    }

    @Override
    public OMElement getAction() {
        return this.action;
    }

    @Override
    public OMElement getMessageID() {
        return this.messageID;
    }

    @Override
    public OMElement getTo() {
        return this.to;
    }

    @Override
    public void setTo(OMElement to) {
        if (to != null) {
            this.to = to;
        }
    }

    @Override
    public void setMessageID(OMElement messageID) {
        if (messageID != null) {
            this.messageID = messageID;
        }
    }

    @Override
    public void setAction(OMElement action) {
        if (action != null) {
            this.action = action;
        }
    }

    @Override
    public List<OMElement> getOtherHeaders() {
        return this.otherHeaderList;
    }

    @Override
    public OMAttribute getContext() {
        return this.attributeContext;
    }

    private void setContext(OMAttribute context) {
        this.attributeContext = context;
    }
}

