/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustDispatchResponse;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

public class TrustRequestSecurityTokenResponseCollection
implements ITrustRequestSecurityTokenResponseCollection {
    private static final TraceComponent tc = Tr.register(TrustRequestSecurityTokenResponseCollection.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    List<ITrustRequestSecurityTokenResponse> rstrList = new ArrayList<ITrustRequestSecurityTokenResponse>();
    TrustProperties trustProperties = null;

    public TrustRequestSecurityTokenResponseCollection(TrustProperties trustProperties, TrustRequestSecurityTokenResponse rstr) {
        this.trustProperties = trustProperties;
        this.rstrList.add(rstr);
    }

    public TrustRequestSecurityTokenResponseCollection(TrustProperties trustProperties, TrustDispatchResponse dispatchResponse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TrustRequestSecurityTokenResponseCollection");
        }
        this.trustProperties = trustProperties;
        OMElement omElement = dispatchResponse.getRSTR();
        OMNamespace omNamespace = omElement.getNamespace();
        if (omNamespace == null) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.wstnamespace", "null");
        }
        if (omElement.getLocalName().equals("RequestSecurityTokenResponseCollection")) {
            Iterator i = omElement.getChildrenWithName(trustProperties.REQUESTSECURITYTOKENRESPONSE);
            while (i.hasNext()) {
                OMElement rstr = (OMElement)i.next();
                dispatchResponse.setRSTR(rstr);
                TrustRequestSecurityTokenResponse sts_rstr = new TrustRequestSecurityTokenResponse(this.trustProperties, dispatchResponse);
                this.rstrList.add(sts_rstr);
            }
        } else if (omElement.getLocalName().equals("RequestSecurityTokenResponse")) {
            TrustRequestSecurityTokenResponse sts_rstr = new TrustRequestSecurityTokenResponse(this.trustProperties, dispatchResponse);
            this.rstrList.add(sts_rstr);
        }
        if (this.rstrList.size() == 0) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.serverresponse");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TrustRequestSecurityTokenResponseCollection");
        }
    }

    @Override
    public Iterator<ITrustRequestSecurityTokenResponse> getRSTRCollection() {
        return this.rstrList.iterator();
    }
}

