/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustDispatchResponse;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.util.TokenDereferenceUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;

public class TrustRequestSecurityTokenResponse
implements ITrustRequestSecurityTokenResponse {
    private static final TraceComponent tc = Tr.register(TrustRequestSecurityTokenResponse.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected TrustProperties trustProperties;
    protected TrustDispatchResponse dispatchResponse = null;

    TrustRequestSecurityTokenResponse(TrustProperties trustProperties, TrustDispatchResponse dispatchResponse) {
        this.trustProperties = trustProperties;
        this.dispatchResponse = dispatchResponse;
    }

    @Override
    public OMElement getHeader() {
        return this.dispatchResponse.getHeader();
    }

    @Override
    public OMElement getRSTR() {
        return this.dispatchResponse.getRSTR();
    }

    @Override
    public TrustDispatchResponse getDispatchResponse() {
        return this.dispatchResponse;
    }

    public String getElementEPRChild(QName qname, QName child) {
        String addressText = null;
        OMElement omElement = this.getElement(qname);
        if (omElement != null) {
            OMElement omEndpointReferenceElement = omElement.getFirstChildWithName(this.trustProperties.ENDPOINTREFERENCE);
            OMElement omAddressElement = null;
            if (omEndpointReferenceElement != null && (omAddressElement = omEndpointReferenceElement.getFirstChildWithName(child)) != null) {
                addressText = omAddressElement.getText();
            }
        }
        return addressText;
    }

    public String getElementText(QName qname) {
        String text = null;
        OMElement omElement = this.getElement(qname);
        if (omElement != null) {
            text = omElement.getText();
        }
        return text;
    }

    public String getElementChildText(QName qname, QName qnchild) {
        String text = null;
        OMElement omElement = this.getElementChild(qname, qnchild);
        if (omElement != null) {
            text = omElement.getText();
        }
        return text;
    }

    public OMElement getElementChild(QName qname, QName qnchild) {
        OMElement omElement = this.getElement(qname);
        OMElement omChild = null;
        if (omElement != null) {
            omChild = omElement.getFirstChildWithName(qnchild);
        }
        return omChild;
    }

    public OMElement getElementChild(QName qname) {
        OMElement omElement = this.getElement(qname);
        OMElement omChild = null;
        if (omElement != null) {
            omChild = omElement.getFirstElement();
        }
        return omChild;
    }

    @Override
    public OMElement getElement(QName qname) {
        return this.getRSTR().getFirstChildWithName(qname);
    }

    @Override
    public Date getCreatedDate() {
        OMElement createdElement;
        String method = "getCreatedDate()";
        Date createdDate = null;
        OMElement lifetime = this.getRSTR().getFirstChildWithName(this.trustProperties.LIFETIME);
        if (lifetime != null && (createdElement = lifetime.getFirstChildWithName(this.trustProperties.CREATED)) != null) {
            String created = createdElement.getText();
            if (created != null) {
                createdDate = TrustRequestSecurityTokenResponse.parseDateTime(created);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lifetime Created element not found");
            }
        }
        return createdDate;
    }

    public static final Date parseDateTime(String s) {
        if (s == null) {
            return null;
        }
        try {
            Date d = UTC.parse(s);
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date getExpiresDate() {
        OMElement expiresElement;
        String method = "getExpiresDate()";
        Date expiresDate = null;
        OMElement lifetime = this.getRSTR().getFirstChildWithName(this.trustProperties.LIFETIME);
        if (lifetime != null && (expiresElement = lifetime.getFirstChildWithName(this.trustProperties.EXPIRES)) != null) {
            String expires = expiresElement.getText();
            if (expires != null) {
                expiresDate = TrustRequestSecurityTokenResponse.parseDateTime(expires);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lifetime Expires element not found");
            }
        }
        return expiresDate;
    }

    @Override
    public Integer getKeySize() {
        String keySizeTxt;
        Integer keySize = null;
        OMElement omKeySize = this.getRSTR().getFirstChildWithName(this.trustProperties.KEYSIZE);
        if (omKeySize != null && (keySizeTxt = omKeySize.getText()) != null) {
            keySize = new Integer(keySizeTxt);
        }
        return keySize;
    }

    @Override
    public byte[] getEntropyBinarySecret() {
        OMElement serverBinarySecret = null;
        String serverBinarySecretText = null;
        byte[] secret = null;
        OMElement serverEntropy = this.getRSTR().getFirstChildWithName(this.trustProperties.ENTROPY);
        if (serverEntropy != null && (serverBinarySecret = serverEntropy.getFirstChildWithName(this.trustProperties.BINARYSECRET)) != null && (serverBinarySecretText = serverBinarySecret.getText()) != null) {
            secret = Base64.decode(serverBinarySecretText);
        }
        return secret;
    }

    @Override
    public String getAppliesToAddress() {
        return this.getElementEPRChild(this.trustProperties.APPLIESTO, this.trustProperties.ADDRESS);
    }

    @Override
    public Boolean getRenewingAllow() {
        String renewingeAllow = null;
        OMElement renewingElement = this.getRSTR().getFirstChildWithName(this.trustProperties.RENEWING);
        if (renewingElement != null) {
            renewingeAllow = renewingElement.getAttributeValue(this.trustProperties.ALLOW);
        }
        return this.constructBoolean(renewingeAllow);
    }

    Boolean constructBoolean(String setting) {
        String value;
        Boolean returnValue = false;
        if (setting != null && ("true".equalsIgnoreCase(value = setting.trim()) || "1".equals(value))) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public Boolean getRenewingOK() {
        String renewableOK = null;
        OMElement renewingElement = this.getRSTR().getFirstChildWithName(this.trustProperties.RENEWING);
        if (renewingElement != null) {
            renewableOK = renewingElement.getAttributeValue(this.trustProperties.OK);
        }
        return this.constructBoolean(renewableOK);
    }

    @Override
    public OMElement getRequestedTokenCancelled() {
        return this.getRSTR().getFirstChildWithName(this.trustProperties.REQUESTEDTOKENCANCELLED);
    }

    @Override
    public OMElement getRequestedSecurityTokenXML() {
        QName uri = new QName("", "URI");
        OMElement token = this.getElement(this.trustProperties.REQUESTEDSECURITYTOKEN);
        OMElement element = TokenDereferenceUtils.lookupTokenReference(token, this.getHeader(), "wsse", uri);
        return element;
    }

    @Override
    public OMElement getRequestedProofToken() {
        QName uri = new QName("", "URI");
        OMElement token = this.getElement(this.trustProperties.REQUESTEDPROOFTOKEN);
        OMElement element = TokenDereferenceUtils.lookupTokenReference(token, this.getHeader(), "wsse", uri);
        return element;
    }

    public Boolean isTokenCancelled() {
        Boolean isCancelled = false;
        OMElement isCancelledElement = this.getRSTR().getFirstChildWithName(this.trustProperties.REQUESTEDTOKENCANCELLED);
        if (isCancelledElement != null) {
            isCancelled = true;
        }
        return isCancelled;
    }

    @Override
    public String getStatusCode() {
        return this.getElementChildText(this.trustProperties.STATUS, this.trustProperties.CODE);
    }

    @Override
    public String getStatusReason() {
        return this.getElementChildText(this.trustProperties.STATUS, this.trustProperties.REASON);
    }

    @Override
    public Boolean getAllowPostdating() {
        boolean value = this.getElement(this.trustProperties.ALLOWPOSTDATING) != null;
        return new Boolean(value);
    }

    @Override
    public String getAuthenticationType() {
        return this.getElementText(this.trustProperties.AUTHENTICATIONTYPE);
    }

    @Override
    public String getCombindedHash() {
        return this.getElementChildText(this.trustProperties.AUTHENTICATOR, this.trustProperties.COMBINEDHASH);
    }

    @Override
    public String getCanonicalizationAlgorithm() {
        return this.getElementText(this.trustProperties.CANONICALIZATIONALGORITHM);
    }

    @Override
    public String getDelegatable() {
        return this.getElementText(this.trustProperties.DELEGATABLE);
    }

    @Override
    public String getEncryptWith() {
        return this.getElementText(this.trustProperties.ENCRYPTWITH);
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.getElementText(this.trustProperties.ENCRYPTIONALGORITHM);
    }

    @Override
    public String getForwardable() {
        return this.getElementText(this.trustProperties.FORWARDABLE);
    }

    @Override
    public String getKeyType() {
        return this.getElementText(this.trustProperties.KEYTYPE);
    }

    @Override
    public OMElement getProofEncryptionXML() {
        QName uri = new QName("", "URI");
        OMElement proof = this.getElementChild(this.trustProperties.PROOFENCRYPTION);
        OMElement element = TokenDereferenceUtils.resolveReference(proof, this.getHeader(), "wsse", uri);
        return element;
    }

    @Override
    public OMElement getEncryptionXML() {
        QName uri = new QName("", "URI");
        OMElement encryption = this.getElementChild(this.trustProperties.ENCRYPTION);
        OMElement element = TokenDereferenceUtils.resolveReference(encryption, this.getHeader(), "wsse", uri);
        return element;
    }

    @Override
    public String getRequestType() {
        return this.getElementText(this.trustProperties.REQUESTTYPE);
    }

    @Override
    public String getSignWith() {
        return this.getElementText(this.trustProperties.SIGNWITH);
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.getElementText(this.trustProperties.SIGNATUREALGORITHM);
    }

    @Override
    public String getTokenType() {
        return this.getElementText(this.trustProperties.TOKENTYPE);
    }

    @Override
    public String getIssuerAddress() {
        return this.getElementChildText(this.trustProperties.ISSUER, this.trustProperties.ADDRESS);
    }

    @Override
    public String getAppliesToPortType() {
        return this.getElementEPRChild(this.trustProperties.APPLIESTO, this.trustProperties.PORTTYPE);
    }

    @Override
    public String getAppliesToServiceName() {
        return this.getElementEPRChild(this.trustProperties.APPLIESTO, this.trustProperties.SERVICENAME);
    }

    @Override
    public String getIssuerPortType() {
        return this.getElementChildText(this.trustProperties.ISSUER, this.trustProperties.PORTTYPE);
    }

    @Override
    public String getIssuerServiceName() {
        return this.getElementChildText(this.trustProperties.ISSUER, this.trustProperties.SERVICENAME);
    }

    @Override
    public OMElement getRequestedAttachedReference() {
        return this.getElement(this.trustProperties.REQUESTEDATTACHEDREFERENCE);
    }

    @Override
    public OMElement getRequestedUnattachedReference() {
        return this.getElement(this.trustProperties.REQUESTEDUNATTACHEDREFERENCE);
    }
}

