/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.util.OMElementUtil;
import com.ibm.ws.wssecurity.trust.ext.client.util.TrustOMFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.description.AxisService;

public class TrustRequestSecurityTokenCollection
implements ITrustRequestSecurityTokenCollection {
    private static final TraceComponent tc = Tr.register(TrustRequestSecurityTokenCollection.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected TrustProperties trustProperties = null;
    PolicySetConfiguration psc = null;
    private ArrayList<ITrustRequestSecurityToken> rstList = new ArrayList();

    public TrustRequestSecurityTokenCollection(TrustProperties trustProperties, ITrustRequestSecurityToken rst) throws SoapSecurityException {
        this.trustProperties = trustProperties;
        this.validateRST(rst);
        this.rstList.add(rst);
    }

    public TrustRequestSecurityTokenCollection(TrustProperties trustProperties, List<ITrustRequestSecurityToken> list) throws SoapSecurityException {
        this.trustProperties = trustProperties;
        for (ITrustRequestSecurityToken rst : list) {
            this.addTrustRequestSecurityToken(rst);
        }
    }

    @Override
    public void addTrustRequestSecurityToken(ITrustRequestSecurityToken rst) throws SoapSecurityException {
        this.validateRST(rst);
        this.rstList.add(rst);
    }

    public void clearList() {
        this.rstList.clear();
    }

    @Override
    public List<ITrustRequestSecurityToken> getList() {
        return this.rstList;
    }

    @Override
    public ITrustRequestSecurityToken getRequestSecurityToken(int index) {
        ITrustRequestSecurityToken rst = null;
        if (index < this.size()) {
            rst = this.rstList.get(index);
        }
        return rst;
    }

    @Override
    public int size() {
        return this.rstList.size();
    }

    @Override
    public void validateRST(ITrustRequestSecurityToken rst) throws SoapSecurityException {
        if (this.size() == 0) {
            if (rst.getAction() == null) {
                throw SoapSecurityException.format("security.wssecurity.trust.client.rstc.action", "null");
            }
        } else {
            OMElement to0 = this.getTo();
            OMElement to = rst.getTo();
            if (to != null && !OMElementUtil.compareQName(to, to0)) {
                throw SoapSecurityException.format("security.wssecurity.trust.client.rstc.provider", to.getText());
            }
            OMElement action0 = this.getAction();
            OMElement action = rst.getAction();
            if (action != null && !OMElementUtil.compareQName(action0, action)) {
                throw SoapSecurityException.format("security.wssecurity.trust.client.rstc.action", action.getText());
            }
            boolean found = false;
            List<OMElement> other0 = this.getOtherHeaders();
            List<OMElement> other = rst.getOtherHeaders();
            if (other != null && other.size() > 0) {
                for (OMElement header : other) {
                    for (OMElement header0 : other0) {
                        if (!OMElementUtil.compareQName(header, header0)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw SoapSecurityException.format("security.wssecurity.trust.client.rstc.header", header.getLocalName());
                }
            }
        }
    }

    @Override
    public OMElement getTo() {
        OMElement to = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            to = rst.getTo();
        }
        return to;
    }

    @Override
    public OMElement getMessageID() {
        OMElement messageID = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            messageID = rst.getMessageID();
        }
        return messageID;
    }

    @Override
    public OMElement getAction() {
        OMElement action = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            action = rst.getAction();
        }
        return action;
    }

    @Override
    public OMElement getBody() {
        OMElement body = null;
        if (this.size() > 0) {
            body = TrustOMFactory.createOMElement(this.trustProperties.REQUESTSECURITYTOKENCOLLECTION);
            for (ITrustRequestSecurityToken rst : this.rstList) {
                OMElement request = rst.getBody();
                body.addChild(request);
            }
        }
        return body;
    }

    @Override
    public List<OMElement> getOtherHeaders() {
        List<OMElement> headers = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            headers = rst.getOtherHeaders();
        }
        return headers;
    }

    @Override
    public Stub getSecurityTokenServiceStub() {
        Stub stub = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            stub = rst.getSecurityTokenServiceStub();
        }
        return stub;
    }

    @Override
    public AxisService getAxisService() {
        AxisService axisSerice = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            axisSerice = rst.getAxisService();
        }
        return axisSerice;
    }

    @Override
    public ServiceClient getServiceClient() {
        ServiceClient serviceClient = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            serviceClient = rst.getServiceClient();
        }
        return serviceClient;
    }

    public void setContextURI(String contextURI) {
    }

    @Override
    public SOAPEnvelope getEnvelope(SOAPFactory factory) {
        SOAPEnvelope env = null;
        if (this.size() > 0) {
            ITrustRequestSecurityToken rst = this.getRequestSecurityToken(0);
            env = rst.getEnvelope(factory);
        }
        return env;
    }

    @Override
    public void setPSC(PolicySetConfiguration psc) {
        this.psc = psc;
    }

    @Override
    public PolicySetConfiguration getPSC() {
        return this.psc;
    }
}

