/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.ws.wssecurity.trust.ext.client.ITrustProviderConfig;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.util.OMElementUtil;
import com.ibm.ws.wssecurity.trust.ext.client.util.TrustOMFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;

public abstract class TrustFormatter
implements WSSConstants {
    private static final TraceComponent tc = Tr.register(TrustFormatter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected TrustProperties trustProperties = null;

    public static OMElement createBST(QName qnTopElement, TrustProperties trustProperties, String bst) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBST");
        }
        OMElement omTopElement = TrustOMFactory.createOMElement(qnTopElement);
        if (TrustFormatter.isSet(bst)) {
            OMElement omBinarySecurityToken = TrustOMFactory.createOMElement(trustProperties.BINARYSECURITYTOKEN);
            omBinarySecurityToken.setText(bst);
            omTopElement.addChild(omBinarySecurityToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBST");
        }
        return omTopElement;
    }

    public static OMElement createEPR(QName qnTopElement, TrustProperties trustProperties, String address, String serviceName, String portType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEPR");
        }
        OMElement endpointReference = TrustOMFactory.createOMElement(trustProperties.ENDPOINTREFERENCE);
        if (TrustFormatter.isSet(address)) {
            OMElement addressElement = TrustOMFactory.createOMElementWithText(address, trustProperties.ADDRESS);
            endpointReference.addChild(addressElement);
        }
        if (TrustFormatter.isSet(serviceName)) {
            OMElement serviceNameElement = TrustOMFactory.createOMElementWithText(serviceName, trustProperties.SERVICENAME);
            endpointReference.addChild(serviceNameElement);
        }
        if (TrustFormatter.isSet(portType)) {
            OMElement portTypeElement = TrustOMFactory.createOMElementWithText(portType, trustProperties.PORTTYPE);
            endpointReference.addChild(portTypeElement);
        }
        OMElement omTopElement = TrustOMFactory.createOMElement(qnTopElement);
        omTopElement.addChild(endpointReference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEPR");
        }
        return omTopElement;
    }

    public static OMElement createEPR2(QName qnTopElement, TrustProperties trustProperties, String address, String serviceName, String portType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEPR2");
        }
        OMElement omTopElement = TrustOMFactory.createOMElement(qnTopElement);
        if (TrustFormatter.isSet(address)) {
            OMElement addressElement = TrustOMFactory.createOMElementWithText(address, trustProperties.ADDRESS);
            omTopElement.addChild(addressElement);
        }
        if (TrustFormatter.isSet(serviceName)) {
            OMElement serviceNameElement = TrustOMFactory.createOMElementWithText(serviceName, trustProperties.SERVICENAME);
            omTopElement.addChild(serviceNameElement);
        }
        if (TrustFormatter.isSet(portType)) {
            OMElement portTypeElement = TrustOMFactory.createOMElementWithText(portType, trustProperties.PORTTYPE);
            omTopElement.addChild(portTypeElement);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEPR2");
        }
        return omTopElement;
    }

    public static OMElement createSTREmbedded(QName qnTopElement, TrustProperties trustProperties, String ID2, String embedded) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTREmbedded");
        }
        OMElement omTopElement = TrustOMFactory.createOMElement(qnTopElement);
        OMElement omSecurityTokenReference = TrustOMFactory.createOMElement(trustProperties.SECURITYTOKENREFERENCE);
        OMElement omEmbedded = TrustOMFactory.createOMElement(trustProperties.EMBEDDED);
        if (TrustFormatter.isSet(ID2)) {
            OMAttribute omURI = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.ID, ID2);
            omEmbedded.addAttribute(omURI);
        }
        if (TrustFormatter.isSet(embedded)) {
            omEmbedded.setText(embedded);
        }
        omSecurityTokenReference.addChild(omEmbedded);
        omTopElement.addChild(omSecurityTokenReference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTREmbedded");
        }
        return omTopElement;
    }

    public static OMElement createSTREmbeddedBST(QName qnTopElement, TrustProperties trustProperties, String embeddedid, String bst, String bstid, String valuetype, String encodingtype) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTREmbeddedBST");
        }
        OMElement omTopElement = TrustOMFactory.createOMElement(qnTopElement);
        OMElement omSecurityTokenReference = TrustOMFactory.createOMElement(trustProperties.SECURITYTOKENREFERENCE);
        OMElement omEmbedded = TrustOMFactory.createOMElement(trustProperties.EMBEDDED);
        if (TrustFormatter.isSet(embeddedid)) {
            OMAttribute omID = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.ID, embeddedid);
            omEmbedded.addAttribute(omID);
        }
        OMElement omBinarySecurityToken = TrustOMFactory.createOMElement(trustProperties.BINARYSECURITYTOKEN);
        if (TrustFormatter.isSet(bst)) {
            omBinarySecurityToken.setText(bst);
        }
        if (TrustFormatter.isSet(bstid)) {
            OMAttribute omID = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.ID, bstid);
            omBinarySecurityToken.addAttribute(omID);
        }
        if (TrustFormatter.isSet(valuetype)) {
            OMAttribute omValueType = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.VALUETYPE, valuetype);
            omBinarySecurityToken.addAttribute(omValueType);
        }
        if (TrustFormatter.isSet(encodingtype)) {
            OMAttribute omEncodingType = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.ENCODINGTYPE, encodingtype);
            omBinarySecurityToken.addAttribute(omEncodingType);
        }
        omEmbedded.addChild(omBinarySecurityToken);
        omSecurityTokenReference.addChild(omEmbedded);
        omTopElement.addChild(omSecurityTokenReference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTREmbeddedBST");
        }
        return omTopElement;
    }

    public static OMElement createSTRKeyIdentifier(QName qnTopElement, TrustProperties trustProperties, String keyIdentifier, String encodingType, String valueType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTRKeyIdentifier");
        }
        OMElement omTopElement = TrustOMFactory.createOMElement(qnTopElement);
        OMElement omSecurityTokenReference = TrustOMFactory.createOMElement(trustProperties.SECURITYTOKENREFERENCE);
        OMElement omKeyIdentifier = TrustOMFactory.createOMElement(trustProperties.KEYIDENTIFIER);
        if (TrustFormatter.isSet(keyIdentifier)) {
            omKeyIdentifier.setText(keyIdentifier);
        }
        if (TrustFormatter.isSet(encodingType)) {
            OMAttribute omEncodingType = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.ENCODINGTYPE, encodingType);
            omKeyIdentifier.addAttribute(omEncodingType);
        }
        if (TrustFormatter.isSet(valueType)) {
            OMAttribute omValueType = TrustOMFactory.createOMAttributeBlankNamespace(trustProperties.VALUETYPE, valueType);
            omKeyIdentifier.addAttribute(omValueType);
        }
        omSecurityTokenReference.addChild(omKeyIdentifier);
        omTopElement.addChild(omSecurityTokenReference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTRKeyIdentifier");
        }
        return omTopElement;
    }

    public static OMElement formatTo(TrustProperties trustProperties, ITrustProviderConfig providerConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatTo");
        }
        OMElement omElement = null;
        String to = providerConfig.getProvider();
        if (TrustFormatter.isSet(to)) {
            omElement = TrustOMFactory.createOMElementWithText(to, trustProperties.TO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatTo");
        }
        return omElement;
    }

    protected TrustFormatter(TrustProperties trustProperties) {
        this.trustProperties = trustProperties;
    }

    public OMElement formatAction(ITrustRequesterConfig request) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatAction");
        }
        OMElement omElement = null;
        String action = request.getAction();
        if (TrustFormatter.isSet(action)) {
            omElement = TrustOMFactory.createOMElementWithText(request.getAction(), this.trustProperties.ACTION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatAction");
        }
        return omElement;
    }

    public OMElement formatAllowPostdating(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatAllowPostdating");
        }
        OMElement omElement = null;
        String allow = settings.get("wstrustClientAllowPostdating");
        if (this.isSetTrue(allow)) {
            omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.ALLOWPOSTDATING);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatAllowPostdating");
        }
        return omElement;
    }

    public OMElement formatAppliesTo(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatAppliesTo");
        }
        OMElement omElement = null;
        String address = settings.get("wstrustClientAppliesToAddress");
        String serviceName = settings.get("wstrustClientAppliesToServiceName");
        String portType = settings.get("wstrustClientAppliesToPortType");
        if (TrustFormatter.isSet(address) || TrustFormatter.isSet(serviceName) || TrustFormatter.isSet(portType)) {
            omElement = TrustFormatter.createEPR(this.trustProperties.APPLIESTO, this.trustProperties, address, serviceName, portType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatAppliesTo");
        }
        return omElement;
    }

    protected static boolean isSet(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSet");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSet");
        }
        return value != null && !value.equals("");
    }

    protected static boolean isSet(List<String> list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSet");
        }
        boolean rc = false;
        if (list != null && !list.isEmpty()) {
            for (String item : list) {
                if (!TrustFormatter.isSet(item)) continue;
                rc = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSet");
        }
        return rc;
    }

    public OMElement formatAuthenticationType(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatAuthenticationType");
        }
        OMElement omElement = null;
        String type = settings.get("wstrustClientAuthenticationType");
        if (TrustFormatter.isSet(type)) {
            omElement = TrustOMFactory.createOMElementWithText(type, this.trustProperties.AUTHENTICATIONTYPE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatAuthenticationType");
        }
        return omElement;
    }

    public OMElement formatCanonicalizationAlgorithm(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatCanonicalizationAlgorithm");
        }
        OMElement omElement = null;
        String algorithm = settings.get("wstrustClientCanonicalizationAlgorithm");
        if (TrustFormatter.isSet(algorithm)) {
            omElement = TrustOMFactory.createOMElementWithText(algorithm, this.trustProperties.CANONICALIZATIONALGORITHM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatCanonicalizationAlgorithm");
        }
        return omElement;
    }

    public OMElement formatClaimType(Map<String, String> settings, List<String> requiredClaimTypeList, List<String> optionalClaimTypeList) throws SoapSecurityException {
        String dialect;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatClaimType");
        }
        OMElement omElement = null;
        OMElement omClaimType = null;
        OMAttribute omDialect = null;
        OMAttribute omURI = null;
        String claims = settings.get("wstrustClientClaims");
        if (TrustFormatter.isSet(claims)) {
            omElement = TrustOMFactory.createOMElementWithText(claims, this.trustProperties.CLAIMS);
        } else {
            boolean requiredClaimTypeListSet = TrustFormatter.isSet(requiredClaimTypeList);
            boolean optionalClaimTypeListSet = TrustFormatter.isSet(optionalClaimTypeList);
            if (requiredClaimTypeListSet || optionalClaimTypeListSet) {
                omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.CLAIMS);
                if (requiredClaimTypeListSet) {
                    for (String uri : requiredClaimTypeList) {
                        if (!TrustFormatter.isSet(uri)) continue;
                        omClaimType = TrustOMFactory.createOMElementNoText(this.trustProperties.CLAIMTYPE);
                        omURI = TrustOMFactory.createOMAttributeBlankNamespace(this.trustProperties.URI, uri);
                        omClaimType.addAttribute(omURI);
                        omElement.addChild(omClaimType);
                    }
                }
                if (optionalClaimTypeListSet) {
                    OMAttribute omOptional = TrustOMFactory.createOMAttributeBlankNamespace(this.trustProperties.OPTIONAL, "true");
                    for (String uri : optionalClaimTypeList) {
                        if (!TrustFormatter.isSet(uri)) continue;
                        omClaimType = TrustOMFactory.createOMElementNoText(this.trustProperties.CLAIMTYPE);
                        omClaimType.addAttribute(omOptional);
                        omURI = TrustOMFactory.createOMAttributeBlankNamespace(this.trustProperties.URI, uri);
                        omClaimType.addAttribute(omURI);
                        omElement.addChild(omClaimType);
                    }
                }
            }
        }
        if (omElement != null && TrustFormatter.isSet(dialect = settings.get("wstrustClientClaimsDialect"))) {
            omDialect = TrustOMFactory.createOMAttributeBlankNamespace(dialect, this.trustProperties.DIALECT);
            omElement.addAttribute(omDialect);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatClaimType");
        }
        return omElement;
    }

    public OMElement formatComputedKeyAlgorithm(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatComputedKeyAlgorithm");
        }
        OMElement omElement = null;
        String algorithm = settings.get("wstrustClientComputedKeyAlgorithm");
        if (TrustFormatter.isSet(algorithm)) {
            omElement = TrustOMFactory.createOMElementWithText(algorithm, this.trustProperties.COMPUTEDKEYALGORITHM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatComputedKeyAlgorithm");
        }
        return omElement;
    }

    public OMAttribute formatContext(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatContext");
        }
        OMAttribute omAttribute = null;
        String context = settings.get("wstrustClientContext");
        if (TrustFormatter.isSet(context)) {
            omAttribute = TrustOMFactory.createOMAttribute(context, this.trustProperties.CONTEXT);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatContext");
        }
        return omAttribute;
    }

    public OMElement formatDelegatable(Map<String, String> settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatDelegatable");
        }
        OMElement omElement = null;
        String delegatable = settings.get("wstrustClientDelegatable");
        if (this.isSetBoolean(delegatable)) {
            omElement = TrustOMFactory.createOMElementWithText(delegatable, this.trustProperties.DELEGATABLE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatDelegatable");
        }
        return omElement;
    }

    public OMElement formatEncryptionAlgorithm(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatEncryptionAlgorithm");
        }
        OMElement omElement = null;
        String algorithm = settings.get("wstrustClientEncryptionAlgorithm");
        if (TrustFormatter.isSet(algorithm)) {
            omElement = TrustOMFactory.createOMElementWithText(algorithm, this.trustProperties.ENCRYPTIONALGORITHM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatEncryptionAlgorithm");
        }
        return omElement;
    }

    public OMElement formatEncryptWith(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatEncryptWith");
        }
        OMElement omElement = null;
        String encryptWith = settings.get("wstrustClientEncryptWith");
        if (TrustFormatter.isSet(encryptWith)) {
            omElement = TrustOMFactory.createOMElementWithText(encryptWith, this.trustProperties.ENCRYPTWITH);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatEncryptWith");
        }
        return omElement;
    }

    public OMElement formatEntropy_BinarySecret(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatEntropy_BinarySecret");
        }
        OMElement omElement = null;
        String binarySecret = settings.get("wstrustClientEntropyBinarySecret");
        String type = settings.get("wstrustClientEntropyBinarySecretType");
        if (TrustFormatter.isSet(binarySecret)) {
            omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.ENTROPY);
            OMElement omBinarySecret = TrustOMFactory.createOMElementWithText(binarySecret, this.trustProperties.BINARYSECRET);
            if (TrustFormatter.isSet(type)) {
                OMAttribute omType = TrustOMFactory.createOMAttributeBlankNamespace("Type", type);
                omBinarySecret.addAttribute(omType);
            }
            omElement.addChild(omBinarySecret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatEntropy_BinarySecret");
        }
        return omElement;
    }

    public OMElement formatEntropy_EncryptedKey(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatEntropy_EncryptedKey");
        }
        OMElement omEntropy = null;
        String algorithm = settings.get("wstrustClientEntropyEncryptedKeyAlgorithm");
        String cipher = settings.get("wstrustClientEntropyEncryptedKeyCipherValue");
        if (TrustFormatter.isSet(algorithm) && TrustFormatter.isSet(cipher)) {
            omEntropy = TrustOMFactory.createOMElementNoText(this.trustProperties.ENTROPY);
            OMElement omEncryptedKey = TrustOMFactory.createOMElementNoText(this.trustProperties.ENCRYPTEDKEY);
            OMElement omEncryptionMethod = TrustOMFactory.createOMElementNoText(this.trustProperties.ENCRYPTIONMETHOD);
            OMAttribute omAlgorithm = TrustOMFactory.createOMAttributeBlankNamespace(this.trustProperties.ALGORITHM, algorithm);
            omEncryptionMethod.addAttribute(omAlgorithm);
            OMElement omCipherData = TrustOMFactory.createOMElementNoText(this.trustProperties.CIPHERDATA);
            OMElement omCipherValue = TrustOMFactory.createOMElementWithText(cipher, this.trustProperties.CIPHERVALUE);
            omCipherData.addChild(omCipherValue);
            omEncryptionMethod.addChild(omCipherData);
            omEncryptedKey.addChild(omEncryptionMethod);
            omEntropy.addChild(omEncryptedKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatEntropy_EncryptedKey");
        }
        return omEntropy;
    }

    public OMElement formatForwardable(Map<String, String> settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatForwardable");
        }
        OMElement omElement = null;
        String forwardable = settings.get("wstrustClientForwardable");
        if (TrustFormatter.isSet(forwardable)) {
            if (this.isSetBoolean(forwardable)) {
                omElement = TrustOMFactory.createOMElementWithText(forwardable, this.trustProperties.FORWARDABLE);
            } else {
                throw SoapSecurityException.format("security.wssecurity.trust.client.setting", "wstrustClientForwardable", forwardable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatForwardable");
        }
        return omElement;
    }

    public OMElement formatIssuer_EPR(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatIssuer_EPR");
        }
        OMElement omElement = null;
        String address = settings.get("wstrustClientIssuerAddress");
        String serviceName = settings.get("wstrustClientIssuerServiceName");
        String portType = settings.get("wstrustClientIssuerPortType");
        if (TrustFormatter.isSet(address) || TrustFormatter.isSet(serviceName) || TrustFormatter.isSet(portType)) {
            omElement = TrustFormatter.createEPR2(this.trustProperties.ISSUER, this.trustProperties, address, serviceName, portType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatIssuer_EPR");
        }
        return omElement;
    }

    public OMElement formatKeySize(Map<String, String> settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatKeySize");
        }
        OMElement omElement = null;
        String keySize = settings.get("wstrustClientKeySize");
        if (TrustFormatter.isSet(keySize)) {
            int size = 0;
            try {
                size = Integer.parseInt(keySize);
            }
            catch (Throwable e) {
                throw SoapSecurityException.format("security.wssecurity.trust.client.setting", "wstrustClientKeySize", keySize);
            }
            if (size < 0) {
                throw SoapSecurityException.format("security.wssecurity.trust.client.setting", "wstrustClientKeySize", keySize);
            }
            omElement = TrustOMFactory.createOMElementWithText(keySize, this.trustProperties.KEYSIZE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatKeySize");
        }
        return omElement;
    }

    public OMElement formatKeyType(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatKeyType");
        }
        OMElement omElement = null;
        String keyType = settings.get("wstrustClientKeyType");
        if (TrustFormatter.isSet(keyType)) {
            omElement = TrustOMFactory.createOMElementWithText(keyType, this.trustProperties.KEYTYPE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatKeyType");
        }
        return omElement;
    }

    public OMElement formatLifetime(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatLifetime");
        }
        OMElement omElement = null;
        String created = settings.get("wstrustClientLifetimeCreated");
        String expires = settings.get("wstrustClientLifetimeExpires");
        if (TrustFormatter.isSet(created) || TrustFormatter.isSet(expires)) {
            omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.LIFETIME);
            if (TrustFormatter.isSet(created)) {
                OMElement omCreated = TrustOMFactory.createOMElementWithText(created, this.trustProperties.CREATED);
                omElement.addChild(omCreated);
            }
            if (TrustFormatter.isSet(expires)) {
                OMElement omExpires = TrustOMFactory.createOMElementWithText(expires, this.trustProperties.EXPIRES);
                omElement.addChild(omExpires);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatLifetime");
        }
        return omElement;
    }

    public OMElement formatMessageID(ITrustRequesterConfig request) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatMessageID");
        }
        OMElement omElement = null;
        String id = request.getMessageID();
        if (TrustFormatter.isSet(id)) {
            omElement = TrustOMFactory.createOMElementWithText(id, this.trustProperties.MESSAGEID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatMessageID");
        }
        return omElement;
    }

    public OMElement formatPolicyReference(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatPolicyReference");
        }
        OMElement omElement = null;
        String reference = settings.get("wstrustClientPolicyReferenceURI");
        if (TrustFormatter.isSet(reference)) {
            omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.POLICYREFERENCE);
            OMAttribute omURI = TrustOMFactory.createOMAttributeBlankNamespace(reference, this.trustProperties.URI);
            omElement.addAttribute(omURI);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatPolicyReference");
        }
        return omElement;
    }

    public OMElement formatBase(Map<String, String> settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatPolicyReference");
        }
        OMElement omElement = null;
        String str = settings.get("wstrustClientExtensionBase");
        try {
            if (TrustFormatter.isSet(str)) {
                omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.BASE);
                OMElement omSTR = OMElementUtil.toOMElement(str);
                omElement.addChild(omSTR);
            }
        }
        catch (Throwable e) {
            Tr.debug(tc, "formatBase: " + e.getMessage());
            throw SoapSecurityException.format("security.wssecurity.trust.client.setting", "wstrustClientExtensionBase");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatPolicyReference");
        }
        return omElement;
    }

    public OMElement formatRenewing(Map<String, String> settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatRenewing");
        }
        OMElement omElement = null;
        String allow = settings.get("wstrustClientRenewingAllow");
        String ok = settings.get("wstrustClientRenewingOK");
        if (TrustFormatter.isSet(allow) || TrustFormatter.isSet(ok)) {
            omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.RENEWING);
            if (TrustFormatter.isSet(allow)) {
                if (!this.isSetBoolean(allow)) {
                    throw SoapSecurityException.format("security.wssecurity.trust.client.setting", "wstrustClientRenewingAllow", allow);
                }
                OMAttribute omAllow = TrustOMFactory.createOMAttributeBlankNamespace("Allow", allow);
                omElement.addAttribute(omAllow);
            }
            if (TrustFormatter.isSet(ok)) {
                if (!this.isSetBoolean(ok)) {
                    throw SoapSecurityException.format("security.wssecurity.trust.client.setting", "wstrustClientRenewingOK", ok);
                }
                OMAttribute omOK = TrustOMFactory.createOMAttributeBlankNamespace("OK", ok);
                omElement.addAttribute(omOK);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatRenewing");
        }
        return omElement;
    }

    public OMElement formatRequestType(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatRequestType");
        }
        OMElement omElement = null;
        String type = settings.get("RequestType");
        if (TrustFormatter.isSet(type)) {
            omElement = TrustOMFactory.createOMElementWithText(type, this.trustProperties.REQUESTTYPE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatRequestType");
        }
        return omElement;
    }

    public OMElement formatSignatureAlgorithm(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatSignatureAlgorithm");
        }
        OMElement omElement = null;
        String algorithm = settings.get("wstrustClientSignatureAlgorithm");
        if (TrustFormatter.isSet(algorithm)) {
            omElement = TrustOMFactory.createOMElementWithText(algorithm, this.trustProperties.SIGNATUREALGORITHM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatSignatureAlgorithm");
        }
        return omElement;
    }

    public OMElement formatSignWith(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatSignWith");
        }
        OMElement omElement = null;
        String signWith = settings.get("wstrustClientSignWith");
        if (TrustFormatter.isSet(signWith)) {
            omElement = TrustOMFactory.createOMElementWithText(signWith, this.trustProperties.SIGNWITH);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatSignWith");
        }
        return omElement;
    }

    public OMElement formatTokenType(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatTokenType");
        }
        OMElement omElement = null;
        String tokenType = settings.get("wstrustClientTokenType");
        if (TrustFormatter.isSet(tokenType)) {
            omElement = TrustOMFactory.createOMElementWithText(tokenType, this.trustProperties.TOKENTYPE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatTokenType");
        }
        return omElement;
    }

    public OMElement formatValidateTarget_STR(Map<String, String> settings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatValidateTarget_STR");
        }
        OMElement omElement = null;
        String uri = settings.get("wstrustClientValidateTargetReferenceURI");
        String valueType = settings.get("wstrustClientValidateTargetReferenceValuteType");
        if (TrustFormatter.isSet(uri) || TrustFormatter.isSet(valueType)) {
            omElement = TrustOMFactory.createOMElementNoText(this.trustProperties.VALIDATETARGET);
            OMElement omSTR = TrustOMFactory.createOMElementNoText(this.trustProperties.SECURITYTOKENREFERENCE);
            OMElement omReference = TrustOMFactory.createOMElementNoText(this.trustProperties.REFERENCE);
            if (TrustFormatter.isSet(uri)) {
                OMAttribute omURI = TrustOMFactory.createOMAttributeBlankNamespace("URI", uri);
                omReference.addAttribute(omURI);
            }
            if (TrustFormatter.isSet(valueType)) {
                OMAttribute omValueType = TrustOMFactory.createOMAttributeBlankNamespace("ValueType", valueType);
                omReference.addAttribute(omValueType);
            }
            omSTR.addChild(omReference);
            omElement.addChild(omSTR);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatValidateTarget_STR");
        }
        return omElement;
    }

    protected boolean isSetTrue(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSetTrue");
        }
        boolean rc = false;
        if (value != null) {
            rc = value.trim().equalsIgnoreCase("true");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSetTrue");
        }
        return rc;
    }

    protected boolean isSetBoolean(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSetBoolean");
        }
        boolean rc = false;
        if (value != null) {
            boolean bl = rc = value.trim().equals("true") || value.trim().equals("false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSetBoolean");
        }
        return rc;
    }
}

