/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.ext.client.base;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.trust.WSSTrustClientValidateResult;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.TrustClientPolicySetAttachments;
import com.ibm.ws.wssecurity.platform.util.ConfigHelperFactory;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustProviderConfig;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustDispatchResponse;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustFormatter;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustSecurityTokenServiceDispatch;
import com.ibm.ws.wssecurity.trust.ext.client.util.OMElementUtil;
import com.ibm.ws.wssecurity.trust.ext.client.util.TrustClientHelperUtils;
import com.ibm.ws.wssecurity.trust.ext.client.util.TrustClientPSUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;

public abstract class TrustClient
implements ITrustClient {
    private static final TraceComponent tc = Tr.register(TrustClient.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final SecurityPermission ISSUE_TOKEN_PERM = new SecurityPermission("wssapi.TrustClient.issue");

    @Override
    public abstract ITrustRequestSecurityTokenTemplate getRequestSecurityTokenTemplate(ITrustRequesterConfig var1) throws SoapSecurityException;

    protected TrustDispatchResponse send0(ITrustRequestSecurityToken rst, ITrustProviderConfig trustProviderConfig, TrustProperties trustProperties, PolicySetConfiguration psc, ITrustRequesterConfig requestConfig) throws SoapSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ... ");
                Tr.debug(tc, "Expecting : " + ISSUE_TOKEN_PERM.toString());
            }
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        TrustDispatchResponse dispatchResponse = null;
        Object response = null;
        OMElement to = TrustFormatter.formatTo(this.getTrustProperties(), trustProviderConfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "To: " + to);
        }
        OMElement messageID = rst.getMessageID();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageID: " + messageID);
        }
        OMElement action = rst.getAction();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Action: " + action);
        }
        List<OMElement> otherHeaders = rst.getOtherHeaders();
        OMElement request = rst.getBody();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "body: " + request);
        }
        try {
            dispatchResponse = TrustSecurityTokenServiceDispatch.requestSecurityToken(to, messageID, action, otherHeaders, request, psc, trustProperties, trustProviderConfig, requestConfig);
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requeset Failed: " + e.getMessage());
                Tr.debug(tc, OMElementUtil.stackTrace(e));
            }
            throw SoapSecurityException.format("security.wssecurity.trust.client.requestfalied", trustProviderConfig.getProvider(), e);
        }
        if (dispatchResponse == null || dispatchResponse.getRSTR() == null) {
            String errorMessage = "invalid response";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMessage + ": serviceStub.RequestSecurityToken() returned null");
            }
            throw SoapSecurityException.format("security.wssecurity.trust.client.serverresponse");
        }
        dispatchResponse.getRSTR().build();
        return dispatchResponse;
    }

    protected ITrustRequestSecurityTokenResponse sendReceiveRSTR(ITrustRequestSecurityToken rst, ITrustProviderConfig trustProviderConfig, TrustProperties trustProperties, PolicySetConfiguration psc, ITrustRequesterConfig requestConfig) throws SoapSecurityException {
        TrustRequestSecurityTokenResponse rstr = null;
        TrustDispatchResponse dispatchResponse = null;
        dispatchResponse = this.send0(rst, trustProviderConfig, trustProperties, psc, requestConfig);
        rstr = new TrustRequestSecurityTokenResponse(this.getTrustProperties(), dispatchResponse);
        return rstr;
    }

    protected ITrustRequestSecurityTokenResponseCollection sendReceiveRSTRC(ITrustRequestSecurityToken rst, ITrustProviderConfig trustProviderConfig, TrustProperties trustProperties, PolicySetConfiguration psc, ITrustRequesterConfig requestConfig) throws SoapSecurityException {
        TrustRequestSecurityTokenResponseCollection rstrc = null;
        TrustDispatchResponse dispatchResponse = null;
        dispatchResponse = this.send0(rst, trustProviderConfig, trustProperties, psc, requestConfig);
        rstrc = new TrustRequestSecurityTokenResponseCollection(this.getTrustProperties(), dispatchResponse);
        return rstrc;
    }

    public abstract ITrustRequestSecurityToken createRequestSecurityToken(ITrustRequestSecurityTokenTemplate var1);

    @Override
    public abstract ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(ITrustRequestSecurityToken var1) throws SoapSecurityException;

    @Override
    public abstract ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(List<ITrustRequestSecurityToken> var1) throws SoapSecurityException;

    public SecurityToken send(ITrustProviderConfig trustProviderConfig, ITrustRequesterConfig trustRequestConfig, TrustProperties trustProperties) throws SoapSecurityException {
        SecurityToken securityToken = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        if (trustRequestConfig.getMessageID() == null) {
            trustRequestConfig.setMessageID(UUIDGenerator.getUUID());
        }
        ITrustRequestSecurityTokenTemplate rstt = this.getRequestSecurityTokenTemplate(trustRequestConfig);
        try {
            String applicationName;
            PolicySetConfiguration psc;
            ITrustRequestSecurityToken rst;
            block9: {
                rst = this.createRequestSecurityToken(rstt);
                psc = null;
                applicationName = TrustClientPSUtils.getApplicationName(trustProviderConfig);
                if (applicationName == null || applicationName.length() == 0) {
                    try {
                        applicationName = ConfigHelperFactory.getInstance().getApplicationName();
                        if (applicationName == null) {
                            applicationName = "";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Set unspecified applicationName to " + applicationName);
                        }
                    }
                    catch (Throwable t) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Exception caught: " + t.getMessage());
                    }
                }
            }
            TrustClientPolicySetAttachments trustClientAttachment = null;
            trustClientAttachment = TrustClientPSUtils.getTrustClientPolicySetAttachments(applicationName);
            psc = TrustClientHelperUtils.getPSC(trustProviderConfig, trustClientAttachment);
            ITrustRequestSecurityTokenResponse rstr = this.sendReceiveRSTR(rst, trustProviderConfig, trustProperties, psc, trustRequestConfig);
            securityToken = TrustClientHelperUtils.processRSTR(rstr, trustRequestConfig, trustProviderConfig.getIncludeRSTRProperties());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw SoapSecurityException.format(e.getMessage());
        }
        return securityToken;
    }

    public List<SecurityToken> sendList(ITrustProviderConfig trustProviderConfig, List<ITrustRequesterConfig> requestList, TrustProperties trustProperties) throws SoapSecurityException {
        String applicationName;
        PolicySetConfiguration psc;
        ITrustRequestSecurityTokenCollection rstc;
        List<SecurityToken> securityTokens;
        block9: {
            securityTokens = null;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ISSUE_TOKEN_PERM);
            }
            if (requestList.get(0).getMessageID() == null) {
                requestList.get(0).setMessageID(UUIDGenerator.getUUID());
            }
            ArrayList<ITrustRequestSecurityTokenTemplate> rsttList = new ArrayList<ITrustRequestSecurityTokenTemplate>();
            for (ITrustRequesterConfig request : requestList) {
                ITrustRequestSecurityTokenTemplate rstt = this.getRequestSecurityTokenTemplate(request);
                rsttList.add(rstt);
            }
            ArrayList<ITrustRequestSecurityToken> rstList = new ArrayList<ITrustRequestSecurityToken>();
            for (ITrustRequestSecurityTokenTemplate rstt : rsttList) {
                ITrustRequestSecurityToken rst = this.createRequestSecurityToken(rstt);
                rstList.add(rst);
            }
            rstc = this.createRequestSecurityTokenCollection(rstList);
            psc = null;
            applicationName = TrustClientPSUtils.getApplicationName(trustProviderConfig);
            if (applicationName == null || applicationName.length() == 0) {
                try {
                    applicationName = ConfigHelperFactory.getInstance().getApplicationName();
                    if (applicationName == null) {
                        applicationName = "";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set unspecified applicationName to " + applicationName);
                    }
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Exception caught: " + t.getMessage());
                }
            }
        }
        TrustClientPolicySetAttachments trustClientAttachment = null;
        trustClientAttachment = TrustClientPSUtils.getTrustClientPolicySetAttachments(applicationName);
        psc = TrustClientHelperUtils.getPSC(trustProviderConfig, trustClientAttachment);
        ITrustRequestSecurityTokenResponseCollection rstrc = this.sendReceiveRSTRC(rstc, trustProviderConfig, trustProperties, psc, requestList.get(0));
        securityTokens = TrustClientHelperUtils.processRSTRC(rstrc, requestList, trustProviderConfig.getIncludeRSTRProperties());
        return securityTokens;
    }

    public List<SecurityToken> sendList(ITrustProviderConfig trustProviderConfig, ITrustRequesterConfig trustRequestConfig, TrustProperties trustProperties) throws SoapSecurityException {
        String applicationName;
        ITrustRequestSecurityToken rst;
        List<SecurityToken> securityTokens;
        block7: {
            securityTokens = null;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ISSUE_TOKEN_PERM);
            }
            if (trustRequestConfig.getMessageID() == null) {
                trustRequestConfig.setMessageID(UUIDGenerator.getUUID());
            }
            ITrustRequestSecurityTokenTemplate rstt = this.getRequestSecurityTokenTemplate(trustRequestConfig);
            rst = this.createRequestSecurityToken(rstt);
            applicationName = TrustClientPSUtils.getApplicationName(trustProviderConfig);
            if (applicationName == null || applicationName.length() == 0) {
                try {
                    applicationName = ConfigHelperFactory.getInstance().getApplicationName();
                    if (applicationName == null) {
                        applicationName = "";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set unspecified applicationName to " + applicationName);
                    }
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception caught: " + t.getMessage());
                }
            }
        }
        TrustClientPolicySetAttachments trustClientAttachment = null;
        trustClientAttachment = TrustClientPSUtils.getTrustClientPolicySetAttachments(applicationName);
        PolicySetConfiguration psc = null;
        psc = TrustClientHelperUtils.getPSC(trustProviderConfig, trustClientAttachment);
        ITrustRequestSecurityTokenResponseCollection rstrc = this.sendReceiveRSTRC(rst, trustProviderConfig, trustProperties, psc, trustRequestConfig);
        ArrayList<ITrustRequesterConfig> requestList = new ArrayList<ITrustRequesterConfig>();
        requestList.add(trustRequestConfig);
        securityTokens = TrustClientHelperUtils.processRSTRC(rstrc, requestList, trustProviderConfig.getIncludeRSTRProperties());
        return securityTokens;
    }

    public List<WSSTrustClientValidateResult> sendValidate(ITrustProviderConfig trustProviderConfig, ITrustRequesterConfig trustRequestConfig, TrustProperties trustProperties) throws SoapSecurityException {
        List<WSSTrustClientValidateResult> results = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        if (trustRequestConfig.getMessageID() == null) {
            trustRequestConfig.setMessageID(UUIDGenerator.getUUID());
        }
        ITrustRequestSecurityTokenTemplate rstt = this.getRequestSecurityTokenTemplate(trustRequestConfig);
        try {
            String applicationName;
            PolicySetConfiguration psc;
            ITrustRequestSecurityToken rst;
            block9: {
                rst = this.createRequestSecurityToken(rstt);
                psc = null;
                applicationName = TrustClientPSUtils.getApplicationName(trustProviderConfig);
                if (applicationName == null || applicationName.length() == 0) {
                    try {
                        applicationName = ConfigHelperFactory.getInstance().getApplicationName();
                        if (applicationName == null) {
                            applicationName = "";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Set unspecified applicationName to " + applicationName);
                        }
                    }
                    catch (Throwable t) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Exception caught: " + t.getMessage());
                    }
                }
            }
            TrustClientPolicySetAttachments trustClientAttachment = null;
            trustClientAttachment = TrustClientPSUtils.getTrustClientPolicySetAttachments(applicationName);
            psc = TrustClientHelperUtils.getPSC(trustProviderConfig, trustClientAttachment);
            ITrustRequestSecurityTokenResponseCollection rstrc = this.sendReceiveRSTRC(rst, trustProviderConfig, trustProperties, psc, trustRequestConfig);
            results = TrustClientHelperUtils.processValidateRSTRC(rstrc, trustRequestConfig, trustProviderConfig.getIncludeRSTRProperties());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw SoapSecurityException.format(e.getMessage());
        }
        return results;
    }

    public List<WSSTrustClientValidateResult> sendValidateList(ITrustProviderConfig trustProviderConfig, List<ITrustRequesterConfig> requestList, TrustProperties trustProperties) throws SoapSecurityException {
        String applicationName;
        PolicySetConfiguration psc;
        ITrustRequestSecurityTokenCollection rstc;
        List<WSSTrustClientValidateResult> results;
        block9: {
            results = null;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ISSUE_TOKEN_PERM);
            }
            if (requestList.get(0).getMessageID() == null) {
                requestList.get(0).setMessageID(UUIDGenerator.getUUID());
            }
            ArrayList<ITrustRequestSecurityTokenTemplate> rsttList = new ArrayList<ITrustRequestSecurityTokenTemplate>();
            for (ITrustRequesterConfig request : requestList) {
                ITrustRequestSecurityTokenTemplate rstt = this.getRequestSecurityTokenTemplate(request);
                rsttList.add(rstt);
            }
            ArrayList<ITrustRequestSecurityToken> rstList = new ArrayList<ITrustRequestSecurityToken>();
            for (ITrustRequestSecurityTokenTemplate rstt : rsttList) {
                ITrustRequestSecurityToken rst = this.createRequestSecurityToken(rstt);
                rstList.add(rst);
            }
            rstc = this.createRequestSecurityTokenCollection(rstList);
            psc = null;
            applicationName = TrustClientPSUtils.getApplicationName(trustProviderConfig);
            if (applicationName == null || applicationName.length() == 0) {
                try {
                    applicationName = ConfigHelperFactory.getInstance().getApplicationName();
                    if (applicationName == null) {
                        applicationName = "";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set unspecified applicationName to " + applicationName);
                    }
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Exception caught: " + t.getMessage());
                }
            }
        }
        TrustClientPolicySetAttachments trustClientAttachment = null;
        trustClientAttachment = TrustClientPSUtils.getTrustClientPolicySetAttachments(applicationName);
        psc = TrustClientHelperUtils.getPSC(trustProviderConfig, trustClientAttachment);
        ITrustRequestSecurityTokenResponseCollection rstrc = this.sendReceiveRSTRC(rstc, trustProviderConfig, trustProperties, psc, requestList.get(0));
        results = TrustClientHelperUtils.processValidateRSTRC(rstrc, requestList, trustProviderConfig.getIncludeRSTRProperties());
        return results;
    }
}

