/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.v13;

import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.impl.OMElementUtil;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.v13.Trust13RequestSecurityTokenResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust13RequestSecurityTokenResponseCollection
implements ITrustRequestSecurityTokenResponseCollection {
    List<ITrustRequestSecurityTokenResponse> rstrList = new ArrayList<ITrustRequestSecurityTokenResponse>();
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;

    public Trust13RequestSecurityTokenResponseCollection(Trust13RequestSecurityTokenResponse rstr) {
        String method = "Trust13RequestSecurityTokenResponseCollection()";
        this.rstrList.add(rstr);
    }

    public Trust13RequestSecurityTokenResponseCollection(OMElement omElement) throws TrustException {
        String method = "Trust13RequestSecurityTokenResponseCollection()";
        Trust13RequestSecurityTokenResponseCollection.logentry(method, "omElement: " + OMElementUtil.toString(omElement));
        OMNamespace omNamespace = omElement.getNamespace();
        if (omNamespace == null) {
            String error = "invalid_namespace";
            Trust13RequestSecurityTokenResponseCollection.logentry(method, error + ": null");
            throw TrustException.format(error, "null");
        }
        String namespace = omNamespace.getNamespaceURI();
        if (namespace == null || !namespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            Trust13RequestSecurityTokenResponseCollection.logentry(method, "omElement.getNamespace().getNamespaceURI(): " + namespace);
            Trust13RequestSecurityTokenResponseCollection.logentry(method, "should have been ITrustConstants.v13.NS_WST: http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            throw TrustException.format("invalid_namespace", namespace);
        }
        if (omElement.getLocalName().equals("RequestSecurityTokenResponseCollection")) {
            Iterator i = OMElementUtil.getChildrenWithName(omElement, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestSecurityTokenResponse");
            while (i.hasNext()) {
                OMElement rstr = (OMElement)i.next();
                log.logp(level, CLASSNAME, method, "rstrList.add: " + OMElementUtil.toString(rstr));
                Trust13RequestSecurityTokenResponse sts_rstr = new Trust13RequestSecurityTokenResponse(rstr);
                this.rstrList.add(sts_rstr);
            }
        } else if (omElement.getLocalName().equals("RequestSecurityTokenResponse")) {
            Trust13RequestSecurityTokenResponseCollection.logentry(method, "rstrList.add: " + OMElementUtil.toString(omElement));
            Trust13RequestSecurityTokenResponse sts_rstr = new Trust13RequestSecurityTokenResponse(omElement);
            this.rstrList.add(sts_rstr);
        }
        if (this.rstrList.size() == 0) {
            String error = "invalid_response_from_service";
            Trust13RequestSecurityTokenResponseCollection.logentry(method, error + ":  no RSTR found");
            throw TrustException.format(error, "No RSTR");
        }
    }

    @Override
    public Iterator<ITrustRequestSecurityTokenResponse> getRSTRCollection() {
        return this.rstrList.iterator();
    }

    private OMElement getChildWithName(OMElement body, String namespaceURI, String keyword) throws TrustException {
        String method = "getChildWithName()";
        Trust13RequestSecurityTokenResponseCollection.logentry(method, "body: " + OMElementUtil.toString(body));
        Trust13RequestSecurityTokenResponseCollection.logentry(method, "namespaceURI: " + namespaceURI);
        Trust13RequestSecurityTokenResponseCollection.logentry(method, "keyword: " + keyword);
        return OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(body, namespaceURI, keyword);
    }

    private static void logentry(String method, String msg) {
        int block = 1500;
        int lastchar = msg.length();
        log.logp(level, CLASSNAME, method, msg.substring(0, Trust13RequestSecurityTokenResponseCollection.min(lastchar, block)));
        if (lastchar >= block) {
            log.logp(level, CLASSNAME, method, msg.substring(block, Trust13RequestSecurityTokenResponseCollection.min(lastchar, block * 2)));
            if (lastchar >= block * 2) {
                log.logp(level, CLASSNAME, method, msg.substring(block * 2), Trust13RequestSecurityTokenResponseCollection.min(lastchar, block * 3));
                if (lastchar >= block * 3) {
                    log.logp(level, CLASSNAME, method, msg.substring(block * 3));
                }
            }
        }
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    static {
        level = Level.FINE;
        CLASSNAME = Trust13RequestSecurityTokenResponseCollection.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

