/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.v10draft;

import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.impl.OMElementUtil;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.v10draft.Trust10RequestSecurityTokenResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust10RequestSecurityTokenResponseCollection
implements ITrustRequestSecurityTokenResponseCollection {
    List<ITrustRequestSecurityTokenResponse> rstrList = new ArrayList<ITrustRequestSecurityTokenResponse>();
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;

    public Trust10RequestSecurityTokenResponseCollection(Trust10RequestSecurityTokenResponse rstr) {
        String method = "Trust10RequestSecurityTokenResponseCollection()";
        this.rstrList.add(rstr);
    }

    public Trust10RequestSecurityTokenResponseCollection(OMElement omElement) throws TrustException {
        this.init(omElement, null);
    }

    public Trust10RequestSecurityTokenResponseCollection(OMElement omElement, Properties clientOptions) throws TrustException {
        this.init(omElement, clientOptions);
    }

    public void init(OMElement omElement, Properties clientOptions) throws TrustException {
        OMNamespace omNamespace;
        String method = "Trust10RequestSecurityTokenResponseCollection:init()";
        Trust10RequestSecurityTokenResponseCollection.logentry(method, "omElement: " + OMElementUtil.toString(omElement));
        String tolerateWSFPMessages = null;
        if (clientOptions != null) {
            tolerateWSFPMessages = clientOptions.getProperty("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", "false");
        }
        if ((omNamespace = omElement.getNamespace()) == null) {
            if (tolerateWSFPMessages == null || !tolerateWSFPMessages.equals("true")) {
                String error = "invalid_namespace";
                Trust10RequestSecurityTokenResponseCollection.logentry(method, error + ": null");
                throw TrustException.format(error, "null");
            }
        } else {
            String namespace = omNamespace.getNamespaceURI();
            if (namespace == null || !namespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
                Trust10RequestSecurityTokenResponseCollection.logentry(method, "omElement.getNamespace().getNamespaceURI(): " + namespace);
                Trust10RequestSecurityTokenResponseCollection.logentry(method, "ITrustConstants.v10Draft.NS_WST: http://schemas.xmlsoap.org/ws/2005/02/trust");
                throw TrustException.format("invalid_namespace", namespace);
            }
        }
        if (omElement.getLocalName().equals("RequestSecurityTokenResponseCollection")) {
            Iterator i = OMElementUtil.getChildrenWithName(omElement, "http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestSecurityTokenResponse");
            while (i.hasNext()) {
                OMElement rstr = (OMElement)i.next();
                log.logp(level, CLASSNAME, method, "rstrList.add: " + OMElementUtil.toString(rstr));
                Trust10RequestSecurityTokenResponse sts_rstr = new Trust10RequestSecurityTokenResponse(rstr);
                this.rstrList.add(sts_rstr);
            }
        } else if (omElement.getLocalName().equals("RequestSecurityTokenResponse")) {
            Trust10RequestSecurityTokenResponseCollection.logentry(method, "rstrList.add: " + OMElementUtil.toString(omElement));
            Trust10RequestSecurityTokenResponse sts_rstr = new Trust10RequestSecurityTokenResponse(omElement);
            this.rstrList.add(sts_rstr);
        }
        if (this.rstrList.size() == 0) {
            String error = "invalid_response_from_service";
            Trust10RequestSecurityTokenResponseCollection.logentry(method, error + ":  no RSTR found");
            throw TrustException.format(error, "No RSTR");
        }
    }

    @Override
    public Iterator<ITrustRequestSecurityTokenResponse> getRSTRCollection() {
        return this.rstrList.iterator();
    }

    private OMElement getChildWithName(OMElement body, String namespaceURI, String keyword) throws TrustException {
        String method = "getChildWithName()";
        Trust10RequestSecurityTokenResponseCollection.logentry(method, "body: " + OMElementUtil.toString(body));
        Trust10RequestSecurityTokenResponseCollection.logentry(method, "namespaceURI: " + namespaceURI);
        Trust10RequestSecurityTokenResponseCollection.logentry(method, "keyword: " + keyword);
        return OMElementUtil.getOnlyChildWithLocalNameAndVerifyNamespace(body, namespaceURI, keyword);
    }

    private static void logentry(String method, String msg) {
        int block = 1500;
        int lastchar = msg.length();
        log.logp(level, CLASSNAME, method, msg.substring(0, Trust10RequestSecurityTokenResponseCollection.min(lastchar, block)));
        if (lastchar >= block) {
            log.logp(level, CLASSNAME, method, msg.substring(block, Trust10RequestSecurityTokenResponseCollection.min(lastchar, block * 2)));
            if (lastchar >= block * 2) {
                log.logp(level, CLASSNAME, method, msg.substring(block * 2), Trust10RequestSecurityTokenResponseCollection.min(lastchar, block * 3));
                if (lastchar >= block * 3) {
                    log.logp(level, CLASSNAME, method, msg.substring(block * 3));
                }
            }
        }
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    static {
        level = Level.FINE;
        CLASSNAME = Trust10RequestSecurityTokenResponseCollection.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

